/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.headers;

import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.serde.config.IdOption;
import io.apicurio.registry.serde.headers.DefaultHeadersHandlerConfig;
import io.apicurio.registry.serde.headers.HeadersHandler;
import io.apicurio.registry.utils.IoUtil;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class DefaultHeadersHandler
implements HeadersHandler {
    private String globalIdHeaderName;
    private String contentIdHeaderName;
    private String contentHashHeaderName;
    private String groupIdHeaderName;
    private String artifactIdHeaderName;
    private String versionHeaderName;
    private IdOption idOption;

    @Override
    public void configure(Map<String, Object> configs, boolean isKey) {
        DefaultHeadersHandlerConfig config = new DefaultHeadersHandlerConfig(configs);
        if (isKey) {
            this.globalIdHeaderName = config.getKeyGlobalIdHeader();
            this.contentIdHeaderName = config.getKeyContentIdHeader();
            this.contentHashHeaderName = config.getKeyContentHashHeader();
            this.groupIdHeaderName = config.getKeyGroupIdHeader();
            this.artifactIdHeaderName = config.getKeyArtifactIdHeader();
            this.versionHeaderName = config.getKeyVersionHeader();
        } else {
            this.globalIdHeaderName = config.getValueGlobalIdHeader();
            this.contentIdHeaderName = config.getValueContentIdHeader();
            this.contentHashHeaderName = config.getValueContentHashHeader();
            this.groupIdHeaderName = config.getValueGroupIdHeader();
            this.artifactIdHeaderName = config.getValueArtifactIdHeader();
            this.versionHeaderName = config.getValueVersionHeader();
        }
        if (config.useIdOption() != null) {
            this.idOption = config.useIdOption();
        }
    }

    @Override
    public void writeHeaders(Headers headers, ArtifactReference reference) {
        if (this.idOption == IdOption.globalId) {
            if (reference.getGlobalId() == null) {
                throw new SerializationException("Missing globalId. IdOption is globalId but there is no contentId in the ArtifactReference");
            }
            ByteBuffer buff = ByteBuffer.allocate(8);
            buff.putLong(reference.getGlobalId());
            headers.add(this.globalIdHeaderName, buff.array());
            return;
        }
        if (reference.getContentId() != null) {
            ByteBuffer buff = ByteBuffer.allocate(8);
            buff.putLong(reference.getContentId());
            headers.add(this.contentIdHeaderName, buff.array());
        } else {
            if (reference.getContentHash() != null) {
                headers.add(this.contentHashHeaderName, IoUtil.toBytes((String)reference.getContentHash()));
            }
            headers.add(this.groupIdHeaderName, IoUtil.toBytes((String)reference.getGroupId()));
            headers.add(this.artifactIdHeaderName, IoUtil.toBytes((String)reference.getArtifactId()));
            if (reference.getVersion() != null) {
                headers.add(this.versionHeaderName, IoUtil.toBytes((String)reference.getVersion()));
            }
        }
    }

    @Override
    public ArtifactReference readHeaders(Headers headers) {
        return ArtifactReference.builder().globalId(this.getGlobalId(headers)).contentId(this.getContentId(headers)).contentHash(this.getContentHash(headers)).groupId(this.getGroupId(headers)).artifactId(this.getArtifactId(headers)).version(this.getVersion(headers)).build();
    }

    private String getGroupId(Headers headers) {
        Header header = headers.lastHeader(this.groupIdHeaderName);
        if (header == null) {
            return null;
        }
        return IoUtil.toString((byte[])header.value());
    }

    private String getArtifactId(Headers headers) {
        Header header = headers.lastHeader(this.artifactIdHeaderName);
        if (header == null) {
            return null;
        }
        return IoUtil.toString((byte[])header.value());
    }

    private String getVersion(Headers headers) {
        Header header = headers.lastHeader(this.versionHeaderName);
        if (header == null) {
            return null;
        }
        return IoUtil.toString((byte[])header.value());
    }

    private Long getGlobalId(Headers headers) {
        Header header = headers.lastHeader(this.globalIdHeaderName);
        if (header == null) {
            return null;
        }
        return ByteBuffer.wrap(header.value()).getLong();
    }

    private Long getContentId(Headers headers) {
        Header header = headers.lastHeader(this.contentIdHeaderName);
        if (header == null) {
            return null;
        }
        return ByteBuffer.wrap(header.value()).getLong();
    }

    private String getContentHash(Headers headers) {
        Header header = headers.lastHeader(this.contentHashHeaderName);
        if (header == null) {
            return null;
        }
        return IoUtil.toString((byte[])header.value());
    }
}

