/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.versions;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameters;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.versions.item.WithVersionItemRequestBuilder;
import io.apicurio.registry.rest.client.v2.models.ArtifactContent;
import io.apicurio.registry.rest.client.v2.models.Error;
import io.apicurio.registry.rest.client.v2.models.RuleViolationError;
import io.apicurio.registry.rest.client.v2.models.VersionMetaData;
import io.apicurio.registry.rest.client.v2.models.VersionSearchResults;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class VersionsRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public WithVersionItemRequestBuilder byVersion(@Nonnull String version) {
        Objects.requireNonNull(version);
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(this.pathParameters);
        urlTplParams.put("version", version);
        return new WithVersionItemRequestBuilder(urlTplParams, this.requestAdapter);
    }

    public VersionsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}/versions{?limit*,offset*}", pathParameters);
    }

    public VersionsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}/versions{?limit*,offset*}", rawUrl);
    }

    @Nullable
    public VersionSearchResults get() {
        return this.get(null);
    }

    @Nullable
    public VersionSearchResults get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("404", Error::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (VersionSearchResults)this.requestAdapter.send(requestInfo, errorMapping, VersionSearchResults::createFromDiscriminatorValue);
    }

    @Nullable
    public VersionMetaData post(@Nonnull ArtifactContent body) {
        return this.post(body, null);
    }

    @Nullable
    public VersionMetaData post(@Nonnull ArtifactContent body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("404", Error::createFromDiscriminatorValue);
        errorMapping.put("409", RuleViolationError::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        return (VersionMetaData)this.requestAdapter.send(requestInfo, errorMapping, VersionMetaData::createFromDiscriminatorValue);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration(), x -> x.queryParameters);
        requestInfo.headers.tryAdd("Accept", "application/json");
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ArtifactContent body) {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ArtifactContent body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.POST, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PostRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/vnd.create.extended+json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public VersionsRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new VersionsRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PostRequestConfiguration
    extends BaseRequestConfiguration {
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
        @Nullable
        public GetQueryParameters queryParameters;

        public GetRequestConfiguration() {
            this.queryParameters = new GetQueryParameters();
        }
    }

    public class GetQueryParameters
    implements QueryParameters {
        @Nullable
        public Integer limit;
        @Nullable
        public Integer offset;

        @Nonnull
        public Map<String, Object> toQueryParameters() {
            HashMap<String, Object> allQueryParams = new HashMap<String, Object>();
            allQueryParams.put("limit", this.limit);
            allQueryParams.put("offset", this.offset);
            return allQueryParams;
        }
    }
}

