/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.v2.groups.item.artifacts.item.state;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.v2.models.Error;
import io.apicurio.registry.rest.client.v2.models.UpdateState;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class StateRequestBuilder
extends BaseRequestBuilder {
    public StateRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}/state", pathParameters);
    }

    public StateRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/groups/{groupId}/artifacts/{artifactId}/state", rawUrl);
    }

    public void put(@Nonnull UpdateState body) {
        this.put(body, null);
    }

    public void put(@Nonnull UpdateState body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = this.toPutRequestInformation(body, requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("400", Error::createFromDiscriminatorValue);
        errorMapping.put("404", Error::createFromDiscriminatorValue);
        errorMapping.put("500", Error::createFromDiscriminatorValue);
        this.requestAdapter.sendPrimitive(requestInfo, errorMapping, Void.class);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull UpdateState body) {
        return this.toPutRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPutRequestInformation(@Nonnull UpdateState body, @Nullable Consumer<PutRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation(HttpMethod.PUT, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new PutRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        return requestInfo;
    }

    @Nonnull
    public StateRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new StateRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class PutRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

