/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.client.ids.contenthashes.item;

import com.microsoft.kiota.BaseRequestBuilder;
import com.microsoft.kiota.BaseRequestConfiguration;
import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.serialization.ParsableFactory;
import io.apicurio.registry.rest.client.ids.contenthashes.item.references.ReferencesRequestBuilder;
import io.apicurio.registry.rest.client.models.ProblemDetails;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WithContentHashItemRequestBuilder
extends BaseRequestBuilder {
    @Nonnull
    public ReferencesRequestBuilder references() {
        return new ReferencesRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    public WithContentHashItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/ids/contentHashes/{contentHash}", pathParameters);
    }

    public WithContentHashItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        super(requestAdapter, "{+baseurl}/ids/contentHashes/{contentHash}", rawUrl);
    }

    @Nullable
    public InputStream get() {
        return this.get(null);
    }

    @Nullable
    public InputStream get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
        HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
        errorMapping.put("404", ProblemDetails::createFromDiscriminatorValue);
        errorMapping.put("500", ProblemDetails::createFromDiscriminatorValue);
        return (InputStream)this.requestAdapter.sendPrimitive(requestInfo, errorMapping, InputStream.class);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        RequestInformation requestInfo = new RequestInformation(HttpMethod.GET, this.urlTemplate, (Map)this.pathParameters);
        requestInfo.configure(requestConfiguration, () -> new GetRequestConfiguration());
        requestInfo.headers.tryAdd("Accept", "*/*, application/json");
        return requestInfo;
    }

    @Nonnull
    public WithContentHashItemRequestBuilder withUrl(@Nonnull String rawUrl) {
        Objects.requireNonNull(rawUrl);
        return new WithContentHashItemRequestBuilder(rawUrl, this.requestAdapter);
    }

    public class GetRequestConfiguration
    extends BaseRequestConfiguration {
    }
}

