/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver.client;

import io.apicurio.registry.resolver.ArtifactTypeToContentType;
import io.apicurio.registry.resolver.client.RegistryArtifactReference;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.client.RegistryVersionCoordinates;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.ArtifactReference;
import io.apicurio.registry.rest.client.models.CreateArtifact;
import io.apicurio.registry.rest.client.models.CreateArtifactResponse;
import io.apicurio.registry.rest.client.models.CreateVersion;
import io.apicurio.registry.rest.client.models.HandleReferencesType;
import io.apicurio.registry.rest.client.models.IfArtifactExists;
import io.apicurio.registry.rest.client.models.SortOrder;
import io.apicurio.registry.rest.client.models.VersionContent;
import io.apicurio.registry.rest.client.models.VersionMetaData;
import io.apicurio.registry.rest.client.models.VersionSearchResults;
import io.apicurio.registry.rest.client.models.VersionSortBy;
import io.apicurio.registry.rest.client.models.VersionState;
import io.apicurio.registry.utils.IoUtil;
import io.vertx.core.Vertx;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;

public class RegistryClientFacadeImpl
implements RegistryClientFacade {
    private final RegistryClient client;
    private Vertx vertx;

    public RegistryClientFacadeImpl(RegistryClient client) {
        this(client, null);
    }

    public RegistryClientFacadeImpl(RegistryClient client, Vertx vertx) {
        this.client = client;
        this.vertx = vertx;
    }

    public RegistryClient getClient() {
        return this.client;
    }

    @Override
    public String getSchemaByContentId(Long contentId) {
        InputStream rawSchema = this.client.ids().contentIds().byContentId(contentId).get();
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByContentId(long contentId) {
        List references = this.client.ids().contentIds().byContentId(Long.valueOf(contentId)).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public String getSchemaByGlobalId(long globalId, boolean dereferenced) {
        InputStream rawSchema = this.client.ids().globalIds().byGlobalId(Long.valueOf(globalId)).get(config -> {
            config.headers.add("CANONICAL", "false");
            assert (config.queryParameters != null);
            if (dereferenced) {
                config.queryParameters.references = HandleReferencesType.DEREFERENCE;
            }
        });
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByGlobalId(long globalId) {
        List references = this.client.ids().globalIds().byGlobalId(Long.valueOf(globalId)).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public String getSchemaByGAV(String groupId, String artifactId, String version) {
        InputStream rawSchema = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).content().get();
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByGAV(String groupId, String artifactId, String version) {
        List references = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public String getSchemaByContentHash(String contentHash) {
        InputStream rawSchema = this.client.ids().contentHashes().byContentHash(contentHash).get();
        return IoUtil.toString((InputStream)rawSchema);
    }

    @Override
    public List<RegistryArtifactReference> getReferencesByContentHash(String contentHash) {
        List references = this.client.ids().contentHashes().byContentHash(contentHash).references().get();
        return references.stream().map(RegistryArtifactReference::fromClientArtifactReference).toList();
    }

    @Override
    public List<RegistryVersionCoordinates> searchVersionsByContent(String schemaString, String artifactType, io.apicurio.registry.resolver.strategy.ArtifactReference reference, boolean canonical) {
        ByteArrayInputStream is = new ByteArrayInputStream(schemaString.getBytes(StandardCharsets.UTF_8));
        String ct = ArtifactTypeToContentType.toContentType(artifactType);
        VersionSearchResults results = this.client.search().versions().post((InputStream)is, ct, config -> {
            config.queryParameters.groupId = reference.getGroupId() == null ? "default" : reference.getGroupId();
            config.queryParameters.artifactId = reference.getArtifactId();
            config.queryParameters.canonical = canonical;
            config.queryParameters.artifactType = artifactType;
            config.queryParameters.orderby = VersionSortBy.GlobalId;
            config.queryParameters.order = SortOrder.Desc;
            config.queryParameters.limit = 100;
        });
        return results.getVersions().stream().filter(version -> VersionState.DISABLED != version.getState()).map(v -> RegistryVersionCoordinates.create(v.getGlobalId(), v.getContentId(), v.getGroupId(), v.getArtifactId(), v.getVersion())).toList();
    }

    @Override
    public RegistryVersionCoordinates createSchema(String artifactType, String groupId, String artifactId, String version, String autoCreateBehavior, boolean canonical, String schemaString, Set<RegistryArtifactReference> references) {
        CreateArtifact createArtifact = new CreateArtifact();
        createArtifact.setArtifactId(artifactId);
        createArtifact.setArtifactType(artifactType);
        CreateVersion createVersion = new CreateVersion();
        createVersion.setVersion(version);
        createArtifact.setFirstVersion(createVersion);
        VersionContent versionContent = new VersionContent();
        versionContent.setContent(schemaString);
        versionContent.setContentType(ArtifactTypeToContentType.toContentType(artifactType));
        if (references != null && !references.isEmpty()) {
            versionContent.setReferences(RegistryClientFacadeImpl.toClientReferences(references));
        }
        createVersion.setContent(versionContent);
        CreateArtifactResponse car = this.client.groups().byGroupId(groupId).artifacts().post(createArtifact, config -> {
            config.queryParameters.ifExists = IfArtifactExists.forValue((String)autoCreateBehavior);
            config.queryParameters.canonical = canonical;
        });
        return RegistryVersionCoordinates.create(car.getVersion().getGlobalId(), car.getVersion().getContentId(), car.getVersion().getGroupId(), car.getVersion().getArtifactId(), car.getVersion().getVersion());
    }

    @Override
    public RegistryVersionCoordinates getVersionCoordinatesByGAV(String groupId, String artifactId, String version) {
        if (version == null) {
            version = "branch=latest";
        }
        VersionMetaData vmd = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).get();
        return RegistryVersionCoordinates.create(vmd.getGlobalId(), vmd.getContentId(), vmd.getGroupId(), vmd.getArtifactId(), vmd.getVersion());
    }

    private static List<ArtifactReference> toClientReferences(Set<RegistryArtifactReference> references) {
        return references.stream().map(ref -> {
            ArtifactReference ar = new ArtifactReference();
            ar.setName(ref.getName());
            ar.setGroupId(ref.getGroupId());
            ar.setArtifactId(ref.getArtifactId());
            ar.setVersion(ref.getVersion());
            return ar;
        }).toList();
    }

    @Override
    public void close() throws Exception {
        if (this.vertx != null) {
            this.vertx.close();
            this.vertx = null;
        }
    }
}

