/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.client.RegistryClientFacade;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.serde.AbstractSerializer;
import io.apicurio.registry.serde.KafkaSerializer;
import io.apicurio.registry.serde.avro.AvroSerdeHeaders;
import io.apicurio.registry.serde.avro.AvroSerializer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.kafka.common.header.Headers;

public class AvroKafkaSerializer<U>
extends KafkaSerializer<Schema, U> {
    private AvroSerdeHeaders avroHeaders;

    public AvroKafkaSerializer() {
        super((AbstractSerializer)new AvroSerializer());
    }

    public AvroKafkaSerializer(RegistryClientFacade clientFacade) {
        super((AbstractSerializer)new AvroSerializer(clientFacade));
    }

    public AvroKafkaSerializer(SchemaResolver<Schema, U> schemaResolver) {
        super((AbstractSerializer)new AvroSerializer(schemaResolver));
    }

    public AvroKafkaSerializer(RegistryClientFacade clientFacade, SchemaResolver<Schema, U> schemaResolver) {
        super((AbstractSerializer)new AvroSerializer(clientFacade, schemaResolver));
    }

    public AvroKafkaSerializer(RegistryClientFacade clientFacade, ArtifactReferenceResolverStrategy<Schema, U> strategy, SchemaResolver<Schema, U> schemaResolver) {
        super((AbstractSerializer)new AvroSerializer(clientFacade, strategy, schemaResolver));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        this.avroHeaders = new AvroSerdeHeaders(isKey);
    }

    protected void serializeData(Headers headers, ParsedSchema<Schema> schema, U data, OutputStream out) throws IOException {
        if (headers != null) {
            this.avroHeaders.addEncodingHeader(headers, ((AvroSerializer)this.delegatedSerializer).getEncoding().name());
        }
        super.serializeData(headers, schema, data, out);
    }
}

