/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.IdHandler;
import io.apicurio.registry.serde.Legacy4ByteIdHandler;
import io.apicurio.registry.serde.SchemaResolverConfigurer;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.headers.HeadersHandler;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.errors.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKafkaSerDe<T, U>
extends SchemaResolverConfigurer<T, U> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final byte MAGIC_BYTE = 0;
    protected boolean key;
    protected IdHandler idHandler;
    protected HeadersHandler headersHandler;

    public AbstractKafkaSerDe() {
    }

    public AbstractKafkaSerDe(RegistryClient client) {
        super(client);
    }

    public AbstractKafkaSerDe(SchemaResolver<T, U> schemaResolver) {
        super(schemaResolver);
    }

    public AbstractKafkaSerDe(RegistryClient client, SchemaResolver<T, U> schemaResolver) {
        super(client, schemaResolver);
    }

    public abstract void configure(Map<String, ?> var1, boolean var2);

    protected void configure(BaseKafkaSerDeConfig config, boolean isKey) {
        super.configure(config.originals(), isKey, this.schemaParser());
        this.key = isKey;
        if (this.idHandler == null) {
            Object idh = config.getIdHandler();
            Utils.instantiate(IdHandler.class, (Object)idh, this::setIdHandler);
            if (config.enableConfluentIdHandler()) {
                if (this.idHandler != null && !(this.idHandler instanceof Legacy4ByteIdHandler)) {
                    this.log.warn(String.format("Duplicate id-handler configuration: %s vs. %s", idh, "as-confluent"));
                }
                this.setIdHandler(new Legacy4ByteIdHandler());
            }
        }
        this.idHandler.configure(config.originals(), isKey);
        boolean headersEnabled = config.enableHeaders();
        if (headersEnabled) {
            Object headersHandler = config.getHeadersHandler();
            Utils.instantiate(HeadersHandler.class, (Object)headersHandler, this::setHeadersHandler);
            this.headersHandler.configure(config.originals(), isKey);
        }
    }

    public abstract SchemaParser<T, U> schemaParser();

    public IdHandler getIdHandler() {
        return this.idHandler;
    }

    public void setHeadersHandler(HeadersHandler headersHandler) {
        this.headersHandler = headersHandler;
    }

    public void setIdHandler(IdHandler idHandler) {
        this.idHandler = Objects.requireNonNull(idHandler);
    }

    public void asLegacyId() {
        this.setIdHandler(new Legacy4ByteIdHandler());
    }

    public void reset() {
        this.schemaResolver.reset();
    }

    protected boolean isKey() {
        return this.key;
    }

    public static ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }
}

