/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.core.ext.internal.setuphandlers;

import com.ibm.ws.st.common.core.ext.internal.Activator;
import com.ibm.ws.st.common.core.ext.internal.Messages;
import com.ibm.ws.st.common.core.ext.internal.Trace;
import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandlerProvider;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.LocalHandler;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.common.core.ext.internal.util.RemoteDockerContainer;
import java.util.Collections;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.util.SocketUtil;

public class PlatformHandlerFactory {
    public static IPlatformHandler getPlatformHandler(Map<String, String> serviceInfo, PlatformType type) throws UnsupportedServiceException {
        Map<String, String> map = serviceInfo;
        if (map == null) {
            map = Collections.emptyMap();
        }
        String hostname = map.get("hostname");
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Attempting to find a handler for to match the host: " + hostname + " service information: " + PlatformHandlerFactory.getServiceInfoString(map));
        }
        switch (type) {
            case DOCKER: {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Retrieving Docker handler.");
                }
                String machineType = map.get("dockerMachineType");
                String machineName = map.get("dockerMachine");
                String containerName = map.get("dockerContainer");
                IPlatformHandler platformHandler = PlatformHandlerFactory.getPlatformHandler(serviceInfo, PlatformType.COMMAND);
                if (hostname == null || SocketUtil.isLocalhost((String)hostname)) {
                    if (Trace.ENABLED) {
                        String name = machineName == null ? containerName : containerName + " (" + machineName + ")";
                        Trace.trace((byte)0, "Creating a local docker container for: " + name);
                    }
                    return new BaseDockerContainer(containerName, machineType, machineName, platformHandler);
                }
                if (Trace.ENABLED) {
                    String name = machineName == null ? containerName : containerName + " (" + machineName + ")";
                    Trace.trace((byte)0, "Creating a remote docker container for: " + name);
                }
                return new RemoteDockerContainer(containerName, machineType, machineName, platformHandler);
            }
            case COMMAND: {
                if (hostname == null || SocketUtil.isLocalhost((String)hostname)) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Creating a local command handler.");
                    }
                    return new LocalHandler();
                }
            }
            case SSH_KEYLESS: {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Creating a remote command handler of type: " + PlatformType.SSH_KEYLESS.name());
                }
                try {
                    IPlatformHandlerProvider provider = Activator.getPlatformProvider(PlatformType.SSH_KEYLESS.name());
                    if (provider == null) {
                        throw new UnsupportedServiceException(NLS.bind((String)Messages.errorNoSupportedPlatformFound, (Object)((Object)type)));
                    }
                    return provider.init(serviceInfo);
                }
                catch (Throwable t) {
                    if (Trace.ENABLED) {
                        Trace.logError("The SSH Handler could not be created.", t);
                    }
                    throw new UnsupportedServiceException(NLS.bind((String)Messages.errorNoSupportedPlatformFound, (Object)((Object)type)));
                }
            }
        }
        throw new UnsupportedServiceException(NLS.bind((String)Messages.errorNoSupportedPlatformFound, (Object)((Object)type)));
    }

    private static String getServiceInfoString(Map<String, String> serviceInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, String> entry : serviceInfo.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            sb.append("(" + key + " : " + value + ") ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static enum PlatformType {
        COMMAND,
        SSH_KEYLESS,
        DOCKER;

    }
}

