/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.wizard;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class NewServerNameComposite
extends Composite {
    protected IRuntime runtime;
    protected WebSphereRuntime websphereRuntime;
    protected IWizardHandle wizard;
    protected Combo userDir;
    protected Text serverNameText;
    protected String[] serverNames;
    protected String createServerName = null;
    protected List<UserDirectory> userDirs;
    protected UserDirectory selectedUserDir;
    protected boolean fillDefaultServerName;
    protected Combo template;
    protected String[] serverTemplates;
    protected String selectedTemplate;
    protected String archivePath;
    private static HashMap<String, String> templateCache = new HashMap();

    protected NewServerNameComposite(Composite parent, IWizardHandle wizard, boolean fillDefaultServerName) {
        super(parent, 0);
        this.wizard = wizard;
        this.fillDefaultServerName = fillDefaultServerName;
        wizard.setImageDescriptor(Activator.getImageDescriptor("wizServer"));
        this.createControl();
    }

    protected void setRuntime(IRuntime newRuntime, UserDirectory userDir, String archivePath) {
        if (newRuntime == null) {
            this.runtime = null;
            this.websphereRuntime = null;
            this.selectedUserDir = null;
            this.archivePath = null;
        } else {
            this.runtime = newRuntime;
            this.websphereRuntime = (WebSphereRuntime)this.runtime.loadAdapter(WebSphereRuntime.class, null);
            this.selectedUserDir = userDir;
            this.archivePath = archivePath;
        }
        this.init();
        this.validate();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "com.ibm.ws.st.ui.twnr0000");
        Label label = new Label((Composite)this, 0);
        label.setText(Messages.userDirectory);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.userDir = new Combo((Composite)this, 8);
        this.userDir.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!NewServerNameComposite.this.userDirs.isEmpty()) {
                    NewServerNameComposite.this.selectedUserDir = NewServerNameComposite.this.userDirs.get(NewServerNameComposite.this.userDir.getSelectionIndex());
                    NewServerNameComposite.this.validate();
                }
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(Messages.serverName);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.serverNameText = new Text((Composite)this, 2048);
        this.serverNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewServerNameComposite.this.createServerName = NewServerNameComposite.this.serverNameText.getText();
                NewServerNameComposite.this.validate();
            }
        });
        label = new Label((Composite)this, 0);
        label.setText(Messages.template);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.template = new Combo((Composite)this, 8);
        this.template.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.template.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewServerNameComposite.this.selectedTemplate = NewServerNameComposite.this.template.getItem(NewServerNameComposite.this.template.getSelectionIndex());
            }
        });
        this.init();
        this.validate();
        Dialog.applyDialogFont((Control)this);
        this.serverNameText.forceFocus();
    }

    protected void init() {
        this.wizard.setTitle(Messages.wizServerNameTitle);
        this.wizard.setDescription(Messages.wizServerNameDescription);
        if (this.serverNameText == null || this.runtime == null) {
            return;
        }
        if (this.websphereRuntime != null) {
            ArrayList<String> userPathStr = new ArrayList<String>();
            this.userDirs = this.websphereRuntime.getUserDirectories();
            if (this.userDirs.isEmpty()) {
                this.selectedUserDir = null;
                this.userDir.setItems(new String[]{this.websphereRuntime.getRuntime().getName()});
                this.userDir.select(0);
            } else {
                int userDirIndex = 0;
                if (this.selectedUserDir == null) {
                    this.selectedUserDir = this.userDirs.get(0);
                } else {
                    for (int i = 0; i < this.userDirs.size(); ++i) {
                        if (!this.userDirs.get(i).equals((Object)this.selectedUserDir)) continue;
                        userDirIndex = i;
                    }
                }
                for (UserDirectory ud : this.userDirs) {
                    if (ud.getProject() != null) {
                        userPathStr.add(ud.getProject().getName());
                        continue;
                    }
                    userPathStr.add(ud.getPath().toOSString());
                }
                this.userDir.setEnabled(true);
                this.userDir.setItems(userPathStr.toArray(new String[userPathStr.size()]));
                this.userDir.select(userDirIndex);
            }
            this.serverNames = this.websphereRuntime.getServerNames();
            if (this.fillDefaultServerName && this.createServerName == null) {
                String defaultName = "defaultServer";
                if (this.selectedUserDir != null) {
                    IPath serverPath = this.selectedUserDir.getServersPath();
                    int i = 2;
                    while (serverPath.append(defaultName).toFile().exists()) {
                        defaultName = "defaultServer_" + i;
                        ++i;
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)0, "Calculating default server name: " + defaultName);
                    }
                }
                this.serverNameText.setText(defaultName);
                this.createServerName = defaultName;
            }
            this.serverTemplates = this.getServerTemplates();
            this.template.setItems(this.serverTemplates);
            if (this.serverTemplates.length > 0) {
                int index = -1;
                index = templateCache.containsKey(this.websphereRuntime.getRuntime().getId()) ? this.template.indexOf(templateCache.get(this.websphereRuntime.getRuntime().getId())) : this.template.indexOf("defaultServer");
                if (index == -1) {
                    index = 0;
                }
                this.template.select(index);
                this.selectedTemplate = this.template.getItem(index);
            }
            if (this.serverTemplates.length <= 1) {
                this.template.setEnabled(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getServerTemplates() {
        String[] templates = this.websphereRuntime.getServerTemplates();
        if (templates != null && templates.length > 0 || this.archivePath == null) {
            return templates;
        }
        File archiveFile = new File(this.archivePath);
        if (!archiveFile.exists()) {
            return templates;
        }
        ZipFile jar = null;
        try {
            String[] entry;
            jar = new ZipFile(archiveFile);
            Enumeration<? extends ZipEntry> enu = jar.entries();
            ArrayList<String> templateList = new ArrayList<String>();
            while (enu.hasMoreElements()) {
                int index1;
                entry = enu.nextElement();
                String name = entry.getName().toLowerCase();
                if (!name.contains("templates/servers/") || !name.endsWith("server.xml") || (name = name.substring(0, index1 = name.lastIndexOf(47))).endsWith("templates/servers")) continue;
                int index2 = name.lastIndexOf(47);
                templateList.add(entry.getName().substring(index2 + 1, index1));
            }
            entry = templateList.isEmpty() ? new String[]{} : templateList.toArray(new String[templateList.size()]);
            return entry;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Failed to get server templates from " + this.archivePath, e);
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            block16: {
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) break block16;
                        Trace.trace((byte)1, "Trouble closing zip file", e);
                    }
                }
            }
        }
    }

    protected void validate() {
        String serverName;
        IStatus status;
        if (this.runtime == null) {
            this.wizard.setMessage("", 3);
            return;
        }
        if (this.userDirs.isEmpty()) {
            File f = this.runtime.getLocation().toFile();
            boolean isExistingFolder = f.exists();
            if (isExistingFolder) {
                String[] s = f.list();
                boolean bl = isExistingFolder = s != null && s.length > 0;
            }
            if (isExistingFolder) {
                this.wizard.setMessage(NLS.bind((String)Messages.infoNoUsrDirs, (Object)this.websphereRuntime.getDefaultUserDirPath().toOSString()), 1);
                return;
            }
        }
        if ((status = WebSphereServer.validateServerName((String)(serverName = this.serverNameText.getText()))) == null || status.isOK()) {
            if (serverName == null || serverName.trim().isEmpty()) {
                this.wizard.setMessage("", 3);
                return;
            }
            IPath serverPath = null;
            if (this.selectedUserDir != null) {
                serverPath = this.selectedUserDir.getServersPath();
            } else if (this.websphereRuntime != null) {
                serverPath = this.websphereRuntime.getDefaultUserDirPath().append("servers");
            }
            if (serverPath != null && serverPath.append(serverName).toFile().exists()) {
                this.wizard.setMessage(Messages.errorServerNameExists, 3);
                return;
            }
        }
        if (status == null || status.isOK()) {
            this.wizard.setMessage(null, 0);
        } else if (status.getSeverity() == 2) {
            this.wizard.setMessage(status.getMessage(), 2);
        } else {
            this.wizard.setMessage(status.getMessage(), 3);
        }
        this.wizard.update();
    }

    public String getServerName() {
        return this.createServerName;
    }

    public UserDirectory getUserDir() {
        return this.selectedUserDir;
    }

    protected void createServer(IProgressMonitor monitor) throws CoreException {
        int count = 100;
        monitor.beginTask(NLS.bind((String)com.ibm.ws.st.core.internal.Messages.taskServerCreate, (Object)this.createServerName), count);
        if (this.selectedUserDir == null) {
            List userDirList = this.websphereRuntime.getUserDirectories();
            if (!userDirList.isEmpty()) {
                for (UserDirectory ud : userDirList) {
                    if (!this.websphereRuntime.getDefaultUserDirPath().equals((Object)ud.getPath())) continue;
                    this.selectedUserDir = ud;
                    break;
                }
            }
            if (this.selectedUserDir == null) {
                SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 40);
                count = 60;
                this.selectedUserDir = this.websphereRuntime.createDefaultUserDirectory((IProgressMonitor)subMonitor);
                if (this.selectedUserDir == null) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openError((Shell)shell, (String)Messages.title, (String)NLS.bind((String)Messages.failedCreateDefaultUserDir, (Object)this.websphereRuntime.getDefaultUserDirPath().toOSString()));
                    monitor.done();
                    return;
                }
            }
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, count - 10);
        String tplToCache = this.selectedTemplate != null ? this.selectedTemplate : "defaultServer";
        templateCache.put(this.websphereRuntime.getRuntime().getId(), tplToCache);
        this.websphereRuntime.createServer(this.createServerName, this.selectedTemplate, this.selectedUserDir.getPath(), (IProgressMonitor)subMonitor);
        if (this.selectedUserDir.getProject() != null) {
            subMonitor = new SubProgressMonitor(monitor, 10);
            this.selectedUserDir.getProject().refreshLocal(2, (IProgressMonitor)subMonitor);
        }
        monitor.done();
    }

    protected boolean isValid() {
        return this.isDisposed() ? false : this.wizard.getMessageType() != 3;
    }
}

