/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.utility;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.ContentAssistCombo;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.SWTUtil;
import com.ibm.ws.st.ui.internal.utility.UtilityWizardPage;
import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PackageWizardPage
extends UtilityWizardPage {
    public static final String PREF_PATHS = "package.path";
    private static final String PREF_OVERWRITE = "package.overwrite";
    private static final String PREF_INCLUDE = "package.include";
    private static final String ALL = "all";
    private static final String MINIFY = "minify";
    private static final String USR = "usr";
    protected ContentAssistCombo folder;
    protected String exportPath;
    protected boolean overwrite;
    protected String include;
    protected boolean isServerStarted;
    protected boolean publishServer;

    public PackageWizardPage(WebSphereServerInfo server) {
        super(server);
        this.setTitle(Messages.wizPackageTitle);
        this.setDescription(Messages.wizPackageDescription);
    }

    @Override
    public void createUtilityControl(Composite comp) {
        String[] stringArray;
        boolean includeMinify;
        Group archiveGroup = new Group(comp, 0);
        archiveGroup.setText(Messages.wizPackageExport);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        archiveGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 128, true, false);
        data.horizontalSpan = 3;
        archiveGroup.setLayoutData((Object)data);
        List<String> previousLocations = Activator.getPreferenceList(PREF_PATHS);
        this.folder = new ContentAssistCombo((Composite)archiveGroup, previousLocations);
        this.folder.setLayoutData(new GridData(4, 0x1000000, true, false));
        if (previousLocations != null && !previousLocations.isEmpty()) {
            String s = previousLocations.get(0);
            this.folder.setText(s);
            this.exportPath = s;
        }
        this.folder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackageWizardPage.this.exportPath = PackageWizardPage.this.folder.getText();
                PackageWizardPage.this.setPageComplete(PackageWizardPage.this.validate());
            }
        });
        Button browse = SWTUtil.createButton((Composite)archiveGroup, Messages.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String file;
                FileDialog dialog = new FileDialog(PackageWizardPage.this.getShell(), 8196);
                dialog.setFilterExtensions(new String[]{"*.zip", "*.jar"});
                String pathString = PackageWizardPage.this.folder.getText();
                if (pathString != null && !pathString.isEmpty()) {
                    Path path = new Path(pathString);
                    if (!path.toFile().isDirectory()) {
                        String fileName = path.lastSegment();
                        if (fileName != null && !fileName.isEmpty()) {
                            dialog.setFileName(fileName);
                        }
                        path = path.removeLastSegments(1);
                    }
                    if (!path.isEmpty() && path.toFile().isDirectory()) {
                        dialog.setFilterPath(path.toOSString());
                    }
                }
                if ((file = dialog.open()) != null) {
                    PackageWizardPage.this.folder.setText(file);
                }
            }
        });
        final Button overwriteButton = new Button((Composite)archiveGroup, 32);
        overwriteButton.setText(Messages.wizPackageOverwrite);
        data = new GridData(1, 0x1000000, false, false);
        data.horizontalSpan = 2;
        overwriteButton.setLayoutData((Object)data);
        String overwritePref = Activator.getPreference(PREF_OVERWRITE, null);
        if ("true".equals(overwritePref)) {
            overwriteButton.setSelection(true);
            this.overwrite = true;
        }
        overwriteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PackageWizardPage.this.overwrite = overwriteButton.getSelection();
            }
        });
        Label label = new Label(comp, 0);
        label.setText(Messages.wizPackageInclude);
        data = new GridData(1, 0x1000000, false, false);
        data.verticalIndent = 8;
        label.setLayoutData((Object)data);
        final Combo includeCombo = new Combo(comp, 8);
        String version = this.wsRuntime.getRuntimeVersion();
        boolean bl = includeMinify = version == null || !version.startsWith("8.5.0");
        if (includeMinify) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = ALL;
            stringArray2[1] = MINIFY;
            stringArray = stringArray2;
            stringArray2[2] = USR;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = ALL;
            stringArray = stringArray3;
            stringArray3[1] = USR;
        }
        final String[] includeOptions = stringArray;
        includeCombo.add(Messages.wizPackageIncludeAll);
        if (includeMinify) {
            includeCombo.add(Messages.wizPackageIncludeMinify);
        }
        includeCombo.add(Messages.wizPackageIncludeUsr);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 8;
        includeCombo.setLayoutData((Object)data);
        includeCombo.select(0);
        String includePref = Activator.getPreference(PREF_INCLUDE, includeOptions[0]);
        for (int i = 0; i < includeOptions.length && this.include == null; ++i) {
            if (!includeOptions[i].equals(includePref)) continue;
            includeCombo.select(i);
            this.include = includeOptions[i];
        }
        includeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                PackageWizardPage.this.include = includeOptions[includeCombo.getSelectionIndex()];
            }
        });
        new Label(comp, 0);
        label = new Label(comp, 0);
        label.setText(Messages.wizPackageIncludeCommonMessage);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        try {
            if (this.wsServer != null) {
                this.isServerStarted = this.wsServer.isLocalSetup() ? this.wsRuntime.isServerStarted(this.server, null) : this.wsServer.getServer().getServerState() == 2;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    protected String getUserMessage() {
        return Messages.wizPackageMessage;
    }

    @Override
    protected boolean validate() {
        File f;
        if (this.isServerStarted) {
            this.setMessage(Messages.errorPackageServerRunning, 3);
            return false;
        }
        if (this.exportPath == null || this.exportPath.isEmpty()) {
            this.setMessage(null, 3);
            return false;
        }
        if (!this.exportPath.endsWith(".zip") && !this.exportPath.endsWith(".jar")) {
            this.exportPath = this.exportPath + ".zip";
        }
        if (!(f = new File(this.exportPath)).isAbsolute()) {
            f = this.server.getServerOutputPath().append(this.exportPath).toFile();
        }
        if (f.exists() && f.isDirectory()) {
            this.setMessage(Messages.errorPackageInvalidFile, 3);
            return false;
        }
        return super.validate();
    }

    @Override
    public boolean preFinish() {
        File f;
        if (!this.exportPath.endsWith(".zip") && !this.exportPath.endsWith(".jar")) {
            this.exportPath = this.exportPath + ".zip";
        }
        if (!(f = new File(this.exportPath)).isAbsolute()) {
            f = this.server.getServerOutputPath().append(this.exportPath).toFile();
        }
        if (f.exists() && !this.overwrite && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.wizPackageTitle, (String)NLS.bind((String)Messages.wizPackageFileExists, (Object)this.exportPath))) {
            return false;
        }
        String version = this.wsServer.getWebSphereRuntime().getRuntimeVersion();
        if (version != null && version != "8.5.0.0" && this.wsServer.getServer().getServerPublishState() != 1) {
            this.publishServer = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.wizPackageTitle, (String)Messages.notifyPublishRequired);
        }
        return true;
    }

    @Override
    public void finish(IProgressMonitor monitor) throws Exception {
        File archiveFile = new File(this.exportPath);
        Activator.addToPreferenceList(PREF_PATHS, this.exportPath);
        Activator.setPreference(PREF_OVERWRITE, this.overwrite ? "true" : "false");
        Activator.setPreference(PREF_INCLUDE, this.include);
        this.wsRuntime.packageServer(this.server, archiveFile, this.include, this.publishServer, monitor);
    }
}

