/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.merge;

import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class MergedConfigResourceListener
implements IResourceChangeListener {
    private static MergedConfigResourceListener listener;

    public static synchronized void start() {
        if (listener != null) {
            return;
        }
        listener = new MergedConfigResourceListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
    }

    public static synchronized void stop() {
        if (listener == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)listener);
        }
        listener = null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        block3: {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                delta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta visitorDelta) {
                        switch (visitorDelta.getKind()) {
                            case 4: {
                                return true;
                            }
                            case 2: {
                                IResource resource = visitorDelta.getResource();
                                IPath location = ConfigUtils.getMergedConfigLocation((IResource)resource);
                                if (location == null || !location.toFile().exists()) break;
                                File file = location.toFile();
                                if (file.isDirectory()) {
                                    try {
                                        FileUtil.deleteDirectory((String)file.getCanonicalPath(), (boolean)true);
                                    }
                                    catch (IOException e) {
                                        if (!Trace.ENABLED) break;
                                        Trace.trace((byte)1, "Failed to delete merged configuration container: " + location, e);
                                    }
                                    break;
                                }
                                if (file.delete() || !Trace.ENABLED) break;
                                Trace.trace((byte)1, "Failed to delete merged configuration file: " + location);
                                break;
                            }
                        }
                        return false;
                    }
                });
            }
            catch (CoreException e) {
                if (!Trace.ENABLED) break block3;
                Trace.trace((byte)1, "Error in merged config resource listener.", e);
            }
        }
    }
}

