/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import com.ibm.ws.st.ui.internal.marker.SupersedeFeatureDialog;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class QuickFixSupersedeFeature
extends AbstractMarkerResolution {
    private final String feature;

    public QuickFixSupersedeFeature(String feature) {
        this.feature = feature;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.supersededFeatureQuickFix, (Object[])new String[]{this.feature});
    }

    public void run(IMarker marker) {
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        String[] replacementFeatures = this.getReplacementFeatures(configFile);
        if (replacementFeatures == null) {
            return;
        }
        try {
            configFile.removeFeature(this.feature);
            for (String s : replacementFeatures) {
                configFile.addFeature(s);
            }
            configFile.save(null);
        }
        catch (IOException e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix to supersede feature failed. Error trying to update configuration: " + configFile.getURI(), e);
            }
            this.showErrorMessage();
        }
    }

    private String[] getReplacementFeatures(ConfigurationFile configFile) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SupersedeFeatureDialog dialog = null;
        WebSphereRuntime webSphereRuntime = null;
        if (configFile.getWebSphereServer() != null) {
            dialog = new SupersedeFeatureDialog(shell, configFile.getWebSphereServer(), this.feature);
        } else {
            UserDirectory userDirectory = configFile.getUserDirectory();
            if (userDirectory != null) {
                webSphereRuntime = userDirectory.getWebSphereRuntime();
                dialog = new SupersedeFeatureDialog(shell, webSphereRuntime, configFile, this.feature);
            }
            if (dialog == null) {
                return null;
            }
        }
        if (dialog.open() == 1) {
            return null;
        }
        return dialog.getReplacementFeatures();
    }

    @Override
    protected String getErrorMessage() {
        return Messages.featureChangeFailedMessage;
    }
}

