/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.marker;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import com.ibm.ws.st.ui.internal.marker.AbstractMarkerResolution;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.osgi.util.NLS;

public class QuickFixBestMatchFactoryRef
extends AbstractMarkerResolution {
    private final String bestMatch;
    private final String itemName;
    private final int itemIndex;

    public QuickFixBestMatchFactoryRef(String bestMatch, String itemName, int itemIndex) {
        this.bestMatch = bestMatch;
        this.itemName = itemName;
        this.itemIndex = itemIndex;
    }

    public String getLabel() {
        return NLS.bind((String)Messages.factoryIdNotFoundQuickFix, (Object[])new String[]{this.bestMatch});
    }

    public void run(IMarker marker) {
        String xpath = marker.getAttribute("xpathAttr", "");
        IFile resource = this.getResource(marker);
        if (resource == null) {
            return;
        }
        ConfigurationFile configFile = this.getConfigFile((IResource)resource);
        if (configFile == null) {
            return;
        }
        if (configFile.changeFactoryRef(xpath, this.bestMatch, this.itemName, this.itemIndex)) {
            try {
                configFile.save(null);
            }
            catch (IOException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)6, "Quick fix for factory id not found failed. Error trying to save configuration file: " + configFile.getURI(), e);
                }
                this.showErrorMessage();
            }
        } else {
            if (Trace.ENABLED) {
                Trace.trace((byte)6, "Quick fix for factory id not found failed. Error trying to change factory reference '" + xpath + "'in configuration: " + configFile.getURI(), null);
            }
            this.showErrorMessage();
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.changeFactoryRefFailedMessage;
    }
}

