/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.download;

import com.ibm.ws.st.core.internal.repository.IProduct;
import com.ibm.ws.st.core.internal.repository.IRuntimeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractProduct
implements IProduct {
    protected static final String PROP_PROVIDE_FEATURE = "provideFeature";
    protected static final String PROP_REQUIRE_FEATURE = "requireFeature";
    private static final Map<String, IProduct.Type> TYPE_MAP = new HashMap<String, IProduct.Type>();
    protected final Map<String, String> properties;
    protected final List<Map<String, String>> productList;
    private List<String> provideFeature;
    private List<String> requireFeature;

    private static IProduct.Type getTypeFor(String name) {
        IProduct.Type type = TYPE_MAP.get(name);
        return type != null ? type : IProduct.Type.UNKNOWN;
    }

    AbstractProduct(Map<String, String> properties, List<Map<String, String>> productList) {
        this.properties = properties;
        this.productList = productList;
    }

    public String getName() {
        return this.properties.get("name");
    }

    public String getDescription() {
        return this.properties.get("description");
    }

    public IProduct.Type getType() {
        return AbstractProduct.getTypeFor(this.properties.get("type"));
    }

    public List<String> getProvideFeature() {
        if (this.provideFeature == null) {
            this.provideFeature = this.processFeatureProperty(this.properties.get(PROP_PROVIDE_FEATURE));
        }
        return this.provideFeature;
    }

    public List<String> getRequireFeature() {
        if (this.requireFeature == null) {
            this.requireFeature = this.processFeatureProperty(this.properties.get(PROP_REQUIRE_FEATURE));
        }
        return this.requireFeature;
    }

    public String getAttribute(String property) {
        return this.properties.get(property);
    }

    public IRuntimeInfo getRuntimeInfo() {
        if (this.getType() != IProduct.Type.INSTALL) {
            return null;
        }
        final ArrayList<IRuntimeInfo.IProduct> products = new ArrayList<IRuntimeInfo.IProduct>();
        for (Map<String, String> prop : this.productList) {
            products.add(AbstractProduct.createProduct(prop));
        }
        return new IRuntimeInfo(){

            public List<IRuntimeInfo.IProduct> getProducts() {
                return products;
            }

            public String getVersion() {
                return ((IRuntimeInfo.IProduct)products.get(0)).getProductVersion();
            }

            public String getPrimaryProductId() {
                return ((IRuntimeInfo.IProduct)products.get(0)).getProductId();
            }

            public List<String> getInstalledFeatures() {
                return Collections.emptyList();
            }

            public IPath getLocation() {
                return null;
            }

            public boolean isOnPremiseSupported() {
                return "true".equals(AbstractProduct.this.properties.get("onPremise"));
            }
        };
    }

    private static IRuntimeInfo.IProduct createProduct(final Map<String, String> prop) {
        return new IRuntimeInfo.IProduct(){

            public String getProductId() {
                return (String)prop.get("productId");
            }

            public String getProductVersion() {
                return (String)prop.get("productVersion");
            }

            public String getProductEdition() {
                return (String)prop.get("productEdition");
            }

            public String getProductInstallType() {
                return (String)prop.get("productInstallType");
            }

            public String getProductLicenseType() {
                String licenseType = (String)prop.get("licenseType");
                return licenseType == null ? "ILAN" : licenseType;
            }
        };
    }

    private List<String> processFeatureProperty(String featureProp) {
        if (featureProp == null || featureProp.isEmpty()) {
            return Collections.emptyList();
        }
        String[] features = featureProp.split(",");
        ArrayList<String> list = new ArrayList<String>(features.length);
        for (String f : features) {
            String feature = f.replaceAll("\\s", "");
            int index = feature.indexOf(59);
            if (index == -1) {
                list.add(feature);
                continue;
            }
            String featureAtts = feature.substring(index + 1, feature.length());
            if (featureAtts.indexOf("visibility:=") != -1 && !featureAtts.contains("visibility:=public")) continue;
            list.add(feature.substring(0, index));
        }
        return list;
    }

    public String getHashSHA256() {
        return null;
    }

    public boolean isInstallOnlyFeature() {
        return false;
    }

    static {
        TYPE_MAP.put("install", IProduct.Type.INSTALL);
        TYPE_MAP.put("feature", IProduct.Type.FEATURE);
        TYPE_MAP.put("sample", IProduct.Type.SAMPLE);
        TYPE_MAP.put("addon", IProduct.Type.EXTENDED);
        TYPE_MAP.put("opensource", IProduct.Type.OPEN_SOURCE);
        TYPE_MAP.put("ifix", IProduct.Type.IFIX);
    }
}

