/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.config;

import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.config.ConfigUIUtils;
import com.ibm.xwt.dde.customization.IAdvancedCustomizationObject;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IncludeLink
implements IAdvancedCustomizationObject {
    public String invoke(String value, Node node, Element closestAncestor, IEditorPart editorPart) {
        if (value == null || value.trim().length() == 0) {
            return null;
        }
        IEditorInput input = editorPart.getEditorInput();
        URI uri = ConfigUIUtils.getURI(input);
        if (uri != null) {
            URI includeURI = null;
            WebSphereServerInfo serverInfo = ConfigUtils.getServerInfo((URI)uri);
            if (serverInfo != null) {
                includeURI = serverInfo.resolve(uri, value);
            } else {
                UserDirectory userDir = ConfigUtils.getUserDirectory((URI)uri);
                if (userDir != null) {
                    includeURI = userDir.resolve(uri, value);
                }
            }
            if (includeURI != null) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile iFile = workspaceRoot.getFileForLocation((IPath)new Path(includeURI.getPath()));
                if (iFile != null && iFile.exists()) {
                    Activator.openConfigurationEditor(iFile, includeURI);
                } else {
                    File file = new File(includeURI);
                    if (file.exists()) {
                        Activator.openConfigurationEditor(null, includeURI);
                    }
                }
            }
        }
        return null;
    }
}

