/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.ui.internal.Trace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.wst.validation.internal.ui.ValidationMenuAction;
import org.eclipse.wst.validation.internal.ui.ValidationUIMessages;
import org.w3c.dom.Element;

public class ValidateConfigAction
extends SelectionProviderAction {
    private final ValidationMenuAction delegate = new ValidationMenuAction();

    protected ValidateConfigAction(ISelectionProvider provider) {
        super(provider, ValidationUIMessages.Validate);
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel == null || sel.size() != 1) {
            this.setEnabled(false);
            return;
        }
        StructuredSelection configFileSelection = null;
        for (Object obj : sel) {
            if (!(obj instanceof Element)) continue;
            Element element = (Element)obj;
            try {
                if (!"server".equals(element.getTagName())) continue;
                WebSphereServerInfo wsi = (WebSphereServerInfo)Platform.getAdapterManager().getAdapter(obj, WebSphereServerInfo.class);
                if (wsi != null) {
                    configFileSelection = new StructuredSelection(new Object[]{wsi.getConfigRoot().getIFile()});
                } else {
                    IFile configFile = (IFile)Platform.getAdapterManager().getAdapter(obj, IFile.class);
                    if (configFile != null) {
                        configFileSelection = new StructuredSelection(new Object[]{configFile});
                    }
                }
                this.delegate.selectionChanged((IAction)this, (ISelection)configFileSelection);
            }
            catch (Exception e) {
                Trace.logError(((Object)((Object)this)).getClass().getSimpleName() + ".updateSelection", e);
                return;
            }
        }
        this.setEnabled(configFileSelection != null);
    }

    public void run() {
        this.delegate.run((IAction)this);
    }
}

