/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal.actions;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.Trace;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;
import org.eclipse.wst.server.core.IServer;

public class ShowInServersAction
extends SelectionProviderAction {
    private static final String SERVERS_VIEW_ID = "org.eclipse.wst.server.ui.ServersView";
    private IServer server;

    public ShowInServersAction(ISelectionProvider sp) {
        super(sp, "Servers");
        IViewRegistry reg = PlatformUI.getWorkbench().getViewRegistry();
        IViewDescriptor desc = reg.find(SERVERS_VIEW_ID);
        this.setText(desc.getLabel());
        this.setImageDescriptor(desc.getImageDescriptor());
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        if (sel.isEmpty()) {
            this.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (Object obj : sel) {
            if (obj instanceof WebSphereServerInfo) {
                WebSphereServer[] servers;
                WebSphereServerInfo serverInfo = (WebSphereServerInfo)obj;
                String serverName = serverInfo.getServerName();
                this.server = null;
                for (WebSphereServer ws : servers = WebSphereUtil.getWebSphereServers()) {
                    if (!serverName.equals(ws.getServerName())) continue;
                    this.server = ws.getServer();
                }
                enabled = this.server != null;
                continue;
            }
            this.setEnabled(false);
            return;
        }
        this.setEnabled(enabled);
    }

    public void run() {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IViewPart part = page.findView(SERVERS_VIEW_ID);
            if (part == null) {
                try {
                    part = page.showView(SERVERS_VIEW_ID);
                }
                catch (PartInitException e) {
                    Trace.logError("Could not open servers view", e);
                }
            }
            if (part != null) {
                page.activate((IWorkbenchPart)part);
                CommonNavigator view = (CommonNavigator)part.getAdapter(CommonNavigator.class);
                if (view != null) {
                    view.setFocus();
                    view.selectReveal((ISelection)new StructuredSelection((Object)this.server));
                }
            }
        }
    }
}

