/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.ui.internal.actions.NewQuickServerAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.eclipse.wst.server.core.IRuntime;

public class ServerDropAdapter
extends CommonDropAdapterAssistant {
    private List<WebSphereServerInfo> serverList;

    public IStatus validateDrop(Object target, int operation, TransferData transferData) {
        ISelection s;
        if (target instanceof IWorkspaceRoot && LocalSelectionTransfer.getTransfer().isSupportedType(transferData) && !(s = LocalSelectionTransfer.getTransfer().getSelection()).isEmpty() && s instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)s;
            Iterator elements = sel.iterator();
            this.serverList = new ArrayList<WebSphereServerInfo>(sel.size());
            while (elements.hasNext()) {
                WebSphereServer[] servers;
                Object obj = elements.next();
                if (!(obj instanceof WebSphereServerInfo)) continue;
                WebSphereServerInfo server = (WebSphereServerInfo)obj;
                String serverName = server.getServerName();
                IRuntime runtime = server.getWebSphereRuntime().getRuntime();
                for (WebSphereServer ws : servers = WebSphereUtil.getWebSphereServers()) {
                    if (!runtime.equals(ws.getServer().getRuntime()) || !serverName.equals(ws.getServerName())) continue;
                    return Status.CANCEL_STATUS;
                }
                this.serverList.add(server);
            }
            if (this.serverList.size() == sel.size()) {
                return Status.OK_STATUS;
            }
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent dropTargetEvent, Object target) {
        for (WebSphereServerInfo server : this.serverList) {
            NewQuickServerAction.createServer(server, null);
        }
        return Status.OK_STATUS;
    }
}

