/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.LibertyConfigSyncConflictHandler;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import com.ibm.ws.st.ui.internal.Trace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LibertyUIConfigConflictHandler
extends LibertyConfigSyncConflictHandler {
    public LibertyConfigSyncConflictHandler.Resolution handleConflict(List<LibertyConfigSyncConflictHandler.Pair> conflictFiles, IPath tempDirectory, JMXConnection jmxConnection, String remoteConfigRoot) throws Exception {
        LibertyConfigSyncConflictHandler.Resolution res = null;
        boolean isConfigRootFile = false;
        StringBuffer modifiedFiles = new StringBuffer();
        for (LibertyConfigSyncConflictHandler.Pair pair : conflictFiles) {
            String file = pair.getRight().replace('\\', '/');
            if (remoteConfigRoot != null && remoteConfigRoot.equals(file)) {
                isConfigRootFile = true;
            }
            modifiedFiles.append(file + "\n");
        }
        res = isConfigRootFile ? this.showConflictDialogWithCompareOption(modifiedFiles.toString()) : this.showConflictDialog(modifiedFiles.toString());
        if (res != null && res == LibertyConfigSyncConflictHandler.Resolution.MERGE) {
            final ArrayList<LibertyConfigSyncConflictHandler.Pair> comparableFiles = new ArrayList<LibertyConfigSyncConflictHandler.Pair>();
            for (LibertyConfigSyncConflictHandler.Pair p : conflictFiles) {
                String remoteFilePath = p.getRight();
                Path remotePath = new Path(remoteFilePath);
                String name = remotePath.lastSegment();
                File tmpFile = tempDirectory.append("tmpRemote" + name).toFile();
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
                String downloadCopy = tmpFile.getAbsolutePath();
                jmxConnection.downloadFile(remoteFilePath, downloadCopy);
                comparableFiles.add(new LibertyConfigSyncConflictHandler.Pair(p.getLeft(), downloadCopy));
            }
            final String string = jmxConnection.getHost();
            final int[] mergeResult = new int[]{0};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = Display.getDefault().getActiveShell();
                    ConfigCompareDialog compareDialog = new ConfigCompareDialog(shell, Messages.configSyncCompareMessage, 0, comparableFiles, string);
                    mergeResult[0] = compareDialog.open();
                }
            });
            switch (mergeResult[0]) {
                case 0: {
                    res = LibertyConfigSyncConflictHandler.Resolution.MERGE;
                    break;
                }
                case 1: {
                    res = LibertyConfigSyncConflictHandler.Resolution.CANCEL;
                }
            }
        }
        return res;
    }

    private LibertyConfigSyncConflictHandler.Resolution showConflictDialogWithCompareOption(final String files) {
        LibertyConfigSyncConflictHandler.Resolution res = null;
        final int[] result = new int[]{1};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog dlg = new MessageDialog(shell, Messages.title, null, NLS.bind((String)Messages.configSyncConflicts, (Object)files.replace("\\", "/")), 3, new String[]{Messages.configSyncCompare, Messages.configSyncOverwriteRemote, Messages.configSyncCancelButton}, 0);
                result[0] = dlg.open();
            }
        });
        switch (result[0]) {
            case 0: {
                res = LibertyConfigSyncConflictHandler.Resolution.MERGE;
                break;
            }
            case 1: {
                res = LibertyConfigSyncConflictHandler.Resolution.OVERWRITE_REMOTE;
                break;
            }
            case 2: {
                res = LibertyConfigSyncConflictHandler.Resolution.CANCEL;
            }
        }
        return res;
    }

    private LibertyConfigSyncConflictHandler.Resolution showConflictDialog(final String files) {
        LibertyConfigSyncConflictHandler.Resolution res = null;
        final int[] result = new int[]{0};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                MessageDialog dlg = new MessageDialog(shell, Messages.title, null, NLS.bind((String)Messages.configSyncConflicts, (Object)files.replace("\\", "/")), 3, new String[]{Messages.configSyncOverwriteRemote, Messages.configSyncCancelButton}, 0);
                result[0] = dlg.open();
            }
        });
        switch (result[0]) {
            case 0: {
                res = LibertyConfigSyncConflictHandler.Resolution.OVERWRITE_REMOTE;
                break;
            }
            case 1: {
                res = LibertyConfigSyncConflictHandler.Resolution.CANCEL;
            }
        }
        return res;
    }

    class ConfigCompareDialog
    extends TitleAreaDialog {
        protected String message;
        protected int style;
        protected List<LibertyConfigSyncConflictHandler.Pair> comparableFiles;
        protected String hostname;
        protected TextMergeViewer textMerge;
        protected File localFile;
        protected File remoteFileCopy;

        public ConfigCompareDialog(Shell parentShell, String message, int style, List<LibertyConfigSyncConflictHandler.Pair> comparableFiles, String hostname) {
            super(parentShell);
            this.textMerge = null;
            this.message = message;
            this.style = style;
            this.comparableFiles = comparableFiles;
            this.hostname = hostname;
            this.setTitleImage(Activator.getImage("wizServer"));
            this.setHelpAvailable((style & 0x10) != 0);
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
            LibertyConfigSyncConflictHandler.Pair initialComparison = comparableFiles.get(0);
            this.localFile = new File(initialComparison.getLeft());
            this.remoteFileCopy = new File(initialComparison.getRight());
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.title);
            this.setShellStyle(16);
        }

        protected Control createDialogArea(Composite parent) {
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.numColumns = 1;
            GridData data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            this.setTitle(Messages.configSyncCompare);
            this.setMessage(this.message);
            Composite comp = new Composite(parent, 0);
            comp.setLayout((Layout)layout);
            comp.setLayoutData((Object)data);
            data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            CompareConfiguration cc = new CompareConfiguration();
            cc.setLeftLabel(NLS.bind((String)Messages.configSyncCompareLeftLabel, (Object)this.localFile.getName()));
            cc.setRightLabel(NLS.bind((String)Messages.configSyncCompareLeftLabel, (Object)this.remoteFileCopy.getName()));
            CompareViewerPane pane = new CompareViewerPane(comp, 0);
            pane.setLayoutData((Object)data);
            data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            this.textMerge = new TextMergeViewer((Composite)pane, cc);
            pane.setContent(this.textMerge.getControl());
            this.textMerge.getControl().setLayoutData((Object)data);
            this.textMerge.setContentProvider((IContentProvider)new IMergeViewerContentProvider(){

                public void dispose() {
                }

                public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                }

                public Object getAncestorContent(Object arg0) {
                    return null;
                }

                public Image getAncestorImage(Object arg0) {
                    return null;
                }

                public String getAncestorLabel(Object arg0) {
                    return null;
                }

                public Object getLeftContent(Object arg0) {
                    String content = this.readFileContents(ConfigCompareDialog.this.localFile);
                    return new Document(content);
                }

                public Image getLeftImage(Object arg0) {
                    return null;
                }

                public String getLeftLabel(Object arg0) {
                    return NLS.bind((String)Messages.configSyncCompareLeftLabel, (Object)ConfigCompareDialog.this.localFile.getName());
                }

                public Object getRightContent(Object arg0) {
                    String content = this.readFileContents(ConfigCompareDialog.this.remoteFileCopy);
                    return new Document(content);
                }

                public Image getRightImage(Object arg0) {
                    return null;
                }

                public String getRightLabel(Object arg0) {
                    return NLS.bind((String)Messages.configSyncCompareRightLabel, (Object)ConfigCompareDialog.this.localFile.getName(), (Object)ConfigCompareDialog.this.hostname);
                }

                public boolean isLeftEditable(Object arg0) {
                    return true;
                }

                public boolean isRightEditable(Object arg0) {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void saveLeftContent(Object input, byte[] bytes) {
                    FileOutputStream fos = null;
                    try {
                        fos = new FileOutputStream(ConfigCompareDialog.this.localFile, false);
                        fos.write(bytes);
                    }
                    catch (IOException e) {
                        Trace.logError("Couldn't save merges to local file: " + ConfigCompareDialog.this.localFile.getAbsolutePath(), e);
                    }
                    finally {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }

                public void saveRightContent(Object arg0, byte[] arg1) {
                }

                public boolean showAncestor(Object arg0) {
                    return false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private String readFileContents(File file) {
                    String content = null;
                    Scanner scanner = null;
                    try {
                        scanner = new Scanner(file);
                        content = scanner.useDelimiter("\\Z").next();
                    }
                    catch (Exception e) {
                        Trace.logError("Could not read local file contents: " + ConfigCompareDialog.this.localFile.getAbsolutePath(), e);
                    }
                    finally {
                        if (scanner != null) {
                            try {
                                scanner.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    return content;
                }
            });
            return comp;
        }

        protected Control createButtonBar(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 0;
            layout.makeColumnsEqualWidth = true;
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            GridData data = new GridData(132);
            data.grabExcessHorizontalSpace = true;
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            if (this.isHelpAvailable()) {
                Control helpControl = this.createHelpControl(composite);
                ((GridData)helpControl.getLayoutData()).horizontalIndent = this.convertHorizontalDLUsToPixels(7);
            }
            this.createButton(composite, 0, Messages.configSyncPublishButton, true);
            this.createButton(composite, 1, Messages.configSyncCancelButton, false);
            return composite;
        }

        protected void okPressed() {
            if (this.textMerge != null && this.textMerge.internalIsLeftDirty()) {
                this.textMerge.flushLeft((IProgressMonitor)new NullProgressMonitor());
            }
            super.okPressed();
        }

        protected Point getInitialSize() {
            return new Point(800, 600);
        }
    }
}

