/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.ui.internal;

import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.URILocation;
import com.ibm.ws.st.ui.internal.Activator;
import com.ibm.ws.st.ui.internal.Messages;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;

public class ConfigHyperlink
implements IHyperlink {
    private final IRegion region;
    private final URILocation location;
    private final String name;

    public ConfigHyperlink(IRegion region, URILocation location, String name) {
        this.region = region;
        this.location = location;
        this.name = name;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        String msgKey = Messages.open;
        if (this.location instanceof DocumentLocation) {
            switch (((DocumentLocation)this.location).getType()) {
                case SERVER_XML: {
                    msgKey = Messages.openConfigFileEditor;
                    break;
                }
                case BOOTSTRAP: {
                    msgKey = Messages.openBootstrapPropertiesEditor;
                    break;
                }
                case SERVER_ENV: {
                    msgKey = Messages.openServerEnvEditor;
                    break;
                }
            }
        }
        return NLS.bind((String)msgKey, (Object)this.name);
    }

    public void open() {
        if (this.location instanceof DocumentLocation) {
            DocumentLocation docLocation = (DocumentLocation)this.location;
            IEditorPart editorPart = Activator.openEditor(docLocation);
            if (editorPart != null) {
                Activator.goToLocation(editorPart, docLocation);
            }
        } else {
            Activator.open(this.location);
        }
    }

    public String toString() {
        return "Link " + this.name + " resolved to  " + this.location.getLocationString();
    }
}

