/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FeatureResolverResultImpl
implements FeatureResolver.Result {
    protected final Set<String> _missing = new HashSet<String>(0);
    protected final Set<String> _missingRoots = new HashSet<String>(0);
    protected final Set<String> _missingReferences = new HashSet<String>(0);
    protected final Map<String, Set<List<String>>> _unlabelledResources = new HashMap<String, Set<List<String>>>(0);
    protected final Map<String, Set<IncompleteResolution>> _incompleteFeatures = new HashMap<String, Set<IncompleteResolution>>(0);
    protected final Set<String> _nonPublicRoots = new HashSet<String>(0);
    protected final Map<String, FeatureResolver.Chain> _wrongProcessTypes = new HashMap<String, FeatureResolver.Chain>(0);
    protected final Set<String> _wrongRootProcessTypes = new HashSet<String>(0);
    protected final Map<String, Set<FeatureResolver.Chain>> _wrongResolvedProcessTypes = new HashMap<String, Set<FeatureResolver.Chain>>(0);
    protected final Map<String, Collection<FeatureResolver.Chain>> _conflicts = new HashMap<String, Collection<FeatureResolver.Chain>>(0);
    protected final HashMap<String, String> _versionlessFeatures;
    protected final HashSet<String> _resolvedPlatforms;
    protected final HashSet<String> _missingPlatforms = new HashSet(0);
    protected final Map<String, Set<String>> _duplicatePlatforms = new HashMap<String, Set<String>>(0);
    protected final Map<String, Set<String>> _noPlatformVersionless = new HashMap<String, Set<String>>(0);
    protected final Set<String> _resolved;

    public static void trace(String message) {
        FeatureResolverImpl.trace(message);
    }

    public FeatureResolverResultImpl() {
        this._versionlessFeatures = new HashMap(0);
        this._resolvedPlatforms = new HashSet(0);
        this._resolved = new LinkedHashSet<String>();
    }

    @Override
    public boolean hasErrors() {
        return !this._missing.isEmpty() || !this._nonPublicRoots.isEmpty() || !this._wrongProcessTypes.isEmpty() || !this._conflicts.isEmpty() || this._versionlessFeatures.values().contains(null) || !this._missingPlatforms.isEmpty() || !this._duplicatePlatforms.isEmpty();
    }

    @Trivial
    private static String describeChain(FeatureResolver.Chain chain) {
        String featureName = chain.getFeatureRequirement();
        List<String> candidates = chain.getCandidates();
        List<String> resolutionPath = chain.getChain();
        StringBuilder builder = new StringBuilder();
        builder.append("Resolution [ ");
        builder.append(featureName);
        builder.append(" : ");
        builder.append(candidates);
        builder.append(" ]: ");
        builder.append(resolutionPath);
        return builder.toString();
    }

    @Trivial
    private static String describeResolutionPath(Collection<String> chain) {
        StringBuilder builder = new StringBuilder();
        builder.append("Resolution [ ");
        boolean isFirst = true;
        for (String featureName : chain) {
            if (!isFirst) {
                builder.append(", ");
            } else {
                isFirst = false;
            }
            builder.append(featureName);
        }
        builder.append(" ]: ");
        return builder.toString();
    }

    @Override
    public Set<String> getMissing() {
        return this._missing;
    }

    protected void addMissing(String missingFeature) {
        if (this._missing.add(missingFeature)) {
            FeatureResolverResultImpl.trace("Missing feature [ " + missingFeature + " ]");
        }
    }

    protected void addMissingRoot(String featureName) {
        if (this._missingRoots.add(featureName)) {
            FeatureResolverResultImpl.trace("Root feature [ " + featureName + " ] is missing.");
        }
        this.addMissing(featureName);
    }

    protected void addMissingReference(String featureName) {
        if (this._missingReferences.add(featureName)) {
            FeatureResolverResultImpl.trace("Missing referenced feature [ " + featureName + " ]");
        }
        this.addMissing(featureName);
    }

    private static List<String> copy(Deque<String> chain) {
        ArrayList<String> copyChain = new ArrayList<String>(chain.size());
        for (String featureName : chain) {
            copyChain.add(featureName);
        }
        return copyChain;
    }

    protected void addUnlabelledResource(FeatureResource resource, Deque<String> chain) {
        String location = resource.getLocation();
        Set<List<String>> chains = this._unlabelledResources.get(location);
        if (chains == null) {
            chains = new HashSet<List<String>>(1);
            this._unlabelledResources.put(location, chains);
        }
        chains.add(FeatureResolverResultImpl.copy(chain));
        FeatureResolverResultImpl.trace("Resource [ " + location + " ] has no symbolic name.");
        FeatureResolverResultImpl.trace(FeatureResolverResultImpl.describeResolutionPath(chain));
        this.addMissing(location);
    }

    protected void addIncomplete(String symbolicName, List<String> candidates, Collection<String> chain) {
        Set<IncompleteResolution> resolutions = this._incompleteFeatures.get(symbolicName);
        if (resolutions == null) {
            resolutions = new HashSet<IncompleteResolution>(1);
            this._incompleteFeatures.put(symbolicName, resolutions);
        }
        IncompleteResolution resolution = new IncompleteResolution(symbolicName, candidates, chain);
        resolutions.add(resolution);
        FeatureResolverResultImpl.trace("Feature [ " + symbolicName + " ] with candidates [ " + candidates + " ] has no resolutions for the process type.");
        FeatureResolverResultImpl.trace(FeatureResolverResultImpl.describeResolutionPath(chain));
        this.addMissing(symbolicName);
    }

    @Override
    public Set<String> getNonPublicRoots() {
        return this._nonPublicRoots;
    }

    protected void addNonPublicRoot(String nonPublicRoot) {
        if (this._nonPublicRoots.add(nonPublicRoot)) {
            FeatureResolverResultImpl.trace("Root feature [ " + nonPublicRoot + " ] is not public.");
        }
    }

    @Override
    public Map<String, FeatureResolver.Chain> getWrongProcessTypes() {
        return this._wrongProcessTypes;
    }

    protected void addWrongProcessType(String symbolicName, String preferredVersion) {
        FeatureResolver.Chain chain = new FeatureResolver.Chain(symbolicName, preferredVersion);
        if (this._wrongProcessTypes.put(symbolicName, chain) == null) {
            FeatureResolverResultImpl.trace("Incompatible process type for feature [ " + symbolicName + " ]");
        }
    }

    protected void addWrongProcessType(String symbolicName, FeatureResolver.Chain chain) {
        if (this._wrongProcessTypes.put(symbolicName, chain) == null) {
            FeatureResolverResultImpl.trace("Incompatible process type for feature [" + symbolicName + " ].");
            FeatureResolverResultImpl.trace(FeatureResolverResultImpl.describeChain(chain));
        }
    }

    protected void addWrongRootFeatureType(String featureName) {
        if (this._wrongRootProcessTypes.add(featureName)) {
            FeatureResolverResultImpl.trace("Root feature [ " + featureName + " ] does not match the process type.");
        }
        String preferredVersion = FeatureResolverImpl.parseVersion(featureName);
        this.addWrongProcessType(featureName, preferredVersion);
    }

    protected void addWrongResolvedFeatureType(String featureName, FeatureResolver.Chain chain) {
        Set<FeatureResolver.Chain> chains = this._wrongResolvedProcessTypes.get(featureName);
        if (chains == null) {
            chains = new HashSet<FeatureResolver.Chain>(1);
            this._wrongResolvedProcessTypes.put(featureName, chains);
        }
        chains.add(chain);
        FeatureResolverResultImpl.trace("Resolved feature [ " + featureName + " ] does not match the process type.");
        FeatureResolverResultImpl.trace(FeatureResolverResultImpl.describeChain(chain));
        this.addWrongProcessType(featureName, chain);
    }

    @Override
    public Map<String, Collection<FeatureResolver.Chain>> getConflicts() {
        return this._conflicts;
    }

    protected void addConflict(String baseFeatureName, Collection<FeatureResolver.Chain> conflicts) {
        FeatureResolverResultImpl.trace("Resolution conflicts for feature [ " + baseFeatureName + " ]:");
        for (FeatureResolver.Chain conflictChain : conflicts) {
            FeatureResolverResultImpl.trace(FeatureResolverResultImpl.describeChain(conflictChain));
        }
        this._conflicts.put(baseFeatureName, conflicts);
    }

    public HashMap<String, String> getVersionlessFeatures() {
        return this._versionlessFeatures;
    }

    protected void addVersionlessFeature(String versionlessFeature, String versionedFeature) {
        this._versionlessFeatures.put(versionlessFeature, versionedFeature);
    }

    public HashSet<String> getResolvedPlatforms() {
        return this._resolvedPlatforms;
    }

    protected void addResolvedPlatform(String platform) {
        this._resolvedPlatforms.add(platform);
    }

    protected void emptyResolvedPlatforms() {
        this._resolvedPlatforms.clear();
    }

    public HashSet<String> getMissingPlatforms() {
        return this._missingPlatforms;
    }

    protected void addMissingPlatform(String platform) {
        this._missingPlatforms.add(platform);
    }

    @Override
    public Map<String, Set<String>> getDuplicatePlatforms() {
        return this._duplicatePlatforms;
    }

    protected void addDuplicatePlatforms(String compatibleFeature, Set<String> platforms) {
        this._duplicatePlatforms.put(compatibleFeature, platforms);
    }

    @Override
    public Map<String, Set<String>> getNoPlatformVersionless() {
        return this._noPlatformVersionless;
    }

    protected void addNoPlatformVersionless(String compatibleFeature, Set<String> features) {
        this._noPlatformVersionless.put(compatibleFeature, features);
    }

    @Override
    public Set<String> getResolvedFeatures() {
        return this._resolved;
    }

    protected FeatureResolverResultImpl setResolvedFeatures(Collection<String> resolved) {
        this._resolved.clear();
        this._resolved.addAll(resolved);
        return this;
    }

    public static class IncompleteResolution {
        public final String symbolicName;
        public final List<String> candidates;
        public final List<String> chain;

        public IncompleteResolution(String baseName, Collection<String> candidates, Collection<String> chain) {
            this.symbolicName = baseName;
            this.candidates = new ArrayList<String>(candidates);
            this.chain = new ArrayList<String>(chain);
        }
    }
}

