/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.security;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.Trace;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.Random;
import javax.net.ssl.SSLContext;

public class LibertySecurityHelper {
    public static boolean validateSocketProtocol(String protocol) {
        Provider[] providers;
        String[] invalidProtocols = new String[]{"SSL", "SSLv2", "SSLv3", "TLS", "TLSv1", "TLSv1.1", "SSL_TLS", "SSL_TLSv2", "SSLv2Hello"};
        if (Arrays.asList(invalidProtocols).contains(protocol)) {
            if (Trace.ENABLED) {
                Trace.trace((byte)9, "The protocol: '" + protocol + "' is not supported.");
            }
            return false;
        }
        for (Provider provider : providers = Security.getProviders()) {
            Provider.Service service = provider.getService(SSLContext.class.getSimpleName(), protocol);
            if (service == null) continue;
            return true;
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)9, "The protocol: '" + protocol + "' is not supported.");
        }
        return false;
    }

    public static SSLContext getSSLContext() throws NoSuchAlgorithmException {
        String defaultProtocol = "TLSv1.2";
        String protocol = null;
        String activatorProtocol = Activator.getPreference("socket.protocol", null);
        String userProvidedProtocol = System.getProperty("SECURITY_SOCKET_PROTOCOL");
        if (userProvidedProtocol != null && LibertySecurityHelper.validateSocketProtocol(userProvidedProtocol)) {
            protocol = userProvidedProtocol;
        }
        if (protocol == null && activatorProtocol != null && LibertySecurityHelper.validateSocketProtocol(activatorProtocol)) {
            protocol = activatorProtocol;
        }
        if (protocol == null) {
            if (Trace.ENABLED) {
                LibertySecurityHelper.validateSocketProtocol(defaultProtocol);
            }
            protocol = defaultProtocol;
        }
        return SSLContext.getInstance(protocol);
    }

    public static String generatePassword() {
        String charStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        char[] chars = charStr.toCharArray();
        StringBuilder builder = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 30; ++i) {
            int index = random.nextInt(charStr.length());
            builder.append(chars[index]);
        }
        return builder.toString();
    }
}

