/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.XMLWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationFilterUtil {
    private static final String VALIDATION_SETTINGS_FOLDER = ".settings";
    private static final String VALIDATION_SETTINGS_FILE = "com.ibm.ws.st.validation.xml";
    private static final String ELEMENT_VALIDATION_FILTER = "validationFilter";

    public static Document loadSettings(IProject project) {
        return ValidationFilterUtil.loadSettings(project, false);
    }

    public static Document loadSettings(IProject project, boolean toCreateInitialDoc) {
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "ValidationFilterUtil.loadSettings");
        }
        if (project == null || !project.isAccessible()) {
            if (Trace.ENABLED && project != null) {
                Trace.trace((byte)2, "Project is not accessible: " + project);
            }
            return null;
        }
        IFile file = project.getFolder(VALIDATION_SETTINGS_FOLDER).getFile(VALIDATION_SETTINGS_FILE);
        if (!file.exists()) {
            if (toCreateInitialDoc) {
                return ValidationFilterUtil.createInitialDocument();
            }
            return null;
        }
        if (file.isAccessible()) {
            return ValidationFilterUtil.loadSettings(file);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)2, "File is not accessible: " + file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadSettings(IFile file) {
        InputStream in = null;
        Document doc = null;
        try {
            in = file.getContents();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException e) throws SAXException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Warning while reading validation ignore settings - " + e.getMessage());
                    }
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Error while reading validation ignore settings - " + e.getMessage());
                    }
                }

                @Override
                public void error(SAXParseException e) throws SAXException {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)1, "Error while reading validation ignore settings - " + e.getMessage());
                    }
                }
            });
            doc = parser.parse(in);
        }
        catch (SAXException factory) {
        }
        catch (Exception e) {
            Trace.logError("Could not load validation ingore settings: " + file.getLocationURI(), e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        if (doc != null && doc.getDocumentElement() != null) {
            return doc;
        }
        return null;
    }

    private static Document createInitialDocument() {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Trace.logError("Failed to create a document builder", e);
            return null;
        }
        Document doc = builder.newDocument();
        try {
            Element docElement = doc.createElement(ELEMENT_VALIDATION_FILTER);
            doc.appendChild(docElement);
        }
        catch (DOMException e) {
            Trace.logError("Failed to create intial document", e);
            return null;
        }
        return doc;
    }

    public static boolean saveSettings(IProject project, Document doc) {
        IStatus status;
        IFile file;
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "ValidationFilterUtil.saveSettings");
        }
        if (project == null || !project.isAccessible()) {
            if (Trace.ENABLED && project != null) {
                Trace.trace((byte)2, "Project is not accessible: " + project);
            }
            return false;
        }
        IFolder folder = project.getFolder(VALIDATION_SETTINGS_FOLDER);
        if (!folder.exists()) {
            try {
                folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                Trace.logError("Failed to create folder: " + folder, e);
                return false;
            }
        }
        if ((file = folder.getFile(VALIDATION_SETTINGS_FILE)).exists() && file.isReadOnly() && (status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).getSeverity() == 4) {
            Trace.logError("validateEdit failed for: " + file, new CoreException(status));
            return false;
        }
        return ValidationFilterUtil.saveSettings(file, doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean saveSettings(IFile file, Document doc) {
        InputStream in = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLWriter p = new XMLWriter((OutputStream)out, file.getProject());
            p.print(doc);
            p.flush();
            in = new ByteArrayInputStream(out.toByteArray());
            if (file.exists()) {
                file.setContents(in, true, true, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create(in, true, (IProgressMonitor)new NullProgressMonitor());
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Trace.logError("Failed to save file: " + file.getLocationURI(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Trace.logError("Failed to save file: " + file.getLocationURI(), e);
            }
        }
    }

    public static boolean ignoreAllAttributes(IResource resource) {
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        Document doc = ValidationFilterUtil.loadSettings(project, true);
        if (doc == null) {
            return false;
        }
        Element docElem = doc.getDocumentElement();
        String pathString = ValidationFilterUtil.getRelativePathString(project, resource);
        Element matchElem = ValidationFilterUtil.addElement(doc, docElem, "match");
        ValidationFilterUtil.addElement(doc, matchElem, "file", "path", pathString);
        ValidationFilterUtil.addElement(doc, matchElem, "ignore", "pattern", "UNREC_ATTR");
        return ValidationFilterUtil.saveSettings(project, doc);
    }

    public static boolean ignoreAllAttributes(IResource resource, String elemName) {
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        Document doc = ValidationFilterUtil.loadSettings(project, true);
        if (doc == null) {
            return false;
        }
        Element docElem = doc.getDocumentElement();
        String pathString = ValidationFilterUtil.getRelativePathString(project, resource);
        Element matchElem = ValidationFilterUtil.addElement(doc, docElem, "match");
        ValidationFilterUtil.addElement(doc, matchElem, "file", "path", pathString);
        ValidationFilterUtil.addElement(doc, matchElem, "ignore", "pattern", "UNREC_ATTR");
        ValidationFilterUtil.addElement(doc, matchElem, "element", "name", elemName);
        return ValidationFilterUtil.saveSettings(project, doc);
    }

    public static boolean ignoreAttribute(IResource resource, String elemName, String attrName) {
        if (resource == null) {
            return false;
        }
        IProject project = resource.getProject();
        Document doc = ValidationFilterUtil.loadSettings(project, true);
        if (doc == null) {
            return false;
        }
        Element docElem = doc.getDocumentElement();
        String pathString = ValidationFilterUtil.getRelativePathString(project, resource);
        Element matchElem = ValidationFilterUtil.addElement(doc, docElem, "match");
        ValidationFilterUtil.addElement(doc, matchElem, "file", "path", pathString);
        ValidationFilterUtil.addElement(doc, matchElem, "ignore", "pattern", "UNREC_ATTR");
        ValidationFilterUtil.addElement(doc, matchElem, "element", "name", elemName);
        ValidationFilterUtil.addElement(doc, matchElem, "attribute", "name", attrName);
        return ValidationFilterUtil.saveSettings(project, doc);
    }

    public static String getRelativePathString(IProject project, IResource resource) {
        IPath projPath;
        if (resource == null) {
            return "";
        }
        IPath resPath = resource.getLocation();
        if (project != null && (projPath = project.getLocation()).isPrefixOf(resPath)) {
            IPath relPath = resPath.makeRelativeTo(projPath);
            return relPath.toOSString();
        }
        return resPath.toOSString();
    }

    private static Element addElement(Document doc, Element parent, String childName, String attrName, String attrValue) {
        Element child = ValidationFilterUtil.addElement(doc, parent, childName);
        child.setAttribute(attrName, attrValue);
        return child;
    }

    private static Element addElement(Document doc, Element parent, String childName) {
        Element child = doc.createElement(childName);
        parent.appendChild(child);
        return child;
    }
}

