/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.IncludeConflictResolution;
import com.ibm.ws.st.core.internal.config.validation.ConfigFileValidationContext;
import com.ibm.ws.st.core.internal.config.validation.DOMModelValidationContext;
import com.ibm.ws.st.core.internal.config.validation.DOMValidationContext;
import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class ValidationContext {
    private final ValidationContext parent;
    private Element currentInclude;
    private final IncludeConflictResolution conflictResolution;
    private boolean isDropin = false;

    public static ValidationContext createValidationContext(ConfigurationFile configFile, ValidationContext parent, IncludeConflictResolution conflictResolution) {
        return new ConfigFileValidationContext(configFile, parent, conflictResolution);
    }

    public static ValidationContext createValidationContext(IResource resource, ValidationContext parent, IncludeConflictResolution conflictResolution) {
        ConfigurationFile configFile;
        block5: {
            if (resource instanceof IFile) {
                try {
                    URI uri = resource.getLocation().toFile().toURI();
                    WebSphereServerInfo server = ConfigUtils.getServer(uri);
                    UserDirectory userDir = server != null ? server.getUserDirectory() : ConfigUtils.getUserDirectory(uri);
                    return new DOMModelValidationContext((IFile)resource, server, userDir, parent, conflictResolution);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block5;
                    Trace.trace((byte)1, "Exception trying to create DOMModelValidationContext for " + resource + ".", e);
                }
            }
        }
        if ((configFile = ConfigUtils.getConfigFile(resource)) != null) {
            return ValidationContext.createValidationContext(configFile, parent, conflictResolution);
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)1, "Failed to create model for " + resource + ".");
        }
        return null;
    }

    public static ValidationContext createValidationContext(Document document, IResource resource, ValidationContext parent, IncludeConflictResolution conflictResolution) {
        URI uri;
        UserDirectory userDir;
        WebSphereServerInfo server;
        block5: {
            server = null;
            userDir = null;
            uri = null;
            if (resource != null) {
                uri = resource.getLocation().toFile().toURI();
            }
            if (uri == null) {
                try {
                    String uriStr = document.getDocumentURI();
                    uri = new URI(uriStr);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block5;
                    Trace.trace((byte)1, "Exception trying to get the URI for a config file DOM.", e);
                }
            }
        }
        if (uri != null) {
            server = ConfigUtils.getServer(uri);
            userDir = server != null ? server.getUserDirectory() : ConfigUtils.getUserDirectory(uri);
        }
        return new DOMValidationContext(document, resource, server, userDir, parent, conflictResolution);
    }

    public static ValidationContext createValidationContext(String path, URI base, UserDirectory context, ValidationContext parent, IncludeConflictResolution conflictResolution) throws Exception {
        URI uri = ConfigUtils.resolve(base, path, context);
        if (uri != null) {
            WebSphereServerInfo[] servers;
            for (WebSphereServerInfo server : servers = WebSphereUtil.getWebSphereServerInfos()) {
                ConfigurationFile configFile = server.getConfigurationFileFromURI(uri);
                if (configFile == null) continue;
                return ValidationContext.createValidationContext(configFile, parent, conflictResolution);
            }
            IFile iFile = ConfigUtils.getWorkspaceFile(context, uri);
            if (iFile != null && iFile.exists()) {
                return new DOMModelValidationContext(iFile, null, context, parent, conflictResolution);
            }
            File file = new File(uri);
            if (file.exists()) {
                ConfigurationFile configFile = new ConfigurationFile(uri, context);
                return new ConfigFileValidationContext(configFile, parent, conflictResolution);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)1, "Failed to create model for " + uri + ".");
        }
        return null;
    }

    public ValidationContext(ValidationContext parent, IncludeConflictResolution conflictResolution) {
        this.parent = parent;
        this.conflictResolution = conflictResolution;
    }

    public ValidationContext getParent() {
        return this.parent;
    }

    public IncludeConflictResolution getConflictResolution() {
        return this.conflictResolution;
    }

    public abstract Document getDocument();

    public abstract IResource getResource();

    public abstract URI getURI();

    public abstract WebSphereServerInfo getServer();

    public abstract UserDirectory getUserDirectory();

    public abstract ConfigurationFile getConfigFile();

    public void dispose() {
    }

    public Element getCurrentInclude() {
        return this.currentInclude;
    }

    public void setCurrentInclude(Element include) {
        this.currentInclude = include;
    }

    public boolean isDropin() {
        return this.isDropin;
    }

    public void setDropin(boolean isDropin) {
        this.isDropin = isDropin;
    }
}

