/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.ServerListenerUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.URIUtil;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.Bootstrap;
import com.ibm.ws.st.core.internal.config.ConfigVars;
import com.ibm.ws.st.core.internal.config.ConfigurationDropinsFolder;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ConfigurationIncludeFilter;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import com.ibm.ws.st.core.internal.config.JVMOptions;
import com.ibm.ws.st.core.internal.config.SchemaHelper;
import com.ibm.ws.st.core.internal.config.ServerEnv;
import com.ibm.ws.st.core.internal.generation.FeatureListCoreMetadata;
import com.ibm.ws.st.core.internal.generation.FeatureListExtMetadata;
import com.ibm.ws.st.core.internal.generation.IMetadataGenerator;
import com.ibm.ws.st.core.internal.generation.Metadata;
import com.ibm.ws.st.core.internal.generation.SchemaMetadata;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;

public class WebSphereServerInfo
implements IMetadataGenerator {
    public static final String SERVERS_METADATA_DIR = "serversMetadata";
    private final String serverName;
    private Bootstrap bootstrap;
    private final Map<IPath, JVMOptions> jvmOptionsFiles;
    private ServerEnv serverEnv;
    private ServerEnv etcServerEnv;
    private final UserDirectory userDir;
    private final WebSphereRuntime runtime;
    private ConfigurationFile file;
    private Map<URI, ConfigurationFile> map;
    private long lastUpdate = 0L;
    private final Object infoLock;
    private ConfigVars allVars;
    private ConfigVars resolvedVars;
    private SchemaHelper schemaHelper = null;

    public WebSphereServerInfo(String serverName, UserDirectory userDir, WebSphereRuntime runtime) {
        this.serverName = serverName;
        this.userDir = userDir;
        this.runtime = runtime;
        this.jvmOptionsFiles = new HashMap<IPath, JVMOptions>();
        this.infoLock = runtime == null ? this : runtime;
    }

    public String getServerName() {
        return this.serverName;
    }

    public IFolder getServerFolder() {
        if (this.userDir.getProject() == null || this.serverName == null) {
            return null;
        }
        return this.userDir.getProject().getFolder("servers").getFolder(this.serverName);
    }

    public IPath getServerPath() {
        if (this.serverName == null) {
            return null;
        }
        return this.userDir.getServersPath().append(this.serverName);
    }

    public IPath getServerAppsPath() {
        if (this.serverName == null) {
            return null;
        }
        return this.getServerPath().append("apps");
    }

    public IPath getServerOutputPath() {
        String wlpOutputDir;
        if (this.serverName == null) {
            return null;
        }
        ServerEnv env = null;
        env = (ServerEnv)this.getServerEnv();
        if (env != null && (wlpOutputDir = env.getValue("WLP_OUTPUT_DIR")) != null) {
            return new Path(wlpOutputDir).append(this.serverName);
        }
        return this.userDir.getOutputPath().append(this.serverName);
    }

    public URI getServerURI() {
        if (this.serverName == null) {
            return null;
        }
        return this.getServerPath().toFile().toURI();
    }

    @Override
    public WebSphereRuntime getWebSphereRuntime() {
        return this.runtime;
    }

    public UserDirectory getUserDirectory() {
        return this.userDir;
    }

    public Bootstrap getBootstrap() {
        return this.bootstrap;
    }

    public ExtendedConfigFile getJVMOptions(IPath label) {
        return this.jvmOptionsFiles.get(label);
    }

    public void putJVMOptions(IPath label, JVMOptions location) {
        this.jvmOptionsFiles.put(label, location);
    }

    public Collection<JVMOptions> getJVMOptionsFiles() {
        Collection<JVMOptions> jvmOptionsFilesList = this.jvmOptionsFiles.values();
        jvmOptionsFilesList.removeAll(Collections.singleton(null));
        return jvmOptionsFilesList;
    }

    public ExtendedConfigFile getServerEnv() {
        return this.serverEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationFile getConfigRoot() {
        Object object = this.infoLock;
        synchronized (object) {
            this.updateConfigurationCache();
            return this.file;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI[] getConfigurationURIs() {
        Object object = this.infoLock;
        synchronized (object) {
            this.updateConfigurationCache();
            Set<URI> set = this.map.keySet();
            return set.toArray(new URI[set.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationFile[] getConfigurationFiles() {
        Object object = this.infoLock;
        synchronized (object) {
            this.updateConfigurationCache();
            Collection<ConfigurationFile> files = this.map.values();
            return files.toArray(new ConfigurationFile[files.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCache() {
        boolean changed = false;
        Object object = this.infoLock;
        synchronized (object) {
            IPath[] paths;
            if (this.updateConfigurationCache()) {
                changed = true;
            } else {
                if (this.file == null) {
                    return false;
                }
                if (this.file.isNewerThan(this.lastUpdate, true)) {
                    changed = true;
                }
            }
            this.lastUpdate = System.currentTimeMillis();
            if (this.updateBootstrap()) {
                changed = true;
            }
            for (IPath path : paths = new IPath[]{this.getServerPath(), this.getConfigDefaultDropinsPath(), this.getConfigOverrideDropinsPath(), this.getUserDirectory().getSharedPath()}) {
                IPath jvmOptionsPath = path.append("jvm.options");
                File jvmOptionsFile = jvmOptionsPath.toFile();
                JVMOptions currJvmOptions = (JVMOptions)this.getJVMOptions(path);
                if (jvmOptionsFile.exists()) {
                    boolean flag = false;
                    if (currJvmOptions != null && this.getUserDirectory().getRemoteUserPath() != null) {
                        flag = currJvmOptions.hasChanged();
                    }
                    if (currJvmOptions == null || flag) {
                        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                        IFile file = workspaceRoot.getFileForLocation(jvmOptionsPath);
                        currJvmOptions = new JVMOptions(jvmOptionsFile, file);
                        changed = true;
                    }
                } else if (currJvmOptions != null) {
                    changed = true;
                    currJvmOptions = null;
                }
                this.putJVMOptions(path, currJvmOptions);
            }
            if (this.updateServerEnv()) {
                changed = true;
            }
        }
        if (changed) {
            ServerListenerUtil.getInstance().fireServerChangedEvent(this);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConfigCacheDirty() {
        Object object = this.infoLock;
        synchronized (object) {
            if (this.map == null) {
                return false;
            }
            Collection<ConfigurationFile> files = this.map.values();
            for (ConfigurationFile file : files) {
                if (!file.hasChanged() && !file.hasOutOfSyncLocalIncludes()) continue;
                return true;
            }
            return false;
        }
    }

    protected File getBootstrapFile() {
        return this.getServerPath().append("bootstrap.properties").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBootstrap() {
        Object object = this.infoLock;
        synchronized (object) {
            boolean changed = false;
            try {
                File bootstrapFile = this.getBootstrapFile();
                if (bootstrapFile.exists()) {
                    if (this.bootstrap == null || this.bootstrap.hasChanged()) {
                        IFile file = null;
                        if (this.userDir.getProject() != null) {
                            file = this.getServerFolder().getFile("bootstrap.properties");
                        }
                        this.bootstrap = new Bootstrap(bootstrapFile, file);
                        this.allVars = null;
                        this.resolvedVars = null;
                        changed = true;
                    }
                } else if (this.bootstrap != null) {
                    this.bootstrap = null;
                    this.allVars = null;
                    this.resolvedVars = null;
                    changed = true;
                }
            }
            catch (IOException ioe) {
                Trace.logError("Error updating server cache configuration: " + this.serverName, ioe);
            }
            return changed;
        }
    }

    protected File getServerEnvFile() {
        return this.getServerPath().append("server.env").toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateServerEnv() {
        Object object = this.infoLock;
        synchronized (object) {
            boolean changed = false;
            try {
                File etcServerEnvFile;
                File serverEnvFile = this.getServerEnvFile();
                if (serverEnvFile.exists()) {
                    if (this.serverEnv == null || this.serverEnv.hasChanged()) {
                        changed = true;
                        IFile file = null;
                        if (this.userDir.getProject() != null) {
                            file = this.getServerFolder().getFile("server.env");
                        }
                        this.serverEnv = new ServerEnv(serverEnvFile, file);
                    }
                } else if (this.serverEnv != null) {
                    changed = true;
                    this.serverEnv = null;
                }
                if ((etcServerEnvFile = this.runtime.getRuntimeLocation().append("etc").append("server.env").toFile()).exists()) {
                    if (this.etcServerEnv == null || this.etcServerEnv.hasChanged()) {
                        changed = true;
                        this.etcServerEnv = new ServerEnv(etcServerEnvFile, null);
                    }
                } else if (this.etcServerEnv != null) {
                    changed = true;
                    this.etcServerEnv = null;
                }
            }
            catch (IOException e) {
                Trace.logError("Error updating server cache configuration: " + this.serverName, e);
            }
            if (changed) {
                this.allVars = null;
                this.resolvedVars = null;
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateConfigurationCache() {
        Object object = this.infoLock;
        synchronized (object) {
            if (this.map != null && !this.isConfigCacheDirty()) {
                return false;
            }
            try {
                IPath path = this.getServerPath();
                URI configRoot = path.append("server.xml").toFile().toURI();
                this.map = new HashMap<URI, ConfigurationFile>(4);
                this.file = new ConfigurationFile(configRoot, this.userDir, this);
                ArrayList<ConfigurationFile> files = new ArrayList<ConfigurationFile>();
                ConfigurationIncludeFilter includeFilter = new ConfigurationIncludeFilter();
                this.file.getAllConfigFiles(files, includeFilter);
                for (ConfigurationFile cf : files) {
                    URI uri = URIUtil.getCanonicalURI(cf.getURI());
                    this.map.put(uri, cf);
                }
            }
            catch (IOException ioe) {
                Trace.logError("Error updating server cache configuration: " + this.serverName, ioe);
            }
            return true;
        }
    }

    private void createConfigVars() {
        this.allVars = new ConfigVars();
        this.resolvedVars = new ConfigVars();
        this.userDir.getVariables(this.allVars, false);
        this.userDir.getVariables(this.resolvedVars, true);
        this.addServerVars(this.allVars);
        this.addServerVars(this.resolvedVars);
    }

    private void addServerVars(ConfigVars vars) {
        if (this.serverName != null) {
            vars.add("server.config.dir", this.getServerPath().toOSString(), ConfigVars.LOCATION_TYPE);
            vars.add("server.output.dir", this.getServerOutputPath().toOSString(), ConfigVars.LOCATION_TYPE);
            vars.add("wlp.server.name", this.getServerName(), ConfigVars.STRING_TYPE);
        }
        if (this.bootstrap != null) {
            Set<Map.Entry<String, String>> entries = this.bootstrap.getVariables(vars);
            String remoteUserPath = null;
            if (this.getUserDirectory().getRemoteUserPath() != null) {
                remoteUserPath = this.getUserDirectory().getRemoteUserPath().toString();
            }
            String userDir = this.getUserDirectory().getPath().toOSString();
            if (remoteUserPath != null && entries != null) {
                for (Map.Entry<String, String> entry : entries) {
                    String value = vars.getValue(entry.getKey());
                    if (!value.startsWith(remoteUserPath)) continue;
                    value = value.replace(remoteUserPath, userDir);
                    vars.add(entry.getKey(), value, ConfigVars.STRING_TYPE);
                }
            }
        }
        if (this.etcServerEnv != null) {
            this.etcServerEnv.getVariables(vars);
        }
        if (this.serverEnv != null) {
            this.serverEnv.getVariables(vars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationFile getConfigurationFileFromURI(URI uri) {
        Object object = this.infoLock;
        synchronized (object) {
            this.updateConfigurationCache();
            ConfigurationFile cf = this.map.get(uri);
            if (cf == null) {
                cf = this.map.get(URIUtil.getCanonicalURI(uri));
            }
            return cf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI resolve(URI baseUri, String include) {
        Object object = this.infoLock;
        synchronized (object) {
            String remoteUserDir;
            if (include == null) {
                return null;
            }
            this.fillConfigVars();
            String resolvedInclude = this.allVars.resolve(include);
            if (this.getUserDirectory().getRemoteUserPath() != null && (remoteUserDir = this.getUserDirectory().getRemoteUserPath().toString()) != null && resolvedInclude.startsWith(remoteUserDir)) {
                resolvedInclude = resolvedInclude.replace(remoteUserDir, this.getUserDirectory().getPath().toOSString());
            }
            return this.userDir.resolve(baseUri, resolvedInclude);
        }
    }

    public IFile getIFile(URI uri) {
        URI relative;
        if (uri == null) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFileForLocation((IPath)new Path(uri.getPath()));
        if (file != null) {
            return file;
        }
        if (this.userDir.getProject() != null && this.userDir.getProject().exists() && !(relative = URIUtil.canonicalRelativize(this.getServerURI(), uri)).isAbsolute() && (file = this.userDir.getProject().getFile(relative.getPath())) != null) {
            return file;
        }
        return null;
    }

    public void getVariables(ConfigVars vars) {
        this.getVariables(vars, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getVariables(ConfigVars vars, boolean resolvedOnly) {
        Object object = this.infoLock;
        synchronized (object) {
            this.fillConfigVars();
            if (resolvedOnly) {
                this.resolvedVars.copyInto(vars);
            } else {
                this.allVars.copyInto(vars);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillConfigVars() {
        Object object = this.infoLock;
        synchronized (object) {
            this.updateBootstrap();
            this.updateServerEnv();
            if (this.allVars == null) {
                this.createConfigVars();
            }
        }
    }

    public JMXConnection createLocalJMXConnection() throws Exception {
        JMXConnection jmxConnection = new JMXConnection(this.getServerOutputPath().append("workarea"));
        jmxConnection.connect();
        return jmxConnection;
    }

    public void generatePluginConfig() throws Exception {
        List<String> allFeatures = this.getConfigRoot().getAllFeatures();
        if (!allFeatures.contains("localConnector-1.0")) {
            throw new Exception("No local JMX support");
        }
        JMXConnection jmxConnection = null;
        try {
            jmxConnection = this.createLocalJMXConnection();
            jmxConnection.generateDefaultPluginConfig();
        }
        finally {
            if (jmxConnection != null) {
                jmxConnection.disconnect();
            }
        }
    }

    public void addDropInLibPaths(List<IPath> paths) {
        paths.add(this.getServerPath().append("lib"));
        this.userDir.addDropInLibPaths(paths);
    }

    public String toString() {
        return "WebSphereServerInfo [" + this.getServerName() + "/" + this.userDir.toString() + "]";
    }

    @Override
    public String getGeneratorId() {
        return WebSphereServerInfo.getGeneratorId(this.getServerName(), this.getWebSphereRuntime().getMetaDataDirName(this.getUserDirectory()), this.getWebSphereRuntime().getGeneratorId());
    }

    @Override
    public IPath getBasePath(IPath root) {
        return this.buildMetadataDirectoryPath();
    }

    @Override
    public boolean supportsFeatureListGeneration() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean metadataExists() {
        Object object = this.infoLock;
        synchronized (object) {
            return SchemaMetadata.getInstance().metadataExists(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateMetadata(IJobChangeListener listener, boolean isRegenInfoCache) {
        Object object = this.infoLock;
        synchronized (object) {
            IPath dirPath = this.buildMetadataDirectoryPath();
            File dir = dirPath.toFile();
            if (!dir.exists() && !dir.mkdirs()) {
                if (Trace.ENABLED) {
                    Throwable t = new Throwable();
                    t.fillInStackTrace();
                    Trace.trace((byte)1, "Unable to create " + dir.getAbsolutePath() + " so metadata generation aborted.", t);
                }
                return;
            }
            this.generateMetadata(listener, isRegenInfoCache, 15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMetadata(IJobChangeListener listener, boolean isRegenInfoCache, int metadataTypes) {
        Object object = this.infoLock;
        synchronized (object) {
            final WebSphereRuntime wsr = this.getWebSphereRuntime();
            final WebSphereServerInfo metadataGen = this;
            JobChangeAdapter restoreListener = new JobChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void done(IJobChangeEvent event) {
                    try {
                        SchemaMetadata schemaMetadata = SchemaMetadata.getInstance();
                        FeatureListCoreMetadata coreMetadata = FeatureListCoreMetadata.getInstance();
                        FeatureListExtMetadata[] extMetadata = FeatureListExtMetadata.getInstances(wsr);
                        String generatorId = WebSphereServerInfo.this.getGeneratorId();
                        schemaMetadata.generationComplete(generatorId, schemaMetadata.getPayload(metadataGen));
                        coreMetadata.generationComplete(generatorId, coreMetadata.getPayload(metadataGen));
                        for (FeatureListExtMetadata exts : extMetadata) {
                            exts.generationComplete(generatorId, exts.getPayload(metadataGen));
                        }
                    }
                    finally {
                        event.getJob().removeJobChangeListener((IJobChangeListener)this);
                    }
                }
            };
            IJobChangeListener[] listeners = listener != null ? new IJobChangeListener[]{listener, restoreListener} : new IJobChangeListener[]{restoreListener};
            if (isRegenInfoCache) {
                FeatureListExtMetadata.clearRuntimeInstances(wsr.getRuntime().getId());
            }
            Metadata.generateMetadata(this, listeners, metadataTypes);
            boolean cacheNeededUpdate = this.updateCache();
            if (!cacheNeededUpdate) {
                ServerListenerUtil.getInstance().fireServerChangedEvent(this);
            }
        }
    }

    public IPath buildMetadataDirectoryPath() {
        IPath path = this.getWebSphereRuntime().getBasePath(Activator.getInstance().getStateLocation());
        return path.append(this.getMetadataRelativePath());
    }

    public String getMetadataRelativePath() {
        String userDir = this.runtime.getMetaDataDirName(this.getUserDirectory());
        return "serversMetadata/" + userDir + "/" + this.getServerName();
    }

    public static String getGeneratorId(String serverName, String userDir, String runtimeId) {
        return runtimeId + "_" + userDir + "_" + serverName;
    }

    @Override
    public void generateSchema(String file, IProgressMonitor monitor, int timeout) throws CoreException {
        this.getWebSphereRuntime().generateSchema(file, monitor, timeout);
    }

    @Override
    public void generateFeatureList(String file, IProgressMonitor monitor, int timeout, String ... options) throws CoreException {
    }

    @Override
    public boolean isReadyToGenerateMetadata() {
        return this.getWebSphereRuntime().isReadyToGenerateMetadata();
    }

    @Override
    public void removeMetadata(IPath dir, boolean deleteDirectory, boolean destroy) {
        File file;
        IPath metadataDirectory = dir != null ? dir : this.buildMetadataDirectoryPath();
        this.removeFile(metadataDirectory, "server.xsd");
        Metadata.removeMetadata(this.getGeneratorId(), destroy);
        if (deleteDirectory && (file = metadataDirectory.toFile()).exists() && !file.delete()) {
            Trace.logError("Unable to delete metadata directory " + metadataDirectory.toString(), null);
        }
        ServerListenerUtil.getInstance().fireServerChangedEvent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(IPath dir, String fileName) {
        Object object = this.infoLock;
        synchronized (object) {
            IPath path = dir.append(fileName);
            File file = path.toFile();
            FileUtil.deleteFile(file);
        }
    }

    public URL getConfigurationSchemaURL() {
        if (this.metadataExists()) {
            return SchemaMetadata.getInstance().getSchemaPath(this);
        }
        return this.runtime.getConfigurationSchemaURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getConfigurationSchemaURL(URI fileURI) {
        Object object = this.infoLock;
        synchronized (object) {
            if (this.getConfigurationFileFromURI(fileURI) != null) {
                return this.getConfigurationSchemaURL();
            }
            return null;
        }
    }

    public SchemaHelper getSchemaHelper() {
        if (this.schemaHelper == null) {
            this.schemaHelper = new SchemaHelper(this.getConfigurationSchemaURL());
        }
        return this.schemaHelper;
    }

    public static void removeOutOfSyncMetadata(final WebSphereRuntime runtime) {
        File[] userDirs;
        IPath path = runtime.getBasePath(Activator.getInstance().getStateLocation());
        File metadataDir = (path = path.append(SERVERS_METADATA_DIR)).toFile();
        if (metadataDir.exists() && (userDirs = metadataDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        })) != null && userDirs.length > 0) {
            String runtimeId = runtime.getGeneratorId();
            for (File userDir : userDirs) {
                File[] serverDirs;
                final UserDirectory userDirectory = runtime.getUserDirForMetadataDir(userDir.getName());
                if (userDirectory == null || (serverDirs = userDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return runtime.getServerInfo(name, userDirectory) == null;
                    }
                })) == null || serverDirs.length <= 0) continue;
                for (File serverDir : serverDirs) {
                    String id = WebSphereServerInfo.getGeneratorId(serverDir.getName(), userDir.getName(), runtimeId);
                    Metadata.removeMetadata(id, true);
                    try {
                        FileUtil.deleteDirectory(userDir.getAbsolutePath(), true);
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Failed to delete directory: " + userDir.getAbsolutePath(), e);
                    }
                }
            }
        }
    }

    public static void removeCancelledMetaData(IPath basePath, String runtimeId) {
        File[] userDirs;
        IPath path = basePath.append(SERVERS_METADATA_DIR);
        File metadataDir = path.toFile();
        if (metadataDir.exists() && (userDirs = metadataDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File dir) {
                return dir.isDirectory();
            }
        })) != null && userDirs.length > 0) {
            for (File userDir : userDirs) {
                File[] serverDirs = userDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File dir) {
                        return dir.isDirectory();
                    }
                });
                if (serverDirs == null || serverDirs.length <= 0) continue;
                for (File serverDir : serverDirs) {
                    String id = WebSphereServerInfo.getGeneratorId(serverDir.getName(), userDir.getName(), runtimeId);
                    Metadata.removeMetadata(id, true);
                    try {
                        FileUtil.deleteDirectory(serverDir.getAbsolutePath(), true);
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Failed to delete directory: " + serverDir.getAbsolutePath(), e);
                    }
                }
            }
        }
    }

    public IPath getConfigDefaultDropinsPath() {
        return this.getConfigDropinsPath().append("defaults");
    }

    public IPath getConfigOverrideDropinsPath() {
        return this.getConfigDropinsPath().append("overrides");
    }

    public IPath getConfigDropinsPath() {
        return this.getServerPath().append("configDropins");
    }

    public IFolder getConfigDefaultDropinsFolder() {
        return this.getConfigDropinsFolder("defaults");
    }

    public IFolder getConfigOverrideDropinsFolder() {
        return this.getConfigDropinsFolder("overrides");
    }

    private IFolder getConfigDropinsFolder(String folderName) {
        IFolder folder = this.getConfigDropinsFolder();
        if (folder != null) {
            return folder.getFolder(folderName);
        }
        return null;
    }

    public IFolder getConfigDropinsFolder() {
        IFolder folder = this.getServerFolder();
        if (folder != null) {
            return folder.getFolder("configDropins");
        }
        return null;
    }

    public ConfigurationDropinsFolder getConfigurationDropinsFolder() {
        IPath path = this.getConfigDropinsPath();
        if (path == null || !path.toFile().exists()) {
            return null;
        }
        return new ConfigurationDropinsFolder(this.getUserDirectory(), path, this.getConfigDropinsFolder());
    }

    public String getMessageFileName() {
        ConfigurationFile configFile = this.getConfigRoot();
        if (configFile == null) {
            return null;
        }
        String messageFileName = configFile.getResolvedAttributeValue("logging", "messageFileName");
        if (messageFileName != null) {
            return messageFileName;
        }
        Bootstrap bootstrap = this.getBootstrap();
        if (bootstrap != null && (messageFileName = bootstrap.getMessagesFile()) != null) {
            return messageFileName;
        }
        return "messages.log";
    }

    public String getTraceFileName() {
        ConfigurationFile configFile = this.getConfigRoot();
        if (configFile == null) {
            return null;
        }
        String s = configFile.getResolvedAttributeValue("logging", "traceFileName");
        if (s != null) {
            return s;
        }
        Bootstrap bootstrap = this.getBootstrap();
        if (bootstrap != null && (s = bootstrap.getTraceFile()) != null) {
            return s;
        }
        return "trace.log";
    }

    public IPath getMessagesFile() {
        IPath relativePath = this.getRelativeLogPath();
        if (relativePath == null) {
            return null;
        }
        return relativePath.append(this.getMessageFileName());
    }

    public IPath getRelativeLogPath() {
        IPath relativePath = null;
        IPath logDir = this.getLogDirectory();
        if (logDir != null) {
            relativePath = logDir;
        } else {
            relativePath = this.getServerOutputPath();
            if (relativePath == null) {
                return null;
            }
            relativePath = relativePath.append("logs");
        }
        return relativePath;
    }

    public IPath getLogStateDirectory() {
        return this.getRelativeLogPath().append("state");
    }

    public IPath getTraceLogFile() {
        IPath relativePath = this.getRelativeLogPath();
        if (relativePath == null) {
            return null;
        }
        return relativePath.append(this.getTraceFileName());
    }

    public IPath getLogDirectory() {
        ConfigurationFile configFile = this.getConfigRoot();
        if (configFile == null) {
            return null;
        }
        String messageloc = configFile.getResolvedAttributeValue("logging", "logDirectory");
        if (messageloc != null) {
            ConfigVars cv = new ConfigVars();
            this.getVariables(cv);
            messageloc = cv.resolve(messageloc);
            return new Path(messageloc);
        }
        Bootstrap bootstrap = this.getBootstrap();
        if (bootstrap != null && (messageloc = bootstrap.getLogDir()) != null) {
            return new Path(messageloc);
        }
        String logDir = null;
        ServerEnv env = (ServerEnv)this.getServerEnv();
        if (env != null) {
            ConfigVars v = new ConfigVars();
            env.getVariables(v);
            logDir = v.getValue("env.LOG_DIR");
            if (logDir != null) {
                return new Path(logDir);
            }
            logDir = v.getValue("env.WLP_OUTPUT_DIR");
            if (logDir != null) {
                return new Path(logDir).append(this.getServerName()).append("logs");
            }
        }
        if ((logDir = System.getenv("LOG_DIR")) != null) {
            return new Path(logDir);
        }
        logDir = System.getenv("WLP_OUTPUT_DIR");
        if (logDir != null) {
            return new Path(logDir).append(this.getServerName()).append("logs");
        }
        return null;
    }

    public String[] getServerErrors() {
        IPath outputPath;
        ArrayList<String> errors = new ArrayList<String>();
        IPath serverPath = this.getServerPath();
        if (serverPath != null) {
            java.nio.file.Path path = Paths.get(serverPath.toOSString(), new String[0]);
            if (!Files.isWritable(path)) {
                errors.add(NLS.bind((String)Messages.errorServerFolderNotAccessible, (Object)serverPath.toOSString()));
            } else {
                IPath appsPath = this.getServerAppsPath();
                if (appsPath != null && appsPath.toFile().exists() && !Files.isWritable(path = Paths.get(appsPath.toOSString(), new String[0]))) {
                    errors.add(NLS.bind((String)Messages.errorAppsFolderNotAccessible, (Object)appsPath.toOSString()));
                }
            }
        }
        if ((outputPath = this.getServerOutputPath()) != null) {
            java.nio.file.Path path = Paths.get(outputPath.toOSString(), new String[0]);
            if (!outputPath.equals((Object)serverPath) && !Files.isWritable(path)) {
                errors.add(NLS.bind((String)Messages.errorOutputFolderNotAccessible, (Object)outputPath.toOSString()));
            }
        }
        return errors.toArray(new String[errors.size()]);
    }
}

