/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.internal.facets.RuntimeFacetComponentProviderDelegate;

public class WebSphereRuntimeComponentProvider
extends RuntimeFacetComponentProviderDelegate {
    public List<IRuntimeComponent> getRuntimeComponents(IRuntime runtime) {
        if (runtime == null) {
            return new ArrayList<IRuntimeComponent>();
        }
        try {
            IRuntimeComponentType rct;
            ArrayList<IRuntimeComponent> list = new ArrayList<IRuntimeComponent>();
            WebSphereRuntime wr = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
            FeatureSet fs = wr.getInstalledFeatures();
            fs.sort();
            for (String s : fs) {
                try {
                    IRuntimeComponentType rct2;
                    int ind = s.indexOf("-");
                    if (ind <= 0 || ind >= s.length() - 1) continue;
                    String t = s.substring(0, ind).toLowerCase();
                    if (!RuntimeManager.isRuntimeComponentTypeDefined((String)("com.ibm.ws.st.runtime." + t)) || (rct2 = RuntimeManager.getRuntimeComponentType((String)("com.ibm.ws.st.runtime." + t))) == null || !rct2.hasVersion(t = s.substring(ind + 1))) continue;
                    HashMap<String, String> properties = new HashMap<String, String>(2);
                    properties.put("type", NLS.bind((String)Messages.runtimeFeature, (Object)s));
                    list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rct2.getVersion(t), properties));
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Problem creating runtime component for " + s, e);
                }
            }
            if (RuntimeManager.isRuntimeComponentTypeDefined((String)"com.ibm.ws.st.runtime.enterpriseApplication") && (rct = RuntimeManager.getRuntimeComponentType((String)"com.ibm.ws.st.runtime.enterpriseApplication")) != null) {
                if (wr.isEARSupported("7.0") && rct.hasVersion("7.0")) {
                    list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rct.getVersion("7.0"), new HashMap(0)));
                }
                if (wr.isEARSupported("8.0") && rct.hasVersion("8.0")) {
                    list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rct.getVersion("8.0"), new HashMap(0)));
                }
                if (wr.isEARSupported("9.0") && rct.hasVersion("9.0")) {
                    list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rct.getVersion("9.0"), new HashMap(0)));
                }
                if (wr.isEARSupported("10.0") && rct.hasVersion("10.0")) {
                    list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rct.getVersion("10.0"), new HashMap(0)));
                }
            }
            String curVersion = wr.getRuntimeVersion();
            IRuntimeComponentType rct3 = RuntimeManager.getRuntimeComponentType((String)"com.ibm.ws.st.runtime.serviceVersion");
            if (rct3 != null && curVersion != null) {
                IRuntimeComponentVersion rcv = null;
                rcv = WebSphereUtil.isGreaterOrEqualVersion("9.0.0", curVersion) ? rct3.getVersion("9.0.0") : (WebSphereUtil.isGreaterOrEqualVersion("8.5.5", curVersion) ? rct3.getVersion("8.5.5") : rct3.getVersion("8.5.0"));
                if (rcv != null) {
                    HashMap<String, String> properties = new HashMap<String, String>(2);
                    properties.put("type", NLS.bind((String)Messages.runtimeServiceVersion, (Object)rcv.getVersionString()));
                    list.add(RuntimeManager.createRuntimeComponent((IRuntimeComponentVersion)rcv, properties));
                }
            }
            return list;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Problem creating runtime features", e);
            }
            return null;
        }
    }
}

