/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Trace;
import java.net.URL;
import org.eclipse.jst.server.core.Servlet;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.IURLProvider2;
import org.eclipse.wst.server.core.util.HttpLaunchable;
import org.eclipse.wst.server.core.util.WebResource;

public class WebLaunchable
extends HttpLaunchable {
    public WebLaunchable(final IServer server, final IModuleArtifact moduleObject) {
        super(new IURLProvider2(){

            public URL getModuleRootURL(IModule module) {
                IURLProvider urlProvider = (IURLProvider)server.loadAdapter(IURLProvider.class, null);
                return urlProvider.getModuleRootURL(module);
            }

            public URL getLaunchableURL() {
                try {
                    URL url = this.getModuleRootURL(moduleObject.getModule());
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Root URL: " + url);
                    }
                    if (url == null) {
                        return null;
                    }
                    if (moduleObject instanceof Servlet) {
                        Servlet servlet = (Servlet)moduleObject;
                        if (servlet.getAlias() != null) {
                            String path = servlet.getAlias();
                            if (path.startsWith("/")) {
                                path = path.substring(1);
                            }
                            url = new URL(url, path);
                        } else {
                            url = new URL(url, "servlet/" + servlet.getServletClassName());
                        }
                    } else if (moduleObject instanceof WebResource) {
                        WebResource resource = (WebResource)moduleObject;
                        String path = resource.getPath().toString();
                        if (Trace.ENABLED) {
                            Trace.trace((byte)0, "path: " + path);
                        }
                        if (path != null && path.startsWith("/") && path.length() > 0) {
                            path = path.substring(1);
                        }
                        if (path != null && path.length() > 0) {
                            url = new URL(url, path);
                        }
                    }
                    return url;
                }
                catch (Exception e) {
                    Trace.logError("Error getting URL for " + moduleObject, e);
                    return null;
                }
            }
        });
    }
}

