/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.server.core.IModule;

public final class RequiredFeatureMap {
    private final Map<FeatureResolverFeature, Set<IModule[]>> moduleMap = new HashMap<FeatureResolverFeature, Set<IModule[]>>();

    public FeatureResolverFeature[] getFeatures() {
        return this.moduleMap.keySet().toArray(new FeatureResolverFeature[this.moduleMap.size()]);
    }

    public List<IModule[]> getModules(FeatureResolverFeature feature) {
        Set<IModule[]> moduleSet = this.moduleMap.get(feature);
        return moduleSet == null ? null : new ArrayList<IModule[]>(moduleSet);
    }

    public void removeFeature(FeatureResolverFeature feature) {
        this.moduleMap.remove(feature);
    }

    public void addFeature(FeatureResolverFeature feature, IModule[] module) {
        this.addFeature(feature, module == null ? null : Collections.singletonList(module));
    }

    public void addFeature(FeatureResolverFeature feature, List<IModule[]> modules) {
        Set<IModule[]> moduleSet = this.moduleMap.get(feature);
        if (moduleSet == null) {
            moduleSet = new HashSet<IModule[]>();
            this.moduleMap.put(feature, moduleSet);
        }
        if (modules != null) {
            moduleSet.addAll(modules);
        }
    }

    public void addModule(FeatureResolverFeature feature, IModule[] module) {
        this.addModules(feature, module == null ? null : Collections.singletonList(module));
    }

    public void addModules(FeatureResolverFeature feature, List<IModule[]> moduleList) {
        if (!this.moduleMap.containsKey(feature) || moduleList == null) {
            return;
        }
        Set<IModule[]> moduleSet = this.moduleMap.get(feature);
        moduleSet.addAll(moduleList);
    }

    public void replaceFeature(FeatureResolverFeature remove, FeatureResolverFeature add) {
        Set<IModule[]> moduleSet = this.moduleMap.get(remove);
        this.moduleMap.remove(remove);
        this.moduleMap.put(add, moduleSet);
    }

    public boolean contains(FeatureResolverFeature feature) {
        return this.moduleMap.containsKey(feature);
    }

    public boolean isEmpty() {
        return this.moduleMap.isEmpty();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        boolean firstEntry = true;
        for (Map.Entry<FeatureResolverFeature, Set<IModule[]>> entry : this.moduleMap.entrySet()) {
            if (firstEntry) {
                firstEntry = false;
            } else {
                builder.append(", ");
            }
            builder.append(entry.getKey());
            builder.append("[");
            boolean firstModule = true;
            for (IModule[] module : entry.getValue()) {
                if (module.length == 0) continue;
                if (firstModule) {
                    firstModule = false;
                } else {
                    builder.append(", ");
                }
                builder.append(module[module.length - 1]);
            }
            builder.append("]");
        }
        builder.append("}");
        return builder.toString();
    }
}

