/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.Activator;
import com.ibm.ws.st.core.internal.AppMonitorMBeanPrompt;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.OutOfSyncApplicationPrompt;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.RequiredFeaturePrompt;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.jmx.JMXConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;

public class PublishHelper {
    private static final String PROMPT_RESPONSES_FILENAME = "promptResponses.properties";
    private final WebSphereServerBehaviour wsBehaviour;
    private final Properties promptResponses;
    private final PromptHandler promptHandler = Activator.getPromptHandler();
    private boolean configChanged;

    public PublishHelper(WebSphereServerBehaviour wsBehaviour) {
        this.wsBehaviour = wsBehaviour;
        this.promptResponses = new Properties();
        FileUtil.loadProperties(this.promptResponses, wsBehaviour.getTempDirectory().append(PROMPT_RESPONSES_FILENAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPublishedModules(IProgressMonitor monitor) {
        if (this.promptHandler != null && !PromptUtil.isSuppressDialog()) {
            List<PromptHandler.AbstractPrompt> registeredPrompts = this.getRegisteredPrompts();
            List<IModule[]> modules = this.wsBehaviour.getPublishedModules();
            this.configChanged = false;
            for (PromptHandler.AbstractPrompt prompt : registeredPrompts) {
                prompt.getActionHandler().prePromptAction(modules, this, monitor);
            }
            PromptHandler.AbstractPrompt[] activePrompts = this.getActivePrompts(registeredPrompts);
            if (activePrompts.length > 0) {
                IPromptResponse resp = this.promptHandler.getResponse(Messages.publishPromptMessage, activePrompts, 273);
                if (resp == null) {
                    monitor.setCanceled(true);
                    return;
                }
                for (PromptHandler.AbstractPrompt prompt : activePrompts) {
                    prompt.getActionHandler().postPromptAction(resp, this);
                }
            }
            if (this.configChanged) {
                ConfigurationFile configFile;
                WebSphereServer ws;
                block17: {
                    ws = this.wsBehaviour.getWebSphereServer();
                    configFile = ws.getConfiguration();
                    try {
                        configFile.save(monitor);
                        if (ws.getServer().getServerState() != 2) break block17;
                        JMXConnection jmx = null;
                        try {
                            jmx = ws.createJMXConnection();
                            if (jmx != null) {
                                ArrayList<String> file = new ArrayList<String>();
                                file.add(configFile.getIFile().getLocation().toOSString());
                                jmx.notifyFileChanges(null, file, null);
                            }
                        }
                        catch (Exception e) {
                            if (Trace.ENABLED) {
                                Trace.trace((byte)1, "Failed to use JMX to update the configuration file. ", e);
                            }
                        }
                        finally {
                            if (jmx != null) {
                                jmx.disconnect();
                            }
                        }
                    }
                    catch (IOException e) {
                        Trace.logError("Error saving configuration " + configFile.getURI(), e);
                    }
                }
                if (configFile.getIFile() == null) {
                    ws.refreshConfiguration();
                }
            }
        }
    }

    protected void addPromptResponse(String key, String value) {
        this.promptResponses.put(key, value);
    }

    protected String getPromptResponse(String key) {
        return this.promptResponses.getProperty(key);
    }

    protected void savePromptResponses() {
        FileUtil.saveCachedProperties(this.promptResponses, this.wsBehaviour.getTempDirectory().append(PROMPT_RESPONSES_FILENAME));
    }

    protected void setConfigChanged(boolean value) {
        this.configChanged = value;
    }

    protected WebSphereServer getWebSphereServer() {
        return this.wsBehaviour.getWebSphereServer();
    }

    protected WebSphereServerBehaviour getWebSphereServerBehaviour() {
        return this.wsBehaviour;
    }

    private List<PromptHandler.AbstractPrompt> getRegisteredPrompts() {
        ArrayList<PromptHandler.AbstractPrompt> list = new ArrayList<PromptHandler.AbstractPrompt>(3);
        list.add(new RequiredFeaturePrompt());
        list.add(new OutOfSyncApplicationPrompt());
        list.add(new AppMonitorMBeanPrompt());
        return list;
    }

    private PromptHandler.AbstractPrompt[] getActivePrompts(List<PromptHandler.AbstractPrompt> registeredPrompts) {
        ArrayList<PromptHandler.AbstractPrompt> list = new ArrayList<PromptHandler.AbstractPrompt>(registeredPrompts.size());
        for (PromptHandler.AbstractPrompt prompt : registeredPrompts) {
            if (!prompt.isActive()) continue;
            list.add(prompt);
        }
        return list.toArray(new PromptHandler.AbstractPrompt[list.size()]);
    }
}

