/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.st.core.internal.FacetFeatureResolver;
import com.ibm.ws.st.core.internal.FeatureResolver;
import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.config.FeatureList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class FeatureResolverWrapper {
    private static final String EXTENSION_POINT = "requiredFeatures";
    private static FeatureResolverWrapper[] featureExtensions;
    private static Map<String, String[]> alternativeFeatureMap;
    private final IConfigurationElement configElement;
    private final String[] moduleTypes;
    private final String[] facetIds;
    private final String[] facetVersions;
    private final IPath[] paths;
    private final FeatureResolverFeature[] features;
    private FeatureResolver delegate;
    private int priority;

    protected static synchronized FeatureResolverWrapper[] getFeatureExtensions() {
        if (featureExtensions != null) {
            return featureExtensions;
        }
        featureExtensions = FeatureResolverWrapper.loadRequiredFeatureExtensions();
        return featureExtensions;
    }

    private static FeatureResolverWrapper[] loadRequiredFeatureExtensions() {
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "->- Loading .requiredFeatures extension point ->-");
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("com.ibm.ws.st.core", EXTENSION_POINT);
        ArrayList<FeatureResolverWrapper> list = new ArrayList<FeatureResolverWrapper>(cf.length);
        for (IConfigurationElement ce : cf) {
            try {
                list.add(new FeatureResolverWrapper(ce));
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)3, "  Loaded requiredFeature: " + ce.getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.logError("Could not load requiredFeature: " + ce.getAttribute("id"), t);
            }
        }
        if (Trace.ENABLED) {
            Trace.trace((byte)3, "-<- Done loading .requiredFeatures extension point -<-");
        }
        FeatureResolverWrapper[] extArray = list.toArray(new FeatureResolverWrapper[list.size()]);
        Arrays.sort(extArray, new Comparator<FeatureResolverWrapper>(){

            @Override
            public int compare(FeatureResolverWrapper o1, FeatureResolverWrapper o2) {
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                return 0;
            }
        });
        return extArray;
    }

    public FeatureResolverWrapper(IConfigurationElement element) {
        int i;
        block6: {
            this.priority = 50;
            this.configElement = element;
            this.features = FeatureResolverWrapper.convertToArray(element.getAttribute("features"));
            String priorityStr = element.getAttribute("priority");
            if (priorityStr != null && !priorityStr.isEmpty()) {
                try {
                    this.priority = Integer.parseInt(priorityStr);
                }
                catch (NumberFormatException e) {
                    if (!Trace.ENABLED) break block6;
                    Trace.trace((byte)1, "Required feature extension priority is not a valid int: " + priorityStr);
                }
            }
        }
        IConfigurationElement[] ce = element.getChildren("module");
        int size = ce.length;
        this.moduleTypes = new String[size];
        for (i = 0; i < size; ++i) {
            this.moduleTypes[i] = ce[i].getAttribute("type");
        }
        ce = element.getChildren("facet");
        size = ce.length;
        this.facetIds = new String[size];
        this.facetVersions = new String[size];
        for (i = 0; i < size; ++i) {
            this.facetIds[i] = ce[i].getAttribute("id");
            this.facetVersions[i] = ce[i].getAttribute("version");
        }
        ce = element.getChildren("content");
        size = ce.length;
        this.paths = new IPath[size];
        for (i = 0; i < size; ++i) {
            this.paths[i] = new Path(ce[i].getAttribute("path"));
        }
    }

    private static FeatureResolverFeature[] convertToArray(String str) {
        FeatureResolverFeature[] s;
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        ArrayList<FeatureResolverFeature> list = new ArrayList<FeatureResolverFeature>();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            if (s == null || s.length() <= 0) continue;
            list.add(new FeatureResolverFeature(s.trim()));
        }
        s = new FeatureResolverFeature[list.size()];
        s = list.toArray(s);
        return s;
    }

    private static boolean moduleContains(IModule module, IPath path) {
        ModuleDelegate moduleDelegate = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, null);
        if (moduleDelegate == null) {
            return false;
        }
        try {
            IModuleResource[] members = moduleDelegate.members();
            return FeatureResolverWrapper.contains(members, path);
        }
        catch (CoreException ce) {
            Trace.trace((byte)0, "Problem scanning module members for jsp files", ce);
            return false;
        }
    }

    private static boolean contains(IModuleResource[] members, IPath path) {
        for (IModuleResource res : members) {
            IModuleFolder folder;
            IPath resPath = res.getModuleRelativePath().append(res.getName());
            if (path.equals((Object)resPath)) {
                return true;
            }
            if (!(res instanceof IModuleFolder) || !resPath.isPrefixOf(path) || !FeatureResolverWrapper.contains((folder = (IModuleFolder)res).members(), path)) continue;
            return true;
        }
        return false;
    }

    protected boolean supports(IModule[] module) {
        boolean found;
        IModule m = module[module.length - 1];
        String moduleType = m.getModuleType().getId();
        if (this.moduleTypes != null && this.moduleTypes.length > 0) {
            found = false;
            String[] stringArray = this.moduleTypes;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s = stringArray[i];
                if (!s.equals(moduleType)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        if (this.facetIds != null && this.facetIds.length > 0) {
            found = false;
            IProject project = m.getProject();
            if (project != null) {
                int size = this.facetIds.length;
                for (int i = 0; i < size; ++i) {
                    try {
                        if (this.facetVersions[i] == null) {
                            if (!FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this.facetIds[i])) continue;
                            found = true;
                            break;
                        }
                        if (!FacetedProjectFramework.hasProjectFacet((IProject)project, (String)this.facetIds[i], (String)this.facetVersions[i])) continue;
                        found = true;
                        break;
                    }
                    catch (CoreException ce) {
                        if (!Trace.ENABLED) continue;
                        Trace.trace((byte)1, "Problem checking facet for required features: " + this.facetIds[i], ce);
                    }
                }
            }
            if (!found) {
                return false;
            }
        }
        if (this.paths != null && this.paths.length > 0) {
            for (IPath path : this.paths) {
                if (FeatureResolverWrapper.moduleContains(m, path)) continue;
                return false;
            }
        }
        return true;
    }

    protected void getRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatures, boolean includeAll, IProgressMonitor monitor) {
        if (this.features != null) {
            for (FeatureResolverFeature feature : this.features) {
                FeatureResolver.checkAndAddFeature(requiredFeatures, existingFeatures, wr, feature, moduleList, includeAll);
            }
            return;
        }
        try {
            this.getDelegate().getRequiredFeatures(wr, moduleList, deltaList, existingFeatures, requiredFeatures, includeAll, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling feature resolver for required features", t);
        }
    }

    protected FeatureResolverFeature[] getContainedFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, IProgressMonitor monitor) {
        String clas = this.configElement.getAttribute("class");
        if (clas == null || clas.length() == 0) {
            return null;
        }
        try {
            return this.getDelegate().getContainedFeatures(wr, moduleList, monitor);
        }
        catch (Throwable t) {
            Trace.logError("Error calling feature resolver for contained features", t);
            return null;
        }
    }

    protected int getPriority() {
        return this.priority;
    }

    private FeatureResolver getDelegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (FeatureResolver)this.configElement.createExecutableExtension("class");
            }
            catch (Throwable t) {
                Trace.logError("Could not create delegate", t);
                this.delegate = new FeatureResolver(){

                    @Override
                    public void getRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatures, boolean includeAll, IProgressMonitor monitor) {
                    }
                };
            }
        }
        return this.delegate;
    }

    public static RequiredFeatureMap getAllRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, boolean includeAll, IProgressMonitor monitor) {
        FeatureResolverWrapper[] featureExtensions;
        RequiredFeatureMap featureMap = new RequiredFeatureMap();
        for (FeatureResolverWrapper fe : featureExtensions = FeatureResolverWrapper.getFeatureExtensions()) {
            ArrayList<IModule[]> supportedModules = new ArrayList<IModule[]>(moduleList.size());
            ArrayList<IModuleResourceDelta[]> supportedDeltas = deltaList == null ? null : new ArrayList<IModuleResourceDelta[]>(deltaList.size());
            for (int i = 0; i < moduleList.size(); ++i) {
                if (!fe.supports(moduleList.get(i))) continue;
                supportedModules.add(moduleList.get(i));
                if (deltaList == null || supportedDeltas == null) continue;
                supportedDeltas.add(deltaList.get(i));
            }
            if (supportedModules.isEmpty()) continue;
            fe.getRequiredFeatures(wr, supportedModules, supportedDeltas, existingFeatures, featureMap, includeAll, monitor);
        }
        FeatureResolverWrapper.addAcceptableAlternativesToFeatures(featureMap);
        return featureMap;
    }

    public static RequiredFeatureMap getAllRequiredFeaturesBasedOnFacets(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, boolean includeAll, IProgressMonitor monitor) {
        RequiredFeatureMap featureMap = new RequiredFeatureMap();
        FacetFeatureResolver facetFeatureResolver = new FacetFeatureResolver();
        facetFeatureResolver.getRequiredFeatures(wr, moduleList, deltaList, existingFeatures, featureMap, includeAll, monitor);
        FeatureResolverWrapper.addAcceptableAlternativesToFeatures(featureMap);
        return featureMap;
    }

    public static FeatureResolverFeature[] getAllContainedFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, IProgressMonitor monitor) {
        FeatureResolverWrapper[] featureExtensions;
        ArrayList<FeatureResolverFeature> list = new ArrayList<FeatureResolverFeature>();
        for (FeatureResolverWrapper fe : featureExtensions = FeatureResolverWrapper.getFeatureExtensions()) {
            FeatureResolverFeature[] features;
            ArrayList<IModule[]> supportedModules = new ArrayList<IModule[]>(moduleList.size());
            for (int i = 0; i < moduleList.size(); ++i) {
                if (!fe.supports(moduleList.get(i))) continue;
                supportedModules.add(moduleList.get(i));
            }
            if (supportedModules.isEmpty() || (features = fe.getContainedFeatures(wr, supportedModules, monitor)) == null || features.length <= 0) continue;
            for (FeatureResolverFeature frf : features) {
                if (list.contains(frf)) continue;
                list.add(frf);
            }
        }
        return list.toArray(new FeatureResolverFeature[list.size()]);
    }

    public static FeatureResolverFeature[] getAllContainedFeaturesBasedOnFacets(WebSphereRuntime wr, List<IModule[]> moduleList, IProgressMonitor monitor) {
        ArrayList<FeatureResolverFeature> list = new ArrayList<FeatureResolverFeature>();
        FacetFeatureResolver facetFeatureResolver = new FacetFeatureResolver();
        FeatureResolverFeature[] features = facetFeatureResolver.getContainedFeatures(wr, moduleList, monitor);
        if (features != null && features.length > 0) {
            for (FeatureResolverFeature frf : features) {
                if (list.contains(frf)) continue;
                list.add(frf);
            }
        }
        return list.toArray(new FeatureResolverFeature[list.size()]);
    }

    public static List<String> findFeatures(IProject project, WebSphereRuntime wr, boolean facetBasedOnly, IProgressMonitor monitor) {
        return FeatureResolverWrapper.findFeatures(project, wr, facetBasedOnly, false, monitor);
    }

    public static List<String> findFeatures(IProject project, WebSphereRuntime wr, boolean facetBasedOnly, boolean includeAll, IProgressMonitor monitor) {
        int found;
        IModule[] modules = ServerUtil.getModules((IProject)project);
        if (modules == null || modules.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> requiredFeatures = new ArrayList<String>();
        ArrayList<String> containedFeatures = new ArrayList<String>();
        ArrayList<IModule[]> moduleList = new ArrayList<IModule[]>(modules.length);
        for (IModule m : modules) {
            IModule[] iModuleArray = new IModule[]{m};
            moduleList.add(iModuleArray);
        }
        RequiredFeatureMap featureMap = null;
        featureMap = facetBasedOnly ? FeatureResolverWrapper.getAllRequiredFeaturesBasedOnFacets(wr, moduleList, null, null, includeAll, monitor) : FeatureResolverWrapper.getAllRequiredFeatures(wr, moduleList, null, null, includeAll, monitor);
        if (featureMap != null && !featureMap.isEmpty()) {
            String[] req = FeatureResolverFeature.convertFeatureResolverArrayToStringArray(featureMap.getFeatures());
            ArrayList<String> requiredFeaturesWithoutVersion = new ArrayList<String>();
            for (String string : req) {
                if (!string.contains("-")) {
                    requiredFeaturesWithoutVersion.add(string);
                    continue;
                }
                FeatureResolverWrapper.resolveAndAdd(string, requiredFeatures, wr);
            }
            for (String string : requiredFeaturesWithoutVersion) {
                found = 0;
                for (String version : requiredFeatures) {
                    if (!version.startsWith(string)) continue;
                    found = 1;
                    break;
                }
                if (found != 0) continue;
                FeatureResolverWrapper.resolveAndAdd(string, requiredFeatures, wr);
            }
        }
        String[] cont = null;
        cont = facetBasedOnly ? FeatureResolverFeature.convertFeatureResolverArrayToStringArray(FeatureResolverWrapper.getAllContainedFeaturesBasedOnFacets(wr, moduleList, monitor)) : FeatureResolverFeature.convertFeatureResolverArrayToStringArray(FeatureResolverWrapper.getAllContainedFeatures(wr, moduleList, monitor));
        if (cont != null) {
            ArrayList<Object> containedFeaturesWithoutVersion = new ArrayList<Object>();
            for (String string : cont) {
                if (!string.contains("-")) {
                    containedFeaturesWithoutVersion.add(string);
                    continue;
                }
                FeatureResolverWrapper.resolveAndAdd(string, containedFeatures, wr);
            }
            for (String string : containedFeaturesWithoutVersion) {
                found = 0;
                for (String version : containedFeatures) {
                    if (!version.startsWith(string)) continue;
                    found = 1;
                    break;
                }
                if (found != 0) continue;
                FeatureResolverWrapper.resolveAndAdd(string, containedFeatures, wr);
            }
        }
        if (requiredFeatures.isEmpty() && containedFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> requiredFeatures2 = new ArrayList<String>();
        block7: for (String string : requiredFeatures) {
            for (String string2 : containedFeatures) {
                if (!string.equals(string2) && (string2.contains("-") || !string.contains("-") || !string.startsWith(string2 + "-"))) continue;
                continue block7;
            }
            String feature = string;
            if (!feature.contains("-")) {
                String string3 = feature.toLowerCase() + "-";
                for (String fv : wr.getInstalledFeatures()) {
                    if (!fv.toLowerCase().startsWith(string3)) continue;
                    feature = fv;
                    break;
                }
            }
            if (requiredFeatures2.contains(feature)) continue;
            requiredFeatures2.add(feature);
        }
        return requiredFeatures2;
    }

    private static void resolveAndAdd(String featureToResolve, List<String> features, WebSphereRuntime wr) {
        String resolvedFeature = wr.getInstalledFeatures().resolveToHigherVersion(featureToResolve);
        if (resolvedFeature == null) {
            return;
        }
        if (!resolvedFeature.contains("-")) {
            resolvedFeature = resolvedFeature + "-*";
        }
        int i = 0;
        while (i < features.size()) {
            if (FeatureList.isEnabledBy(resolvedFeature, features.get(i), wr)) {
                return;
            }
            if (FeatureList.isEnabledBy(features.get(i), resolvedFeature, wr)) {
                if (!features.contains(resolvedFeature)) {
                    features.set(i, resolvedFeature);
                    ++i;
                    continue;
                }
                features.remove(i);
                continue;
            }
            ++i;
        }
        if (!features.contains(resolvedFeature)) {
            features.add(resolvedFeature);
        }
    }

    private static void addAcceptableAlternativesToFeatures(RequiredFeatureMap featureMap) {
        for (int i = 0; i < featureMap.getFeatures().length; ++i) {
            FeatureResolverFeature feature = featureMap.getFeatures()[i];
            for (String key : alternativeFeatureMap.keySet()) {
                if (!feature.name.equals(key) && !feature.name.startsWith(key + "-")) continue;
                List<String> currentAlternatives = feature.getAcceptedAlternatives();
                String[] alternativesToAdd = alternativeFeatureMap.get(key);
                String[] alternatives = new String[currentAlternatives.size() + alternativesToAdd.length];
                for (int j = 0; j < alternatives.length; ++j) {
                    alternatives[j] = j < currentAlternatives.size() ? currentAlternatives.get(j) : alternativesToAdd[j - currentAlternatives.size()];
                }
                featureMap.replaceFeature(feature, new FeatureResolverFeature(feature.getName(), alternatives));
            }
        }
    }

    public String toString() {
        return "FeatureResolverWrapper [" + this.configElement.getAttribute("id") + "]";
    }

    static {
        alternativeFeatureMap = new HashMap<String, String[]>();
        alternativeFeatureMap.put("jsf", new String[]{"jsfContainer"});
    }
}

