/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FeatureResolverFeature {
    String name;
    List<String> acceptedAlternatives = new ArrayList<String>();

    public FeatureResolverFeature(String name) {
        this.name = name;
        this.acceptedAlternatives = Collections.unmodifiableList(this.acceptedAlternatives);
    }

    public FeatureResolverFeature(String name, String[] acceptedAlternativesStringList) {
        this.name = name;
        if (acceptedAlternativesStringList != null && acceptedAlternativesStringList.length > 0) {
            this.acceptedAlternatives.addAll(Arrays.asList(acceptedAlternativesStringList));
        }
        this.acceptedAlternatives = Collections.unmodifiableList(this.acceptedAlternatives);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FeatureResolverFeature)) {
            return false;
        }
        FeatureResolverFeature otherFrf = (FeatureResolverFeature)o;
        return otherFrf.getName().equalsIgnoreCase(this.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public List<String> getAcceptedAlternatives() {
        return this.acceptedAlternatives;
    }

    public static String[] convertFeatureResolverArrayToStringArray(FeatureResolverFeature[] list) {
        if (list == null) {
            return null;
        }
        String[] result = new String[list.length];
        for (int x = 0; x < list.length; ++x) {
            result[x] = list[x].getName();
        }
        return result;
    }

    public static List<String> convertFeatureResolverArrayToStringList(FeatureResolverFeature[] list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(list.length);
        for (FeatureResolverFeature frf : list) {
            result.add(frf.getName());
        }
        return result;
    }
}

