/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal;

import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.st.common.core.internal.CommonServerUtil;
import com.ibm.ws.st.core.internal.ClasspathExtension;
import com.ibm.ws.st.core.internal.ConfigurationResourceChangeListener;
import com.ibm.ws.st.core.internal.DeleteRemoteServersPrompt;
import com.ibm.ws.st.core.internal.FeatureConflictHandler;
import com.ibm.ws.st.core.internal.FileUtil;
import com.ibm.ws.st.core.internal.IPromptIssue;
import com.ibm.ws.st.core.internal.IPromptResponse;
import com.ibm.ws.st.core.internal.IWebSphereMetadataListener;
import com.ibm.ws.st.core.internal.JMXMonitorThread;
import com.ibm.ws.st.core.internal.MessageHandler;
import com.ibm.ws.st.core.internal.Messages;
import com.ibm.ws.st.core.internal.MissingKeystoreHandler;
import com.ibm.ws.st.core.internal.PromptAction;
import com.ibm.ws.st.core.internal.PromptHandler;
import com.ibm.ws.st.core.internal.PromptUtil;
import com.ibm.ws.st.core.internal.PublishWithErrorHandler;
import com.ibm.ws.st.core.internal.ServerListenerUtil;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.UserDirectory;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereRuntimeProductInfoCacheUtil;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.generation.FeatureListExtMetadata;
import com.ibm.ws.st.core.internal.generation.MetaDataRemover;
import com.ibm.ws.st.core.internal.jmx.JMXConnectionInfo;
import com.ibm.ws.st.core.internal.launch.AbstractServerStartupExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.util.RuntimeLifecycleAdapter;
import org.eclipse.wst.server.core.util.ServerLifecycleAdapter;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "com.ibm.ws.st.core";
    public static final String SOURCE_PATH_EXTENSION_POINT = "websphereSourcePathComputers";
    private static Activator instance;
    private static final String PREFERENCE_KEY_ENABLE_AUTOMATIC_FEATURE_DETECTION = "enable.automatic.feature.detection";
    private static final String PREFERENCE_KEY_DEFAULT_CLASS_SCANNING = "default.class.scanning";
    private static final boolean PREFERENCE_DEFAULT_VALUE_ENABLE_AUTOMATIC_FEATURE_DETECTION = true;
    private static final int PREFERENCE_DEFAULT_VALUE_DEFAULT_CLASS_SCANNING;
    private IRuntimeLifecycleListener runtimeLifeCycleListener;
    private IServerLifecycleListener serverLifeCycleListener;
    private IWebSphereMetadataListener metadataListener;
    private ClasspathExtension[] classpathExtensions;
    private ClasspathExtension[] emptyContainerExtensions;
    private ISourcePathComputerDelegate[] sourcePathComputerExtensions;
    private AbstractServerStartupExtension[] preStartExtensions;
    private static PromptHandler promptHandler;
    private static FeatureConflictHandler featureConflictHandler;
    private static MissingKeystoreHandler missingKeystoreHandler;
    private static PublishWithErrorHandler publishWithErrorHandler;
    private static MessageHandler messageHandler;
    Properties serverMessageReplacementKey = null;
    private static final String SERVER_MESSAGE_REPLACEMENT_KEY_FILENAME = "serverMessageReplaceKey.properties";
    boolean isServerMessageReplacementKeyInited = false;
    private final List<IDebugTarget> debugTargets = new ArrayList<IDebugTarget>();
    public ServiceTracker<FeatureResolver, FeatureResolver> resolverTracker;
    private long publishWaitTime = -2L;
    private boolean useDynamiClasspathContainer = true;
    private boolean useDynamiClasspathContainerInitialized = false;
    private long runOnServerDelay = -1L;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Trace.ENABLED = this.isDebugging();
        this.resolverTracker = new ServiceTracker(context, FeatureResolver.class, null);
        this.resolverTracker.open();
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        props.put("listener.symbolic.name", PLUGIN_ID);
        context.registerService(DebugOptionsListener.class.getName(), (Object)Trace.TS, props);
        this.runtimeLifeCycleListener = new RuntimeLifecycleAdapter(){

            public void runtimeAdded(IRuntime runtime) {
                final WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
                Job runtimeAddedJob = new Job(Messages.jobRefreshRuntimeMetadata){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(Messages.jobRefreshRuntimeMetadata, 100);
                            monitor.worked(25);
                            if (wsRuntime != null) {
                                ConfigurationResourceChangeListener.start();
                                wsRuntime.createMetadata(null);
                                wsRuntime.createDefaultUserDirectory(null);
                                wsRuntime.initializeClasspathHelper();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                runtimeAddedJob.setPriority(20);
                runtimeAddedJob.schedule();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject[] projects = root.getProjects();
                final ArrayList<IProject> projectsToBuild = new ArrayList<IProject>();
                for (IProject project : projects) {
                    IFacetedProject facetedProject;
                    block8: {
                        block7: {
                            try {
                                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                                    continue;
                                }
                            }
                            catch (CoreException e) {
                                if (!Trace.ENABLED) break block7;
                                Trace.trace((byte)1, "Test for Java nature failed for project: " + project, e);
                            }
                        }
                        facetedProject = null;
                        try {
                            facetedProject = ProjectFacetsManager.create((IProject)project);
                        }
                        catch (CoreException e) {
                            if (!Trace.ENABLED) break block8;
                            Trace.trace((byte)1, "Failed to create faceted project for: " + project, e);
                        }
                    }
                    if (facetedProject == null) continue;
                    Set runtimes = facetedProject.getTargetedRuntimes();
                    org.eclipse.wst.common.project.facet.core.runtime.IRuntime facetRuntime = FacetUtil.getRuntime((IRuntime)runtime);
                    if (facetRuntime == null || !runtimes.contains(facetRuntime)) continue;
                    projectsToBuild.add(project);
                }
                if (!projectsToBuild.isEmpty()) {
                    Job rebuildProjectsJob = new Job(Messages.jobBuildNonJavaProjects){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                monitor.beginTask(Messages.jobBuildNonJavaProjects, 125);
                                monitor.worked(25);
                                int work = 100 / projectsToBuild.size();
                                for (IProject project : projectsToBuild) {
                                    try {
                                        project.build(15, (IProgressMonitor)new SubProgressMonitor(monitor, work));
                                    }
                                    catch (CoreException e) {
                                        if (!Trace.ENABLED) continue;
                                        Trace.trace((byte)1, "Project build failed for: " + project, e);
                                    }
                                }
                                monitor.worked(100 % projectsToBuild.size());
                            }
                            finally {
                                monitor.done();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    rebuildProjectsJob.setPriority(30);
                    rebuildProjectsJob.schedule();
                }
            }

            public void runtimeChanged(final IRuntime runtime) {
                Job runtimeChangedJob = new Job(Messages.jobRefreshRuntimeMetadata){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            monitor.beginTask(Messages.jobRefreshRuntimeMetadata, 100);
                            WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
                            monitor.worked(25);
                            if (wsRuntime != null) {
                                wsRuntime.runtimeChanged();
                                IPath newLoc = runtime.getLocation().append("usr");
                                if (!newLoc.equals((Object)wsRuntime.getProject().getLocation())) {
                                    wsRuntime.deleteProject(null);
                                    wsRuntime.createProject(null);
                                }
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return Status.OK_STATUS;
                    }
                };
                runtimeChangedJob.setPriority(20);
                runtimeChangedJob.schedule();
            }

            public void runtimeRemoved(IRuntime runtime) {
                WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
                if (wsRuntime != null) {
                    wsRuntime.removeMetadata(null, true, false);
                    wsRuntime.deleteProject(null);
                }
            }
        };
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeLifeCycleListener);
        this.serverLifeCycleListener = new ServerLifecycleAdapter(){

            public void serverRemoved(IServer server) {
                WebSphereServer serv;
                IServerType st = server.getServerType();
                if (st != null && st.getId().startsWith("com.ibm.ws.st") && (serv = (WebSphereServer)((Object)server.loadAdapter(WebSphereServer.class, null))) != null) {
                    serv.cleanup();
                    if (!serv.isLocalSetup()) {
                        UserDirectory userDir;
                        this.removeRemoteServerSecureStorageValues(serv);
                        this.removeTempRemoteServerUsrDirectoryFiles(serv);
                        this.removeDisableUtilityPromptPrefs(serv);
                        WebSphereRuntime wsRuntime = serv.getWebSphereRuntime();
                        IPath path = serv.getServerInfo().buildMetadataDirectoryPath();
                        if (path.toFile().exists()) {
                            try {
                                FileUtil.deleteDirectory(path.toOSString(), true);
                            }
                            catch (IOException e) {
                                Trace.logError("Failed to remove the server metadata directory: " + path.toOSString(), e);
                            }
                        }
                        if ((userDir = serv.getUserDirectory()) != null) {
                            serv.getServerInfo().updateCache();
                            try {
                                if (wsRuntime != null) {
                                    IRuntime runtime = wsRuntime.getRuntime();
                                    IRuntimeWorkingCopy runtimeWc = runtime.createWorkingCopy();
                                    WebSphereRuntime webSphereRuntime = (WebSphereRuntime)runtimeWc.loadAdapter(WebSphereRuntime.class, null);
                                    webSphereRuntime.removeUserDirectory(userDir);
                                    runtimeWc.save(true, null);
                                }
                            }
                            catch (Exception e1) {
                                Trace.logError("Failed to remove runtime user directory for: " + userDir.getPath().toOSString(), e1);
                            }
                            IProject proj = userDir.getProject();
                            if (proj != null) {
                                try {
                                    boolean doDeleteProjectFiles = false;
                                    PromptHandler promptHandler = Activator.getPromptHandler();
                                    if (promptHandler != null && !PromptUtil.isSuppressDialog()) {
                                        PromptHandler.AbstractPrompt[] prompts = new PromptHandler.AbstractPrompt[]{new DeleteRemoteServersPrompt(server, proj)};
                                        IPromptIssue issue = prompts[0].getIssues()[0];
                                        String selectedActionAlways = Activator.getPreference("deleteProjectFilesAlwaysAction", null);
                                        boolean applyAlways = Activator.getPreference("deleteProjectFilesApplyAlways", false);
                                        if (selectedActionAlways == null || !applyAlways) {
                                            IPromptResponse response = promptHandler.getResponse(Messages.remoteServerDeletePromptMessage, prompts, 273);
                                            applyAlways = response.getApplyAlways(issue);
                                            selectedActionAlways = response.getSelectedAction(issue).toString();
                                            Activator.setPreference("deleteProjectFilesAlwaysAction", selectedActionAlways);
                                            Activator.setPreference("deleteProjectFilesApplyAlways", applyAlways);
                                        }
                                        doDeleteProjectFiles = selectedActionAlways != null && !selectedActionAlways.equals(PromptAction.IGNORE.toString());
                                    }
                                    proj.delete(doDeleteProjectFiles, true, (IProgressMonitor)new NullProgressMonitor());
                                }
                                catch (CoreException e) {
                                    Trace.logError("Failed to remove deleted server's user directory project", e);
                                }
                            }
                        }
                        if (wsRuntime != null) {
                            wsRuntime.updateServerCache(true);
                        }
                    }
                }
            }

            public void serverChanged(IServer server) {
                block5: {
                    WebSphereServerBehaviour servB;
                    IServerType st = server.getServerType();
                    if (st != null && st.getId().startsWith("com.ibm.ws.st") && (servB = (WebSphereServerBehaviour)((Object)server.getAdapter(WebSphereServerBehaviour.class))) != null) {
                        servB.syncExternalModules();
                        if (servB.monitorThread instanceof JMXMonitorThread) {
                            try {
                                WebSphereServer wsServer = servB.getWebSphereServer();
                                JMXConnectionInfo oldJMXInfo = wsServer.getJMXConnectionInfo();
                                JMXConnectionInfo curJMXInfo = new JMXConnectionInfo(wsServer);
                                wsServer.setJMXConnectionInfo(curJMXInfo);
                                if (oldJMXInfo != null && !curJMXInfo.equals(oldJMXInfo)) {
                                    servB.stopMonitorThread();
                                    servB.startMonitorThread();
                                }
                            }
                            catch (Exception e) {
                                if (!Trace.ENABLED) break block5;
                                Trace.trace((byte)1, "There was a problem determining if jmx connection should be reset.", e);
                            }
                        }
                    }
                }
            }

            public void serverAdded(IServer server) {
            }

            private void removeRemoteServerSecureStorageValues(WebSphereServer server) {
                try {
                    ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
                    String nodeName = CommonServerUtil.getSecurePreferenceNodeName((IServer)server.getServer());
                    if (preferences.nodeExists(nodeName)) {
                        ISecurePreferences node = preferences.node(nodeName);
                        node.removeNode();
                    }
                    preferences.flush();
                }
                catch (Throwable t) {
                    Trace.logError("Failed to remove secure storage values for server: " + server.getServerName(), t);
                }
            }

            private void removeTempRemoteServerUsrDirectoryFiles(WebSphereServer server) {
                try {
                    IPath serverDir;
                    UserDirectory usrDir = server.getUserDirectory();
                    if (usrDir != null && usrDir.getPath().toOSString().startsWith(Activator.getInstance().getStateLocation().toOSString()) && (serverDir = usrDir.getPath().append("servers").append(server.getServerName())).toFile().exists()) {
                        FileUtil.deleteDirectory(serverDir.toOSString(), true);
                    }
                }
                catch (Throwable t) {
                    Trace.logError("Failed to remove remote usr directory files for server: " + server.getServerName(), t);
                }
            }

            private void removeDisableUtilityPromptPrefs(WebSphereServer server) {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(Activator.PLUGIN_ID);
                String remoteSettingsDisabled = server.getServer().getId() + "_" + "remoteSettingsDisabledPrompt";
                String utilityNotSupported = server.getServer().getId() + "_" + "utilityNotSupportedPrompt";
                try {
                    prefs.remove(remoteSettingsDisabled);
                    prefs.remove(utilityNotSupported);
                    prefs.flush();
                }
                catch (Exception e) {
                    Trace.logError("Error removing keys: " + remoteSettingsDisabled + ", " + utilityNotSupported, e);
                }
            }
        };
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifeCycleListener);
        this.metadataListener = new IWebSphereMetadataListener(){

            @Override
            public void runtimeMetadataChanged(final IRuntime runtime) {
                final String msg = NLS.bind((String)Messages.jobRefreshConfigurationFiles, (Object)runtime.getName());
                Job refreshConfigFiles = new Job(msg){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor progressMonitor) {
                        block9: {
                            int totalWork = 100;
                            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)msg, (int)totalWork);
                            try {
                                List<WebSphereServerInfo> serverInfos;
                                WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
                                if (wsRuntime == null || (serverInfos = wsRuntime.getWebSphereServerInfos()).size() <= 0) break block9;
                                int serverWork = totalWork / serverInfos.size();
                                for (WebSphereServerInfo info : serverInfos) {
                                    ConfigurationFile[] configFiles = info.getConfigurationFiles();
                                    if (configFiles.length <= 0) continue;
                                    int fileWork = serverWork / configFiles.length;
                                    for (ConfigurationFile file : configFiles) {
                                        block10: {
                                            IFile iFile = file.getIFile();
                                            if (iFile != null) {
                                                try {
                                                    iFile.touch((IProgressMonitor)monitor.newChild(fileWork));
                                                }
                                                catch (CoreException e) {
                                                    if (!Trace.ENABLED) break block10;
                                                    Trace.trace((byte)1, "Touch failed on file: " + iFile.getLocation().toOSString(), e);
                                                }
                                            }
                                        }
                                        if (!monitor.isCanceled()) continue;
                                        IStatus iStatus = Status.CANCEL_STATUS;
                                        return iStatus;
                                    }
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                refreshConfigFiles.setPriority(30);
                refreshConfigFiles.schedule();
            }
        };
        ServerListenerUtil.getInstance().addMetadataListener(this.metadataListener);
        ArrayList<ClasspathExtension> includeList = new ArrayList<ClasspathExtension>();
        ArrayList<ClasspathExtension> emptyContainerlist = new ArrayList<ClasspathExtension>();
        ClasspathExtension.createClasspathExtensions(includeList, emptyContainerlist);
        this.classpathExtensions = includeList.toArray(new ClasspathExtension[includeList.size()]);
        this.emptyContainerExtensions = emptyContainerlist.toArray(new ClasspathExtension[emptyContainerlist.size()]);
        this.checkRuntimeMetadata();
    }

    public void stop(BundleContext context) throws Exception {
        MetaDataRemover.removeOutOfSyncMetaData();
        this.resolverTracker.close();
        ServerCore.removeRuntimeLifecycleListener((IRuntimeLifecycleListener)this.runtimeLifeCycleListener);
        ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifeCycleListener);
        ServerListenerUtil.getInstance().removeMetadataListener(this.metadataListener);
        instance = null;
        ConfigurationResourceChangeListener.stop();
        this.terminateDebugTargets();
        super.stop(context);
    }

    public static Activator getInstance() {
        return instance;
    }

    public ClasspathExtension[] getClasspathExtensions() {
        return this.classpathExtensions;
    }

    public ClasspathExtension[] getEmptyContainerExtensions() {
        return this.emptyContainerExtensions;
    }

    public static String getPreference(String key, String defaultValue) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).get(key, defaultValue);
    }

    public static boolean getPreference(String key, boolean defaultValue) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).getBoolean(key, defaultValue);
    }

    public static int getPreference(String key, int defaultValue) {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID).getInt(key, defaultValue);
    }

    public static void setPreference(String key, boolean value) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            prefs.putBoolean(key, value);
            prefs.flush();
        }
        catch (Exception e) {
            Trace.logError("Error setting preference " + key, e);
        }
    }

    public static void setPreference(String key, String value) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            if (value == null) {
                prefs.remove(key);
            } else {
                prefs.put(key, value);
            }
            prefs.flush();
        }
        catch (Exception e) {
            Trace.logError("Error setting preference " + key, e);
        }
    }

    public static void setPreference(String key, int value) {
        try {
            IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(PLUGIN_ID);
            prefs.putInt(key, value);
            prefs.flush();
        }
        catch (Exception e) {
            Trace.logError("Error setting preference " + key, e);
        }
    }

    public static void setPromptHandler(PromptHandler newPromptHandler) {
        promptHandler = newPromptHandler;
    }

    public static PromptHandler getPromptHandler() {
        return promptHandler;
    }

    public static void setFeatureConflictHandler(FeatureConflictHandler handler) {
        featureConflictHandler = handler;
    }

    public static FeatureConflictHandler getFeatureConflictHandler() {
        return featureConflictHandler;
    }

    public static void setMissingKeystoreHandler(MissingKeystoreHandler handler) {
        missingKeystoreHandler = handler;
    }

    public static MissingKeystoreHandler getMissingKeystoreHandler() {
        return missingKeystoreHandler;
    }

    public static String getBundleVersion() {
        return Activator.getInstance().getBundle().getVersion().toString();
    }

    public static PublishWithErrorHandler getPublishWithErrorHandler() {
        return publishWithErrorHandler;
    }

    public static void setPublishWithErrorHandler(PublishWithErrorHandler errorHandler) {
        publishWithErrorHandler = errorHandler;
    }

    public static MessageHandler getMessageHandler() {
        return messageHandler;
    }

    public static void setMessageHandler(MessageHandler handler) {
        messageHandler = handler;
    }

    public long getPreferencePublishWaitTimeMS() {
        if (this.publishWaitTime == -2L) {
            try {
                this.publishWaitTime = Long.parseLong(Activator.getPreference("publish.exit.timeout", "-1"));
            }
            catch (NumberFormatException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Hidden preference publish.exit.timeout is invalid");
                }
                this.publishWaitTime = -1L;
            }
        }
        return this.publishWaitTime;
    }

    public boolean getPreferenceUseDynamicClasspathContainer() {
        if (!this.useDynamiClasspathContainerInitialized) {
            this.useDynamiClasspathContainer = Boolean.parseBoolean(Activator.getPreference("dynamic.classpath.container", "true"));
            this.useDynamiClasspathContainerInitialized = true;
        }
        return this.useDynamiClasspathContainer;
    }

    public void setPreferenceUseDynamicClasspathContainer(boolean value) {
        this.useDynamiClasspathContainer = value;
        Activator.setPreference("dynamic.classpath.container", Boolean.toString(this.useDynamiClasspathContainer));
        this.useDynamiClasspathContainerInitialized = false;
    }

    public long getPreferenceRunOnServerDelayTimeMS() {
        if (this.runOnServerDelay == -1L) {
            try {
                this.runOnServerDelay = Long.parseLong(Activator.getPreference("run.on.server.delay", "0"));
            }
            catch (NumberFormatException e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "Hidden preference run.on.server.delay is invalid");
                }
                this.runOnServerDelay = 0L;
            }
        }
        return this.runOnServerDelay;
    }

    public Properties getServerMessageReplacementKey() {
        if (!this.isServerMessageReplacementKeyInited) {
            Properties props = new Properties();
            FileUtil.loadProperties(props, this.getStateLocation().append(SERVER_MESSAGE_REPLACEMENT_KEY_FILENAME));
            this.serverMessageReplacementKey = props.isEmpty() ? null : props;
            this.isServerMessageReplacementKeyInited = true;
        }
        return this.serverMessageReplacementKey;
    }

    private void checkRuntimeMetadata() {
        Job job = new Job(Messages.jobRefreshRuntimeMetadata){

            protected IStatus run(IProgressMonitor monitor) {
                WebSphereRuntime[] wsRuntimes = WebSphereUtil.getWebSphereRuntimes();
                monitor.beginTask(Messages.jobRefreshRuntimeMetadata, wsRuntimes.length);
                if (wsRuntimes.length > 0) {
                    ConfigurationResourceChangeListener.start();
                }
                for (WebSphereRuntime wsRuntime : wsRuntimes) {
                    monitor.setTaskName(NLS.bind((String)Messages.jobRuntimeCache, (Object)wsRuntime.getRuntime().getName()));
                    Properties info = WebSphereRuntimeProductInfoCacheUtil.getChangedProductInfo(wsRuntime);
                    if (info != null) {
                        wsRuntime.generateMetadata(null, false);
                        WebSphereRuntimeProductInfoCacheUtil.saveProductInfoCache(wsRuntime, info);
                    } else {
                        FeatureListExtMetadata.getInstances(wsRuntime);
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return "com.ibm.ws.st.core.job.family".equals(family);
            }
        };
        job.schedule(2000L);
    }

    private ISourcePathComputerDelegate[] loadSourcePathComputers() {
        IConfigurationElement[] cf;
        ArrayList<ISourcePathComputerDelegate> delegates = new ArrayList<ISourcePathComputerDelegate>(1);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        for (IConfigurationElement ce : cf = registry.getConfigurationElementsFor(PLUGIN_ID, SOURCE_PATH_EXTENSION_POINT)) {
            try {
                ISourcePathComputerDelegate delegate = (ISourcePathComputerDelegate)ce.createExecutableExtension("class");
                delegates.add(delegate);
            }
            catch (CoreException e) {
                Trace.logError("Error while creating executable extension for source path computer", e);
            }
        }
        return delegates.toArray(new ISourcePathComputerDelegate[delegates.size()]);
    }

    public ISourcePathComputerDelegate[] getSourcePathComputers() {
        if (this.sourcePathComputerExtensions == null) {
            this.sourcePathComputerExtensions = this.loadSourcePathComputers();
        }
        return this.sourcePathComputerExtensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDebugTarget(IDebugTarget debugTarget) {
        if (debugTarget == null) {
            return;
        }
        List<IDebugTarget> list = this.debugTargets;
        synchronized (list) {
            this.debugTargets.add(debugTarget);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDebugTarget(IDebugTarget debugTarget) {
        if (debugTarget == null) {
            return;
        }
        List<IDebugTarget> list = this.debugTargets;
        synchronized (list) {
            Iterator<IDebugTarget> iterator = this.debugTargets.iterator();
            while (iterator.hasNext()) {
                IDebugTarget target = iterator.next();
                if (target != debugTarget) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateDebugTargets() {
        List<IDebugTarget> list = this.debugTargets;
        synchronized (list) {
            for (IDebugTarget target : this.debugTargets) {
                try {
                    target.disconnect();
                    target.terminate();
                }
                catch (DebugException e) {
                    if (!Trace.ENABLED) continue;
                    Trace.trace((byte)1, "Could not disconnect debug target", e);
                }
            }
            this.debugTargets.clear();
        }
    }

    public static FeatureResolver getFeatureResolver() {
        return (FeatureResolver)Activator.instance.resolverTracker.getService();
    }

    public AbstractServerStartupExtension[] getPreStartExtensions() {
        if (this.preStartExtensions != null) {
            return this.preStartExtensions;
        }
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.ws.st.core.serverPreStart");
        ArrayList<AbstractServerStartupExtension> startupExtList = new ArrayList<AbstractServerStartupExtension>(1);
        for (IConfigurationElement elem : configElements) {
            try {
                AbstractServerStartupExtension startup = (AbstractServerStartupExtension)elem.createExecutableExtension("class");
                startupExtList.add(startup);
            }
            catch (CoreException e) {
                Trace.logError("Error while creating executable extension for startup", e);
            }
        }
        this.preStartExtensions = startupExtList.toArray(new AbstractServerStartupExtension[startupExtList.size()]);
        return this.preStartExtensions;
    }

    public static boolean isAutomaticFeatureDetectionEnabled() {
        return Activator.getPreference(PREFERENCE_KEY_ENABLE_AUTOMATIC_FEATURE_DETECTION, true);
    }

    public static void setAutomaticFeatureDetection(boolean enabled) {
        Activator.setPreference(PREFERENCE_KEY_ENABLE_AUTOMATIC_FEATURE_DETECTION, enabled);
    }

    public static int getDefaultClassScanning() {
        return Activator.getPreference(PREFERENCE_KEY_DEFAULT_CLASS_SCANNING, PREFERENCE_DEFAULT_VALUE_DEFAULT_CLASS_SCANNING);
    }

    public static void setDefaultClassScanning(int value) {
        Activator.setPreference(PREFERENCE_KEY_DEFAULT_CLASS_SCANNING, value);
    }

    public static boolean getAutomaticFeatureDetectionEnabledDefault() {
        return true;
    }

    public static int getDefaultClassScanningDefaultValue() {
        String prop = System.getProperty("com.ibm.ws.st.addFeatureDefault", "alwaysAdd");
        if (prop.equals("neverAdd")) {
            return 2;
        }
        if (prop.equals("prompt")) {
            return 0;
        }
        return 1;
    }

    static {
        PREFERENCE_DEFAULT_VALUE_DEFAULT_CLASS_SCANNING = Activator.getDefaultClassScanningDefaultValue();
    }
}

