/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

public class SharedLibRefInfo
extends Properties {
    private static final long serialVersionUID = 1L;
    private static final String DELIM = ",";

    public List<ConfigurationFile.LibRef> getLibRefs() {
        String ids = this.getProperty("com.ibm.ws.st.jee.shared.library.ref.id", "");
        StringTokenizer stIds = new StringTokenizer(ids, DELIM);
        String types = this.getProperty("com.ibm.ws.st.jee.shared.library.ref.type", "");
        StringTokenizer stTypes = new StringTokenizer(types, DELIM);
        ArrayList<ConfigurationFile.LibRef> refs = new ArrayList<ConfigurationFile.LibRef>();
        while (stIds.hasMoreTokens()) {
            String typeStr;
            String id = stIds.nextToken().trim();
            if (id.isEmpty()) continue;
            ConfigurationFile.LibraryRefType type = ConfigurationFile.LibraryRefType.COMMON;
            if (stTypes.hasMoreTokens() && !(typeStr = stTypes.nextToken().trim()).isEmpty()) {
                type = ConfigurationFile.LibraryRefType.getLibraryRefType((String)typeStr);
            }
            refs.add(new ConfigurationFile.LibRef(id, type));
        }
        return refs;
    }

    public void setLibRefs(List<ConfigurationFile.LibRef> refs) {
        StringBuilder sbIds = new StringBuilder();
        StringBuilder sbTypes = new StringBuilder();
        if (refs != null) {
            boolean first = true;
            for (ConfigurationFile.LibRef ref : refs) {
                if (first) {
                    sbIds.append(ref.id);
                    sbTypes.append(ref.type.getName());
                    first = false;
                    continue;
                }
                sbIds.append(DELIM).append(ref.id);
                sbTypes.append(DELIM).append(ref.type.getName());
            }
        }
        this.setProperty("com.ibm.ws.st.jee.shared.library.ref.id", sbIds.toString());
        this.setProperty("com.ibm.ws.st.jee.shared.library.ref.type", sbTypes.toString());
    }

    private final void readObject(ObjectInputStream in) throws IOException {
        throw new IOException("Cannot be deserialized");
    }
}

