/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.ui.internal;

import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import com.ibm.ws.st.docker.ui.internal.Messages;
import com.ibm.ws.st.docker.ui.internal.Trace;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.server.core.IServer;

public class DockerContainerInfoPropertyPage
extends PropertyPage {
    private static final int INDENT = 10;

    public DockerContainerInfoPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        try {
            WebSphereServer wsServer;
            IAdaptable element = this.getElement();
            IServer server = (IServer)element.getAdapter(IServer.class);
            BaseDockerContainer container = null;
            Map serviceInfo = null;
            if (server != null && (wsServer = (WebSphereServer)server.getAdapter(WebSphereServer.class)) != null) {
                serviceInfo = wsServer.getServiceInfo();
                LibertyDockerServer serverExt = (LibertyDockerServer)wsServer.getAdapter(LibertyDockerServer.class);
                if (serverExt != null) {
                    container = serverExt.getContainer(wsServer);
                }
            }
            final Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            final Label progressLabel = new Label(composite, 0);
            progressLabel.setText(Messages.dockerInfoTask);
            progressLabel.setLayoutData((Object)new GridData(4, 3, true, true));
            final ProgressIndicator progress = new ProgressIndicator(composite);
            progress.setLayoutData((Object)new GridData(4, 3, true, false));
            Dialog.applyDialogFont((Control)composite);
            if (container == null || serviceInfo == null) {
                Label label = new Label(composite, 8);
                label.setLayoutData((Object)new GridData(4, 1, true, false));
                label.setText(Messages.dockerInfoUnavailable);
                progressLabel.dispose();
                progress.dispose();
            } else {
                final Display display = this.getShell().getDisplay();
                final BaseDockerContainer container2 = container;
                final Map serviceInfo2 = serviceInfo;
                Thread t = new Thread("Docker container info"){

                    @Override
                    public void run() {
                        NullProgressMonitor monitor = new NullProgressMonitor(){

                            public void beginTask(String name, final int max) {
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        progress.beginTask(max);
                                    }
                                });
                            }

                            public void worked(final int work) {
                                display.syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        progress.worked((double)work);
                                    }
                                });
                            }
                        };
                        monitor.beginTask(Messages.dockerInfoTask, 100);
                        try {
                            String hostIP = null;
                            if (container2.getDockerMachine().isRealMachine()) {
                                hostIP = container2.getDockerMachine().getHost();
                            }
                            monitor.worked(50);
                            String currentImage = container2.getImageName();
                            monitor.worked(50);
                            monitor.done();
                            final String hostIP2 = hostIP;
                            final String currentImage2 = currentImage;
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    progressLabel.dispose();
                                    progress.dispose();
                                    boolean isOriginalContainer = container2.getContainerName().equals(serviceInfo2.get("dockerContainer"));
                                    if (!isOriginalContainer) {
                                        DockerContainerInfoPropertyPage.this.createHeader(composite, Messages.dockerInfoWorkingContainerLabel);
                                        DockerContainerInfoPropertyPage.this.createItem(composite, Messages.dockerInfoName, container2.getContainerName());
                                        DockerContainerInfoPropertyPage.this.createItem(composite, Messages.dockerInfoImageName, currentImage2);
                                    }
                                    if (isOriginalContainer) {
                                        DockerContainerInfoPropertyPage.this.createHeader(composite, Messages.dockerInfoContainerLabel);
                                    } else {
                                        DockerContainerInfoPropertyPage.this.createHeader(composite, Messages.dockerInfoOrigContainerLabel);
                                    }
                                    DockerContainerInfoPropertyPage.this.createItem(composite, Messages.dockerInfoName, (String)serviceInfo2.get("dockerContainer"));
                                    DockerContainerInfoPropertyPage.this.createItem(composite, Messages.dockerInfoImageName, (String)serviceInfo2.get("dockerImage"));
                                    if (container2.getDockerMachine().isRealMachine()) {
                                        DockerContainerInfoPropertyPage.this.createHeader(composite, Messages.dockerInfoMachineLabel);
                                        DockerContainerInfoPropertyPage.this.createItem(composite, Messages.dockerInfoName, container2.getDockerMachine().getMachineName());
                                        DockerContainerInfoPropertyPage.this.createItem(composite, Messages.dockerInfoMachineIP, hostIP2);
                                    }
                                    composite.layout(true);
                                }
                            });
                        }
                        catch (Exception e) {
                            display.syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    progressLabel.dispose();
                                    progress.dispose();
                                    Label label = new Label(composite, 8);
                                    label.setLayoutData((Object)new GridData(4, 1, true, false));
                                    label.setText(Messages.dockerInfoUnavailable);
                                    composite.layout(true);
                                }
                            });
                        }
                    }
                };
                t.setDaemon(true);
                t.start();
            }
            return composite;
        }
        catch (Exception e) {
            Trace.logError("Error creating product info property page", e);
            return null;
        }
    }

    protected void createHeader(Composite composite, String str) {
        StyledText label = new StyledText(composite, 8);
        label.setForeground(composite.getForeground());
        label.setBackground(composite.getBackground());
        label.setText(str);
        StyleRange range = new StyleRange();
        range.start = 0;
        range.length = str.length();
        range.fontStyle = 1;
        label.setStyleRange(range);
        GridData data = new GridData(4, 1, true, false);
        data.verticalIndent = 5;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
    }

    protected void createItem(Composite composite, String labelStr, String value) {
        Label label = new Label(composite, 0);
        label.setText(labelStr);
        GridData data = new GridData(1, 1, false, false);
        data.horizontalIndent = 10;
        label.setLayoutData((Object)data);
        Text text = new Text(composite, 8);
        text.setText(value);
        data = new GridData(4, 1, false, false);
        text.setLayoutData((Object)data);
    }
}

