/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.maven.liberty.integration.manager.internal;

import com.ibm.etools.maven.liberty.integration.internal.LibertyMavenConstants;
import com.ibm.etools.maven.liberty.integration.internal.Trace;
import com.ibm.etools.maven.liberty.integration.manager.internal.LibertyMavenProjectMapping;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.IProjectInspector;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.xml.internal.LibertyBuildPluginXMLConfigurationReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Set;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class MavenProjectInspector
implements IProjectInspector {
    private final IProject project;
    private LibertyBuildPluginConfiguration projectConfig;
    private LibertyBuildPluginConfiguration cachedProjectConfig;

    public MavenProjectInspector(IProject project) {
        this.project = project;
    }

    public LibertyBuildPluginConfiguration getBuildPluginConfiguration(IProgressMonitor monitor) {
        try {
            File configFile = this.getLibertyBuildPluginConfigFile(monitor);
            if (configFile == null) {
                return null;
            }
            if (this.projectConfig == null) {
                this.projectConfig = this.populateConfiguration(configFile, monitor);
            }
        }
        catch (Exception e) {
            Trace.trace((byte)0, "Error reading project configuration for project: " + this.project.getName(), e);
        }
        return this.projectConfig;
    }

    public LibertyBuildPluginConfiguration getCachedBuildPluginConfiguration(IProgressMonitor monitor) {
        try {
            File configFile = this.getCachedLibertyBuildPluginConfigurationFile(monitor);
            if (configFile == null) {
                return null;
            }
            if (this.cachedProjectConfig == null) {
                this.cachedProjectConfig = this.populateConfiguration(configFile, monitor);
            }
        }
        catch (Exception e) {
            Trace.logError("Error reading project configuration for project: " + this.project.getName(), e);
        }
        return this.cachedProjectConfig;
    }

    public File getCachedLibertyBuildPluginConfigurationFile(IProgressMonitor monitor) {
        IPath cachePath = LibertyMavenProjectMapping.getInstance().getLibertyBuildProjectCachePath(this.project.getName());
        if (cachePath == null) {
            return null;
        }
        return cachePath.toFile();
    }

    public boolean isSupportedProject(IProgressMonitor monitor) {
        try {
            if (!this.isMavenProject()) {
                return false;
            }
            IFile pom = this.project.getFile("pom.xml");
            Model model = this.getModelObject(pom);
            if (model == null) {
                return false;
            }
            File configFile = this.getLibertyBuildPluginConfigFile(monitor);
            if (configFile == null) {
                return false;
            }
            return configFile.exists();
        }
        catch (Exception e) {
            Trace.trace((byte)0, "Error encountered while checking whether project " + this.project.getName() + " is a Liberty Maven enhanced project", e);
            return false;
        }
    }

    public boolean isMavenProject() {
        try {
            return this.project.hasNature("org.eclipse.m2e.core.maven2Nature");
        }
        catch (CoreException e) {
            Trace.trace((byte)0, "Error getting the description for the project " + this.project.getName(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getModelObject(IFile pomFile) {
        if (pomFile == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "A pom file was not specified before attempting to create the model");
            }
            return null;
        }
        InputStreamReader streamReader = null;
        try {
            Model model;
            if (!pomFile.exists()) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)1, "The pom file cannot be found: " + pomFile.getLocation().toOSString());
                }
                Model model2 = null;
                return model2;
            }
            MavenXpp3Reader reader = new MavenXpp3Reader();
            streamReader = new InputStreamReader(new FileInputStream(pomFile.getLocation().toFile()));
            Model model3 = model = reader.read((Reader)streamReader);
            return model3;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.logError("The pom file could not be read", e);
            }
        }
        finally {
            block21: {
                if (streamReader != null) {
                    try {
                        streamReader.close();
                    }
                    catch (IOException e) {
                        if (!Trace.ENABLED) break block21;
                        Trace.trace((byte)1, "Failed to close the InputStreamReader for the pom file: " + pomFile.getLocation().toOSString());
                    }
                }
            }
        }
        return null;
    }

    public File getLibertyBuildPluginConfigFile(IProgressMonitor mon) throws CoreException {
        IFile f = this.project.getFile("target/liberty-plugin-config.xml");
        if (f != null && f.exists()) {
            return f.getLocation().toFile();
        }
        MavenProject mavenProject = this.getMavenProject(mon);
        if (mavenProject == null) {
            return null;
        }
        Build build = mavenProject.getBuild();
        if (build == null) {
            return null;
        }
        String outputDirectory = build.getDirectory();
        if (outputDirectory == null) {
            return null;
        }
        Path outputPath = new Path(outputDirectory);
        IPath libertyPluginConfigPath = outputPath.append("liberty-plugin-config.xml");
        return libertyPluginConfigPath.toFile();
    }

    public LibertyBuildPluginConfiguration populateConfiguration(File configFile, IProgressMonitor monitor) throws IOException {
        if (monitor != null && monitor.isCanceled() || configFile == null || !configFile.exists()) {
            return null;
        }
        Trace.trace((byte)0, "Reading configFile from" + configFile.getAbsolutePath());
        LibertyBuildPluginXMLConfigurationReader reader = new LibertyBuildPluginXMLConfigurationReader();
        return reader.load(configFile.toURI());
    }

    private MavenProject getMavenProject(IProgressMonitor monitor) throws CoreException {
        IFile pom = this.project.getFile("pom.xml");
        if (pom == null) {
            return null;
        }
        IPath location = pom.getLocation();
        if (location == null || !location.toFile().exists()) {
            return null;
        }
        return MavenPlugin.getMaven().readProject(location.toFile(), monitor);
    }

    public String getLibertyPluginVersion(IProgressMonitor monitor) throws CoreException {
        for (Plugin plugin : this.getMavenProject(monitor).getBuildPlugins()) {
            if (!"liberty-maven-plugin".equals(plugin.getArtifactId())) continue;
            return plugin.getVersion();
        }
        return "";
    }

    public boolean useLegacyMvnGoal(IProgressMonitor monitor) {
        try {
            String libertyPluginVersion = this.getLibertyPluginVersion(monitor);
            if (libertyPluginVersion.indexOf(46) > 0) {
                String majorVersion = libertyPluginVersion.substring(0, libertyPluginVersion.indexOf(46));
                return Integer.parseInt(majorVersion) < 3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isSupportedModule(IModule module) {
        if (module == null) {
            Trace.trace((byte)0, "The maven project " + this.project.getName() + " does not map to a supported module type.");
            return false;
        }
        String id = module.getModuleType().getId();
        if ("jst.web".equals(id) || "jst.ear".equals(id)) {
            return true;
        }
        Trace.trace((byte)0, "The maven project " + this.project.getName() + " is detected as a module but does not specify a supported packaging type (eg. war packaging type).");
        return false;
    }

    public IModule[] getProjectModules() {
        IModule[] modules = new IModule[]{};
        LibertyMavenConstants.ProjectType projectType = this.getProjectType();
        try {
            switch (projectType) {
                case LIBERTY_ASSEMBLY: {
                    modules = this.getLibertyAssemblyModules();
                    break;
                }
                default: {
                    IModule m = ServerUtil.getModule((IProject)this.project);
                    if (m == null) break;
                    modules = new IModule[]{m};
                }
            }
            StringBuffer moduleMsg = new StringBuffer("Found the following dependency modules for project " + this.project.getName() + ": {");
            for (int i = 0; i < modules.length; ++i) {
                if (i > 0) {
                    moduleMsg.append(", ");
                }
                moduleMsg.append(modules[i].getName());
            }
            moduleMsg.append("}");
            Trace.trace((byte)0, moduleMsg.toString());
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Unable to retrieve modules for project " + this.project.getName() + ".", e);
        }
        return modules;
    }

    private IModule[] getLibertyAssemblyModules() {
        Trace.trace((byte)0, "Looking up modules for project " + this.project.getName());
        LibertyBuildPluginConfiguration config = this.getBuildPluginConfiguration(null);
        Set dependencies = config.getProjectCompileDependencies();
        ArrayList<IModule> modules = new ArrayList<IModule>();
        for (String dependency : dependencies) {
            IModule[] serverModules;
            IMavenProjectFacade p;
            String[] gav = dependency.split(":");
            if (gav.length != 3 || (p = MavenPlugin.getMavenProjectRegistry().getMavenProject(gav[0], gav[1], gav[2])) == null || (serverModules = ServerUtil.getModules((IProject)p.getProject())) == null) continue;
            for (IModule m : serverModules) {
                modules.add(m);
            }
        }
        return modules.toArray(new IModule[modules.size()]);
    }

    public LibertyMavenConstants.ProjectType getProjectType() {
        LibertyBuildPluginConfiguration config = this.getBuildPluginConfiguration(null);
        String projectType = config.getConfigValue(ConfigurationType.projectType);
        if ("liberty-assembly".equals(projectType)) {
            return LibertyMavenConstants.ProjectType.LIBERTY_ASSEMBLY;
        }
        return LibertyMavenConstants.ProjectType.STANDARD;
    }
}

