/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.validation;

import com.ibm.xwt.dde.customization.ICustomItemValidationObject;
import com.ibm.xwt.dde.customization.ICustomListValidationObject;
import com.ibm.xwt.dde.customization.ICustomNodeValidationObject;
import com.ibm.xwt.dde.customization.ICustomPossibleValuesObject;
import com.ibm.xwt.dde.customization.ICustomTableItemValidationObject;
import com.ibm.xwt.dde.customization.ValidationMessage;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.data.AtomicDetailItem;
import com.ibm.xwt.dde.internal.data.DetailItem;
import com.ibm.xwt.dde.internal.data.RepeatableAtomicDetailItemSet;
import com.ibm.xwt.dde.internal.data.SimpleDetailItem;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.validation.DataTypeValidator;
import com.ibm.xwt.dde.internal.validation.DetailItemValidation;
import com.ibm.xwt.dde.internal.viewers.DetailsContentProvider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMGroup;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNodeList;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQueryAction;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ValidationManager {
    public static final int EDITOR_VALIDATION = 0;
    public static final int WORKBENCH_VALIDATION = 1;
    private CustomizationManager.Customization customization;
    private IEditorInput editorInput;
    private DetailsContentProvider detailsContentProvider;
    private MessageManager messageManager;
    private Document document;
    private IResource resource;
    private DataTypeValidator dataTypeValidator;
    private int validationEnviroment;
    boolean isCustomListValidation = false;

    public ValidationManager(CustomizationManager.Customization customization, IResource resource, int validationEnviroment) {
        this.customization = customization;
        this.resource = resource;
        this.detailsContentProvider = new DetailsContentProvider(customization);
        this.messageManager = new MessageManager();
        this.dataTypeValidator = new DataTypeValidator();
        this.validationEnviroment = validationEnviroment;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public void setEditorInput(IEditorInput editor) {
        this.editorInput = editor;
    }

    public IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public void validateDocument() {
        if (this.document != null) {
            this.messageManager.clearMessages();
            Element documentElement = this.document.getDocumentElement();
            if (documentElement != null) {
                this.validateTreeNode(documentElement, true, false, true);
            }
        }
    }

    public void validateDetailItem(Element containingTreeNodeElement, DetailItem detailItem, boolean skipTriggeredValidations) {
        this.validateDetailItem(containingTreeNodeElement, null, detailItem, skipTriggeredValidations);
    }

    public void validateDetailItem(Element containingTreeNodeElement, SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem, boolean skipTriggeredValidations) {
        DetailItemCustomization detailItemCustomization;
        if (detailItem instanceof AtomicDetailItem) {
            AtomicDetailItem atomicDetailItem = (AtomicDetailItem)detailItem;
            this.validateAtomicDetailItem(containingTreeNodeElement, containingSimpleDetailItem, atomicDetailItem);
        } else if (detailItem instanceof RepeatableAtomicDetailItemSet) {
            RepeatableAtomicDetailItemSet repeatableAtomicDetailItemSet = (RepeatableAtomicDetailItemSet)detailItem;
            this.validateRepeatableAtomicDetailItemSet(containingTreeNodeElement, containingSimpleDetailItem, repeatableAtomicDetailItemSet);
        } else if (detailItem instanceof SimpleDetailItem) {
            SimpleDetailItem simpleDetailItem = (SimpleDetailItem)detailItem;
            this.validateSimpleDetailItem(containingTreeNodeElement, simpleDetailItem, skipTriggeredValidations);
        }
        if (!skipTriggeredValidations && (detailItemCustomization = detailItem.getDetailItemCustomization()) != null) {
            String[] triggerValidationPath = detailItemCustomization.getTriggerValidationPath();
            boolean[] triggerValidationRecurse = detailItemCustomization.isTrigerNodeValidationRecurse();
            for (int i = 0; i < triggerValidationPath.length; ++i) {
                Node[] instances = ModelUtil.getInstances(this.document, triggerValidationPath[i]);
                for (int j = 0; j < instances.length; ++j) {
                    if (instances[j].getNodeType() != 1) continue;
                    Element treeNodeElement = (Element)instances[j];
                    boolean recurse = true;
                    if (triggerValidationRecurse.length == 1) {
                        recurse = triggerValidationRecurse[0];
                    } else if (triggerValidationRecurse.length > i) {
                        recurse = triggerValidationRecurse[i];
                    }
                    this.validateTreeNode(treeNodeElement, recurse, false, true);
                }
            }
        }
    }

    public void validateTreeNode(Element treeNodeElement, boolean recurse, boolean skipDetailItems, boolean skipTriggeredValidations) {
        Stack<Element> elementStack = new Stack<Element>();
        elementStack.push(treeNodeElement);
        while (!elementStack.isEmpty()) {
            Element currentElement = (Element)elementStack.pop();
            this.validateTreeNodeElementContents(currentElement, skipTriggeredValidations);
            if (!skipDetailItems) {
                this.validateTreeNodeElementDetailItems(currentElement, skipTriggeredValidations);
            }
            if (!recurse) continue;
            List elementList = ModelUtil.getTreeChildElements(currentElement, this.customization);
            for (Element childElement : elementList) {
                elementStack.push(childElement);
            }
        }
    }

    private void validateAtomicDetailItem(Element containingTreeNodeElement, SimpleDetailItem containingSimpleDetailItem, AtomicDetailItem atomicDetailItem) {
        block37: {
            boolean optionalWithinContext;
            Object object;
            this.messageManager.removeDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, atomicDetailItem);
            if (containingSimpleDetailItem != null) {
                boolean simpleDetailItemExists;
                boolean simpleDetailItemIsRequierd = containingSimpleDetailItem.isRequired();
                boolean bl = simpleDetailItemExists = containingSimpleDetailItem.getElement() != null;
                if (!simpleDetailItemIsRequierd && !simpleDetailItemExists) {
                    return;
                }
            }
            String itemName = null;
            Map possibleValues = null;
            boolean isRequired = atomicDetailItem.isRequired();
            Class validationClass = null;
            String value = atomicDetailItem.getValue();
            DetailItemCustomization detailItemCustomization = atomicDetailItem.getDetailItemCustomization();
            boolean skipSyntaxValidation = false;
            if (detailItemCustomization != null) {
                skipSyntaxValidation = detailItemCustomization.isSkipSyntaxValidation();
                itemName = detailItemCustomization.getLabel();
                possibleValues = detailItemCustomization.getPossibleValues();
                if (!isRequired) {
                    isRequired = detailItemCustomization.isRequired();
                }
                validationClass = detailItemCustomization.getValidationClass();
                possibleValues = detailItemCustomization.getPossibleValues();
                Class possibleValuesClass = detailItemCustomization.getPossibleValuesClass();
                if (possibleValuesClass != null) {
                    try {
                        object = possibleValuesClass.newInstance();
                        if (object instanceof ICustomPossibleValuesObject) {
                            ICustomPossibleValuesObject customPossibleValuesObject = (ICustomPossibleValuesObject)object;
                            possibleValues = customPossibleValuesObject.getPosibleValues(value, atomicDetailItem.getNode(), atomicDetailItem.getClosestAncestor(), this.resource);
                        }
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            if (itemName == null) {
                itemName = atomicDetailItem.getName();
            }
            if (possibleValues == null) {
                possibleValues = atomicDetailItem.getPossibleValues();
            }
            if (!(optionalWithinContext = atomicDetailItem.isOptionalWithinContext()) && isRequired && atomicDetailItem.hasEditableValue() && !atomicDetailItem.exists()) {
                ValidationMessage message = new ValidationMessage(Messages.REQUIRED_ITEM_MISSING, 1);
                this.messageManager.addDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, atomicDetailItem, message);
                return;
            }
            if (atomicDetailItem.exists() && atomicDetailItem.hasEditableValue()) {
                if (!skipSyntaxValidation) {
                    XSDAttributeUse xsdAttributeUse;
                    XSDAttributeDeclaration xsdAttributeDeclaration;
                    XSDImpl.XSDAttributeUseAdapter xsdAttributeUseAdapter;
                    CMAttributeDeclaration cmAttributeDeclaration;
                    Notifier target;
                    ValidationMessage possibleValuesErrorMsg = null;
                    if (possibleValues != null && !possibleValues.containsValue(value)) {
                        possibleValuesErrorMsg = new ValidationMessage(Messages.THE_VALUE_IS_NOT_AMONG_THE_POSSIBLE_SELECTIONS, 1);
                    }
                    CMNode cmNode = atomicDetailItem.getCMNode();
                    XSDTypeDefinition xsdTypeDefinition = null;
                    if (cmNode instanceof CMElementDeclaration) {
                        XSDImpl.XSDElementDeclarationAdapter xsdElementDeclarationAdapter;
                        CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)cmNode;
                        if (cmElementDeclaration instanceof XSDImpl.XSDElementDeclarationAdapter && (target = (xsdElementDeclarationAdapter = (XSDImpl.XSDElementDeclarationAdapter)cmElementDeclaration).getTarget()) instanceof XSDElementDeclaration) {
                            XSDElementDeclaration xsdElementDeclaration = (XSDElementDeclaration)target;
                            xsdTypeDefinition = xsdElementDeclaration.getResolvedElementDeclaration().getTypeDefinition();
                        }
                    } else if (cmNode instanceof CMAttributeDeclaration && (cmAttributeDeclaration = (CMAttributeDeclaration)cmNode) instanceof XSDImpl.XSDAttributeUseAdapter && (target = (xsdAttributeUseAdapter = (XSDImpl.XSDAttributeUseAdapter)cmAttributeDeclaration).getTarget()) instanceof XSDAttributeUse && (xsdAttributeDeclaration = (xsdAttributeUse = (XSDAttributeUse)target).getAttributeDeclaration()) != null) {
                        xsdTypeDefinition = xsdAttributeDeclaration.getResolvedAttributeDeclaration().getTypeDefinition();
                    }
                    if (xsdTypeDefinition != null) {
                        this.isCustomListValidation = false;
                        String errorDescription = this.dataTypeValidator.validateXSDTypeDefinition(xsdTypeDefinition, value);
                        if (errorDescription != null) {
                            ValidationMessage message = new ValidationMessage(errorDescription, 1);
                            this.messageManager.addDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, atomicDetailItem, message);
                            return;
                        }
                    } else if (possibleValuesErrorMsg != null) {
                        this.messageManager.addDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, atomicDetailItem, possibleValuesErrorMsg);
                    }
                }
                if (validationClass != null) {
                    try {
                        object = validationClass.newInstance();
                        if (object instanceof ICustomItemValidationObject) {
                            ICustomItemValidationObject customItemValidationObject = (ICustomItemValidationObject)object;
                            ValidationMessage message = customItemValidationObject.validate(value, atomicDetailItem.getNode(), atomicDetailItem.getClosestAncestor(), this.resource);
                            if (message != null) {
                                this.messageManager.addDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, atomicDetailItem, message);
                            }
                            break block37;
                        }
                        if (!(object instanceof ICustomListValidationObject)) break block37;
                        this.isCustomListValidation = true;
                        ICustomListValidationObject customListValidationObject = (ICustomListValidationObject)object;
                        this.messageManager.clearMessages();
                        Map<Node, ValidationMessage[]> messageMap = customListValidationObject.validate(value, atomicDetailItem.getNode(), atomicDetailItem.getClosestAncestor(), this.editorInput);
                        ValidationMessage[] messages = new ValidationMessage[20];
                        if (messageMap != null && !messageMap.isEmpty()) {
                            Iterator<Node> nodes = messageMap.keySet().iterator();
                            do {
                                Node item = nodes.next();
                                messages = messageMap.get(item);
                                if (item instanceof Element) {
                                    for (int k = 0; k < messages.length; ++k) {
                                        this.messageManager.addCustomDetailItemMessage((Element)item, containingSimpleDetailItem, atomicDetailItem, messages[k]);
                                    }
                                } else {
                                    if (!(item instanceof Attr)) continue;
                                    Element owner = ((Attr)item).getOwnerElement();
                                    DetailItem[] detailItems = this.detailsContentProvider.getItems(owner);
                                    int count = detailItems.length;
                                    for (int j = 0; j < count; ++j) {
                                        if (!(detailItems[j] instanceof AtomicDetailItem) || !detailItems[j].getName().equals(((Attr)item).getName())) continue;
                                        atomicDetailItem = (AtomicDetailItem)detailItems[j];
                                    }
                                    for (int k = 0; k < messages.length; ++k) {
                                        this.messageManager.addCustomDetailItemMessage(owner, containingSimpleDetailItem, atomicDetailItem, messages[k]);
                                    }
                                }
                            } while (nodes.hasNext());
                            break block37;
                        }
                        this.messageManager.clearMessages();
                        this.messageManager.removeCustomDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, atomicDetailItem);
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private void validateSimpleDetailItem(Element containingTreeNodeElement, SimpleDetailItem simpleDetailItem, boolean skipTriggeredValidations) {
        DetailItem[] atomicDetailItems = simpleDetailItem.getAtomicDetailItems();
        for (int j = 0; j < atomicDetailItems.length; ++j) {
            this.validateDetailItem(containingTreeNodeElement, simpleDetailItem, atomicDetailItems[j], skipTriggeredValidations);
        }
    }

    private void validateRepeatableAtomicDetailItemSet(Element containingTreeNodeElement, SimpleDetailItem containingSimpleDetailItem, RepeatableAtomicDetailItemSet repeatableAtomicDetailItemSet) {
        block26: {
            this.messageManager.removeDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, repeatableAtomicDetailItemSet);
            if (containingSimpleDetailItem != null) {
                boolean simpleDetailItemExists;
                boolean simpleDetailItemIsRequierd = containingSimpleDetailItem.isRequired();
                boolean bl = simpleDetailItemExists = containingSimpleDetailItem.getElement() != null;
                if (!simpleDetailItemIsRequierd && !simpleDetailItemExists) {
                    return;
                }
            }
            String itemName = null;
            boolean isRequired = repeatableAtomicDetailItemSet.isRequired();
            Class validationClass = null;
            DetailItemCustomization detailItemCustomization = repeatableAtomicDetailItemSet.getDetailItemCustomization();
            if (detailItemCustomization != null) {
                itemName = detailItemCustomization.getLabel();
                if (!isRequired) {
                    isRequired = detailItemCustomization.isRequired();
                }
                validationClass = detailItemCustomization.getValidationClass();
            }
            if (itemName == null) {
                itemName = repeatableAtomicDetailItemSet.getName();
            }
            if (repeatableAtomicDetailItemSet.getItemCount() == 0 && isRequired) {
                ValidationMessage message = new ValidationMessage(Messages.THE_LIST_MUST_CONTAIN_AT_LEAST_ONE_ENTRY, 1);
                this.messageManager.addDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, repeatableAtomicDetailItemSet, message);
            }
            AtomicDetailItem[] items = repeatableAtomicDetailItemSet.getItems();
            for (int i = 0; i < items.length; ++i) {
                this.validateAtomicDetailItem(containingTreeNodeElement, containingSimpleDetailItem, items[i]);
            }
            if (validationClass != null) {
                try {
                    Object object = validationClass.newInstance();
                    if (object instanceof ICustomTableItemValidationObject) {
                        ValidationMessage validationMessage;
                        ICustomTableItemValidationObject customTableItemValidationObject = (ICustomTableItemValidationObject)object;
                        items = repeatableAtomicDetailItemSet.getItems();
                        String[] values = new String[items.length];
                        Node[] itemNodes = new Node[items.length];
                        for (int i = 0; i < items.length; ++i) {
                            AtomicDetailItem currentAtomicDetailItem = items[i];
                            values[i] = currentAtomicDetailItem.getValue();
                            itemNodes[i] = currentAtomicDetailItem.getNode();
                        }
                        Element closestAncestor = null;
                        if (containingSimpleDetailItem != null) {
                            closestAncestor = containingSimpleDetailItem.getElement();
                        }
                        if (closestAncestor == null) {
                            closestAncestor = containingTreeNodeElement;
                        }
                        if ((validationMessage = customTableItemValidationObject.validate(values, itemNodes, closestAncestor, this.resource)) != null) {
                            this.messageManager.addDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, repeatableAtomicDetailItemSet, validationMessage);
                        }
                        break block26;
                    }
                    if (!(object instanceof ICustomListValidationObject)) break block26;
                    this.isCustomListValidation = true;
                    this.messageManager.clearMessages();
                    ICustomListValidationObject customListValidationObject = (ICustomListValidationObject)object;
                    items = repeatableAtomicDetailItemSet.getItems();
                    Element closestAncestor = null;
                    if (containingSimpleDetailItem != null) {
                        closestAncestor = containingSimpleDetailItem.getElement();
                    }
                    if (closestAncestor == null) {
                        closestAncestor = containingTreeNodeElement;
                    }
                    int length = items.length;
                    String[] values = new String[length];
                    Node[] itemNodes = new Node[length];
                    Map<Object, Object> messageMap = new HashMap();
                    for (int i = 0; i < length; ++i) {
                        AtomicDetailItem currentAtomicDetailItem = items[i];
                        values[i] = currentAtomicDetailItem.getValue();
                        itemNodes[i] = currentAtomicDetailItem.getNode();
                        messageMap = customListValidationObject.validate(values[i], itemNodes[i], closestAncestor, this.editorInput);
                        ValidationMessage[] messages = new ValidationMessage[20];
                        if (messageMap != null && !messageMap.isEmpty()) {
                            Iterator<Object> nodes = messageMap.keySet().iterator();
                            do {
                                Node item = (Node)nodes.next();
                                messages = (ValidationMessage[])messageMap.get(item);
                                if (item instanceof Element) {
                                    for (int k = 0; k < messages.length; ++k) {
                                        this.messageManager.addCustomDetailItemMessage((Element)item, containingSimpleDetailItem, repeatableAtomicDetailItemSet, messages[k]);
                                    }
                                } else {
                                    if (!(item instanceof Attr)) continue;
                                    Element owner = ((Attr)item).getOwnerElement();
                                    DetailItem[] detailItems = this.detailsContentProvider.getItems(owner);
                                    int count = detailItems.length;
                                    for (int j = 0; j < count; ++j) {
                                        if (!(detailItems[j] instanceof AtomicDetailItem) || !detailItems[j].getName().equals(((Attr)item).getName())) continue;
                                        repeatableAtomicDetailItemSet = (RepeatableAtomicDetailItemSet)detailItems[j];
                                    }
                                    for (int k = 0; k < messages.length; ++k) {
                                        this.messageManager.addCustomDetailItemMessage(owner, containingSimpleDetailItem, repeatableAtomicDetailItemSet, messages[k]);
                                    }
                                }
                            } while (nodes.hasNext());
                            continue;
                        }
                        this.messageManager.clearMessages();
                        this.messageManager.removeCustomDetailItemMessage(containingTreeNodeElement, containingSimpleDetailItem, repeatableAtomicDetailItemSet);
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void validateTreeNodeElementContents(Element treeNodeElement, boolean skipTriggeredValidations) {
        this.messageManager.removeTreeNodeMessages(treeNodeElement);
        this.messageManager.removeTreeNodeMissingRequiredChildren(treeNodeElement);
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)treeNodeElement.getOwnerDocument());
        CMElementDeclaration cmElementDeclaration = modelQuery.getCMElementDeclaration(treeNodeElement);
        if (cmElementDeclaration != null) {
            Class validationClass;
            ArrayList modelQueryInsertActions = new ArrayList();
            ArrayList<CMNode> availableContent = new ArrayList<CMNode>();
            modelQuery.getInsertActions(treeNodeElement, cmElementDeclaration, -1, 2, 2, modelQueryInsertActions);
            for (ModelQueryAction modelQueryAction : modelQueryInsertActions) {
                CMNode cmNode = modelQueryAction.getCMNode();
                availableContent.add(cmNode);
            }
            for (Object e : availableContent) {
                CMElementDeclaration childCMElementDeclaration;
                if (!(e instanceof CMElementDeclaration) || !ModelUtil.elementMustAppearInTree(this.customization, treeNodeElement, cmElementDeclaration, childCMElementDeclaration = (CMElementDeclaration)e) || ModelUtil.getInstancesOfElement(treeNodeElement, childCMElementDeclaration).length != 0) continue;
                boolean isRequired = false;
                int groupTypesInBetween = ModelUtil.getGroupTypesInBetween(cmElementDeclaration, childCMElementDeclaration);
                if (childCMElementDeclaration.getMinOccur() > 0 && (groupTypesInBetween & 8) == 0 && groupTypesInBetween != 0) {
                    isRequired = true;
                } else if (this.customization != null) {
                    String path;
                    String namespace = ModelUtil.getNamespaceURI((CMNode)childCMElementDeclaration);
                    DetailItemCustomization detailItemCustomization = this.customization.getItemCustomization(namespace, path = ModelUtil.getNodeFullPath(treeNodeElement, (CMNode)childCMElementDeclaration));
                    if (detailItemCustomization == null) {
                        detailItemCustomization = this.customization.getTypeCustomizationConsideringUnions((CMNode)childCMElementDeclaration, path);
                    }
                    if (detailItemCustomization != null) {
                        isRequired = detailItemCustomization.isRequired();
                    }
                }
                if (!isRequired || this.isPresentBySubstitutionGroup(treeNodeElement, cmElementDeclaration, childCMElementDeclaration) || this.isPresentAndRequiredByGroupChoice(treeNodeElement, cmElementDeclaration, childCMElementDeclaration)) continue;
                this.messageManager.addMissingRequiredTreeNode(treeNodeElement, childCMElementDeclaration);
            }
            String string = ModelUtil.getNodeNamespace(treeNodeElement);
            String path = ModelUtil.getElementFullPath(treeNodeElement);
            DetailItemCustomization itemCustomization = null;
            if (this.customization != null) {
                itemCustomization = this.customization.getItemCustomization(string, path);
            }
            if (itemCustomization != null && (validationClass = itemCustomization.getValidationClass()) != null) {
                try {
                    ICustomNodeValidationObject customNodeValidationObject;
                    ValidationMessage[] message;
                    Object object = validationClass.newInstance();
                    if (object instanceof ICustomNodeValidationObject && (message = (customNodeValidationObject = (ICustomNodeValidationObject)object).validate(treeNodeElement, this.resource)) != null) {
                        for (int i = 0; i < message.length; ++i) {
                            this.messageManager.addTreeNodeMessage(treeNodeElement, message[i]);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!skipTriggeredValidations) {
            String namespace = ModelUtil.getNodeNamespace(treeNodeElement);
            String path = ModelUtil.getElementFullPath(treeNodeElement);
            DetailItemCustomization itemCustomization = null;
            if (this.customization != null) {
                itemCustomization = this.customization.getItemCustomization(namespace, path);
            }
            if (itemCustomization != null) {
                String[] stringArray = itemCustomization.getTriggerValidationPath();
                boolean[] triggerValidationRecurse = itemCustomization.isTrigerNodeValidationRecurse();
                for (int i = 0; i < stringArray.length; ++i) {
                    Node[] instances = ModelUtil.getInstances(this.document, stringArray[i]);
                    for (int j = 0; j < instances.length; ++j) {
                        if (instances[j].getNodeType() != 1) continue;
                        Element currrentTreeNodeElement = (Element)instances[j];
                        boolean recurse = true;
                        if (triggerValidationRecurse.length == 1) {
                            recurse = triggerValidationRecurse[0];
                        } else if (triggerValidationRecurse.length > i) {
                            recurse = triggerValidationRecurse[i];
                        }
                        this.validateTreeNode(currrentTreeNodeElement, recurse, false, true);
                    }
                }
            }
        }
    }

    private boolean isPresentBySubstitutionGroup(Element parentElement, CMElementDeclaration cmElementDeclaration, CMElementDeclaration childCMElementDeclaration) {
        String substitutionValue;
        Object substitutionValueObject = childCMElementDeclaration.getProperty("SubstitutionGroupValue");
        if (substitutionValueObject instanceof String && !"".equals(substitutionValue = (String)substitutionValueObject)) {
            CMNamedNodeMap localElements = cmElementDeclaration.getLocalElements();
            for (Object localElementObject : localElements) {
                CMNodeList cmNodeList;
                int length;
                Object substitutionGroupObject;
                CMElementDeclaration localElementCMElementDeclaration;
                if (!(localElementObject instanceof CMElementDeclaration) || !substitutionValue.equals((localElementCMElementDeclaration = (CMElementDeclaration)localElementObject).getNodeName()) || !((substitutionGroupObject = localElementCMElementDeclaration.getProperty("SubstitutionGroup")) instanceof CMNodeList) || (length = (cmNodeList = (CMNodeList)substitutionGroupObject).getLength()) <= 1) continue;
                for (int i = 0; i < length; ++i) {
                    CMElementDeclaration substitutionCMElementDeclaration;
                    CMNode cmNode = cmNodeList.item(i);
                    if (cmNode.getNodeType() != 5 || ModelUtil.getInstancesOfElement(parentElement, substitutionCMElementDeclaration = (CMElementDeclaration)cmNode).length <= 0) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isPresentAndRequiredByGroupChoice(Element parentElement, CMElementDeclaration parentCMElementDeclaration, CMElementDeclaration childCMElementDeclaration) {
        CMGroup containingGroup = ModelUtil.getContainingGroup(parentCMElementDeclaration, childCMElementDeclaration);
        if (containingGroup != null && containingGroup.getOperator() == 2) {
            CMNodeList groupChildNodes = containingGroup.getChildNodes();
            for (int i = 0; i < groupChildNodes.getLength(); ++i) {
                CMElementDeclaration cmElementDeclaration;
                CMNode cmNode = groupChildNodes.item(i);
                if (cmNode.getNodeType() != 5 || ModelUtil.getInstancesOfElement(parentElement, cmElementDeclaration = (CMElementDeclaration)cmNode).length <= 0 && cmElementDeclaration.getMinOccur() != 0) continue;
                return true;
            }
        }
        return false;
    }

    private void validateTreeNodeElementDetailItems(Element treeNodeElement, boolean skipTriggeredValidations) {
        DetailItem[] detailItems = this.detailsContentProvider.getItems(treeNodeElement);
        for (int i = 0; i < detailItems.length; ++i) {
            DetailItem detailItem = detailItems[i];
            this.validateDetailItem(treeNodeElement, detailItem, skipTriggeredValidations);
        }
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public class MessageManager {
        private HashMap messages = new HashMap();

        public void addTreeNodeMessage(Element treeNodeElement, ValidationMessage message) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode == null) {
                validationNode = new TreeNodeValidationNode(treeNodeElement);
                this.messages.put(treeNodeElement, validationNode);
            }
            validationNode.treeNodeMessages.add(message);
            this.updateCountAndCascade(validationNode, message.getMessageType(), 1);
        }

        public void addMissingRequiredTreeNode(Element treeNodeParentElement, CMElementDeclaration cmElementDeclaration) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeParentElement);
            if (validationNode == null) {
                validationNode = new TreeNodeValidationNode(treeNodeParentElement);
                this.messages.put(treeNodeParentElement, validationNode);
            }
            validationNode.missingRequiredChildren.add(cmElementDeclaration);
            if (validationNode.missingRequiredChildren.size() == 1) {
                this.updateCountAndCascade(validationNode, 1, 1);
            }
        }

        public void addDetailItemMessage(Element treeNodeElement, SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem, ValidationMessage message) {
            Object detailItemKey = this.getDetailItemKey(containingSimpleDetailItem, detailItem, false);
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode == null) {
                validationNode = new TreeNodeValidationNode(treeNodeElement);
                this.messages.put(treeNodeElement, validationNode);
            }
            DetailItemValidationNode detailItemValidationNode = new DetailItemValidationNode(detailItemKey, containingSimpleDetailItem, detailItem, message);
            validationNode.detailItemMessages.put(detailItemKey, detailItemValidationNode);
            this.updateCountAndCascade(validationNode, message.getMessageType(), 1);
        }

        public void addCustomDetailItemMessage(Element treeNodeElement, SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem, ValidationMessage message) {
            Object detailItemKey = this.getDetailItemKey(containingSimpleDetailItem, detailItem, false);
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode == null) {
                validationNode = new TreeNodeValidationNode(treeNodeElement);
                this.messages.put(treeNodeElement, validationNode);
            }
            DetailItemValidationNode detailItemValidationNode = new DetailItemValidationNode(detailItemKey, containingSimpleDetailItem, detailItem, message);
            if (ValidationManager.this.isCustomListValidation) {
                validationNode.messageList.add(message);
                detailItemValidationNode.message = new ValidationMessage("", message.getMessageType());
                validationNode.detailItemMessages.put(detailItemKey, detailItemValidationNode);
            } else {
                validationNode.detailItemMessages.put(detailItemKey, detailItemValidationNode);
            }
            this.updateCountAndCascade(validationNode, message.getMessageType(), 1);
        }

        public void removeDetailItemMessage(Element treeNodeElement, SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem) {
            Object detailItemKey = this.getDetailItemKey(containingSimpleDetailItem, detailItem, false);
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                Object detailItemLocalPath;
                DetailItemValidationNode detailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(detailItemKey);
                if (detailItemValidationNode != null) {
                    validationNode.detailItemMessages.remove(detailItemKey);
                    this.updateCountAndCascade(validationNode, detailItemValidationNode.message.getMessageType(), -1);
                }
                if (!detailItemKey.equals(detailItemLocalPath = this.getDetailItemKey(containingSimpleDetailItem, detailItem, true)) && (detailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(detailItemLocalPath)) != null) {
                    validationNode.detailItemMessages.remove(detailItemLocalPath);
                    this.updateCountAndCascade(validationNode, detailItemValidationNode.message.getMessageType(), -1);
                }
            }
        }

        public void removeCustomDetailItemMessage(Element treeNodeElement, SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem) {
            Object detailItemKey = this.getDetailItemKey(containingSimpleDetailItem, detailItem, false);
            TreeNodeValidationNode validationNode = null;
            if (ValidationManager.this.isCustomListValidation) {
                for (Object obj : this.messages.keySet()) {
                    DetailItemValidationNode detailItemValidationNode;
                    if (!(obj instanceof Node)) continue;
                    validationNode = (TreeNodeValidationNode)this.messages.get(obj);
                    int count = -1;
                    if (validationNode != null) {
                        count = validationNode.messageList.size();
                    }
                    if (count <= 0 || (detailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(detailItemKey)) == null) continue;
                    validationNode.messageList.clear();
                    validationNode.detailItemMessages.remove(detailItemKey);
                    if (detailItemValidationNode == null || detailItemValidationNode.message == null) continue;
                    this.updateCountAndCascade(validationNode, detailItemValidationNode.message.getMessageType(), -count);
                }
            } else {
                validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            }
            if (validationNode != null) {
                Object detailItemLocalPath;
                int count = validationNode.messageList.size();
                DetailItemValidationNode detailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(detailItemKey);
                if (detailItemValidationNode != null) {
                    int counter = -1;
                    if (!ValidationManager.this.isCustomListValidation) {
                        if (((DetailItemValidationNode)validationNode.detailItemMessages.get((Object)detailItemKey)).message.getMessage().equals("")) {
                            counter = -count;
                            validationNode.messageList.clear();
                        }
                        validationNode.detailItemMessages.remove(detailItemKey);
                        this.updateCountAndCascade(validationNode, detailItemValidationNode.message.getMessageType(), counter);
                    } else {
                        validationNode.messageList.clear();
                        validationNode.detailItemMessages.remove(detailItemKey);
                        this.updateCountAndCascade(validationNode, detailItemValidationNode.message.getMessageType(), -count);
                    }
                }
                if (!detailItemKey.equals(detailItemLocalPath = this.getDetailItemKey(containingSimpleDetailItem, detailItem, true)) && (detailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(detailItemLocalPath)) != null) {
                    if (!ValidationManager.this.isCustomListValidation) {
                        validationNode.detailItemMessages.remove(detailItemKey);
                        this.updateCountAndCascade(validationNode, detailItemValidationNode.message.getMessageType(), -1);
                    } else {
                        validationNode.messageList.clear();
                        this.updateCountAndCascade(validationNode, detailItemValidationNode.message.getMessageType(), -count);
                    }
                }
            }
        }

        public void removeTreeNodeDetailItemMessages(Element treeNodeElement) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                int detailItemErrorCount = 0;
                int detailItemWarningCount = 0;
                Collection values = validationNode.detailItemMessages.values();
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    ValidationMessage message = ((DetailItemValidationNode)iterator.next()).message;
                    switch (message.getMessageType()) {
                        case 1: {
                            ++detailItemErrorCount;
                            break;
                        }
                        case 0: {
                            ++detailItemWarningCount;
                        }
                    }
                }
                validationNode.detailItemMessages.clear();
                this.updateCountAndCascade(validationNode, 1, -detailItemErrorCount);
                this.updateCountAndCascade(validationNode, 0, -detailItemWarningCount);
            }
        }

        public void removeTreeNodeMissingRequiredChildren(Element treeNodeElement) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null && validationNode.missingRequiredChildren.size() > 0) {
                this.updateCountAndCascade(validationNode, 1, -1);
                validationNode.missingRequiredChildren.clear();
            }
        }

        public void removeTreeNodeMessages(Element treeNodeElement) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                int treeNodeValidationErrorCount = 0;
                int treeNodeValidationWarningCount = 0;
                List values = validationNode.treeNodeMessages;
                for (ValidationMessage message : values) {
                    switch (message.getMessageType()) {
                        case 1: {
                            ++treeNodeValidationErrorCount;
                            break;
                        }
                        case 0: {
                            ++treeNodeValidationWarningCount;
                        }
                    }
                }
                validationNode.treeNodeMessages.clear();
                this.updateCountAndCascade(validationNode, 1, -treeNodeValidationErrorCount);
                this.updateCountAndCascade(validationNode, 0, -treeNodeValidationWarningCount);
            }
        }

        public Element[] getChildTreeNodeElements(Element treeNodeElement, boolean recurse, boolean excludeCascading, boolean withErrors, boolean withWarnings) {
            ArrayList<Element> elements = new ArrayList<Element>();
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                Stack childrenStack = new Stack();
                childrenStack.addAll(validationNode.children);
                while (!childrenStack.isEmpty()) {
                    TreeNodeValidationNode childValidationNode = (TreeNodeValidationNode)childrenStack.pop();
                    if (recurse) {
                        childrenStack.addAll(childValidationNode.children);
                    }
                    if (!(withErrors && childValidationNode.errors > 0 || withWarnings && childValidationNode.warnings > 0) && (excludeCascading || (!withErrors || childValidationNode.cascadingErrors <= 0) && (!withWarnings || childValidationNode.cascadingWarnings <= 0))) continue;
                    elements.add(childValidationNode.element);
                }
            }
            return elements.toArray(new Element[elements.size()]);
        }

        public void removeTreeNode(Element parentTreeNodeElement, Element treeNodeElement) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                Stack childrenStack = new Stack();
                childrenStack.addAll(validationNode.children);
                while (!childrenStack.isEmpty()) {
                    TreeNodeValidationNode childValidationNode = (TreeNodeValidationNode)childrenStack.pop();
                    childrenStack.addAll(childValidationNode.children);
                    this.messages.remove(childValidationNode.element);
                }
                TreeNodeValidationNode parentValidationNode = (TreeNodeValidationNode)this.messages.get(parentTreeNodeElement);
                if (parentValidationNode != null) {
                    parentValidationNode.children.remove(validationNode);
                    this.messages.remove(validationNode.element);
                    parentValidationNode.cascadingErrors -= validationNode.errors + validationNode.cascadingErrors;
                    parentValidationNode.cascadingWarnings -= validationNode.warnings + validationNode.cascadingWarnings;
                    this.cascade(parentValidationNode, 1, -validationNode.errors - validationNode.cascadingErrors);
                    this.cascade(parentValidationNode, 0, -validationNode.warnings - validationNode.cascadingWarnings);
                }
            }
        }

        private void updateCountAndCascade(TreeNodeValidationNode validationNode, int messageType, int increment) {
            if (messageType == 1) {
                validationNode.errors += increment;
            } else if (messageType == 0) {
                validationNode.warnings += increment;
            }
            this.cascade(validationNode, messageType, increment);
        }

        private void cascade(TreeNodeValidationNode validationNode, int messageType, int increment) {
            TreeNodeValidationNode currentValidationNode = validationNode;
            while (this.parentNodeIsElement(currentValidationNode.element)) {
                Node parentNode = currentValidationNode.element.getParentNode();
                Element parentElement = (Element)parentNode;
                TreeNodeValidationNode parentValidationNode = (TreeNodeValidationNode)this.messages.get(parentElement);
                if (parentValidationNode == null) {
                    parentValidationNode = new TreeNodeValidationNode(parentElement);
                    this.messages.put(parentElement, parentValidationNode);
                }
                validationNode.parent = parentValidationNode;
                if (currentValidationNode.missingRequiredChildren.size() == 0 && currentValidationNode.errors == 0 && currentValidationNode.warnings == 0 && currentValidationNode.cascadingErrors == 0 && currentValidationNode.cascadingWarnings == 0) {
                    parentValidationNode.children.remove(currentValidationNode);
                    this.messages.remove(currentValidationNode.element);
                } else if (parentValidationNode.children.indexOf(currentValidationNode) == -1) {
                    parentValidationNode.children.add(currentValidationNode);
                }
                currentValidationNode = parentValidationNode;
                if (messageType == 1) {
                    currentValidationNode.cascadingErrors += increment;
                    continue;
                }
                if (messageType != 0) continue;
                currentValidationNode.cascadingWarnings += increment;
            }
        }

        private boolean parentNodeIsElement(Element element) {
            Node parentNode = element.getParentNode();
            if (parentNode != null) {
                return parentNode.getNodeType() == 1;
            }
            return false;
        }

        public ValidationMessage getDetailItemMessage(Node node, SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(node);
            if (validationNode != null) {
                if (detailItem instanceof AtomicDetailItem) {
                    Object detailItemKey = this.getDetailItemKey(containingSimpleDetailItem, detailItem, false);
                    DetailItemValidationNode detailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(detailItemKey);
                    if (detailItemValidationNode != null) {
                        return detailItemValidationNode.message;
                    }
                } else if (detailItem instanceof RepeatableAtomicDetailItemSet) {
                    String messageText = null;
                    int messageType = 0;
                    Object repeatableDetailItemKey = this.getDetailItemKey(containingSimpleDetailItem, detailItem, false);
                    DetailItemValidationNode repeatableDetailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(repeatableDetailItemKey);
                    if (repeatableDetailItemValidationNode != null) {
                        messageText = repeatableDetailItemValidationNode.message.getMessage();
                        messageType = repeatableDetailItemValidationNode.message.getMessageType();
                    }
                    RepeatableAtomicDetailItemSet repeatableAtomicDetailItemSet = (RepeatableAtomicDetailItemSet)detailItem;
                    AtomicDetailItem[] items = repeatableAtomicDetailItemSet.getItems();
                    for (int i = 0; i < items.length; ++i) {
                        Object detailItemKey = this.getDetailItemKey(containingSimpleDetailItem, items[i], false);
                        DetailItemValidationNode detailItemValidationNode = (DetailItemValidationNode)validationNode.detailItemMessages.get(detailItemKey);
                        if (detailItemValidationNode == null) continue;
                        MessageFormat messageFormat = new MessageFormat(Messages.ITEM);
                        String item = messageFormat.format(new Integer[]{new Integer(i + 1)});
                        if (messageText == null) {
                            messageText = detailItem.getDetailItemCustomization().getCustomization().getHideRepeatableItemNumbers() ? detailItemValidationNode.message.getMessage() : MessageFormat.format(Messages.VALIDATION_MESSAGE, item, detailItemValidationNode.message.getMessage());
                        } else {
                            String message = null;
                            message = detailItem.getDetailItemCustomization().getCustomization().getHideRepeatableItemNumbers() ? detailItemValidationNode.message.getMessage() : MessageFormat.format(Messages.VALIDATION_MESSAGE, item, detailItemValidationNode.message.getMessage());
                            messageText = messageText.concat(System.getProperty("line.separator")).concat(message);
                        }
                        if (messageType == 1) continue;
                        messageType = detailItemValidationNode.message.getMessageType();
                    }
                    if (messageText != null) {
                        ValidationMessage validationMessage = new ValidationMessage(messageText, messageType);
                        return validationMessage;
                    }
                }
            }
            return null;
        }

        public DetailItemValidation[] getTreeNodeDetailItemMessages(Element treeNodeElement, boolean includeErrors, boolean includeWarnings) {
            ArrayList<DetailItemValidation> detailItemValidations = new ArrayList<DetailItemValidation>();
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                Collection values = validationNode.detailItemMessages.values();
                for (DetailItemValidationNode detailItemValidationNode : values) {
                    int messageType = detailItemValidationNode.message.getMessageType();
                    DetailItem detailItem = detailItemValidationNode.detailItem;
                    SimpleDetailItem containingSimpleDetailItem = detailItemValidationNode.containingSimpleDetailItem;
                    ValidationMessage message = detailItemValidationNode.message;
                    DetailItemValidation detailItemValidation = new DetailItemValidation(detailItem, containingSimpleDetailItem, message);
                    if (includeErrors && messageType == 1) {
                        detailItemValidations.add(detailItemValidation);
                    }
                    if (!includeWarnings || messageType != 0) continue;
                    detailItemValidations.add(detailItemValidation);
                }
            }
            return detailItemValidations.toArray(new DetailItemValidation[detailItemValidations.size()]);
        }

        public ValidationMessage[] getTreeNodeMessages(Element treeNodeElement, boolean includeErrors, boolean includeWarnings) {
            ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                List treeNodeMessages = validationNode.treeNodeMessages;
                for (ValidationMessage validationMessage : treeNodeMessages) {
                    if ((!includeErrors || validationMessage.getMessageType() != 1) && (!includeWarnings || validationMessage.getMessageType() != 0)) continue;
                    result.add(validationMessage);
                }
            }
            return result.toArray(new ValidationMessage[result.size()]);
        }

        public ValidationMessage[] getMessages(Element treeNodeElement, boolean includeErrors, boolean includeWarnings) {
            ArrayList<ValidationMessage> result = new ArrayList<ValidationMessage>();
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                List myMessages = validationNode.messageList;
                for (ValidationMessage validationMessage : myMessages) {
                    if ((!includeErrors || validationMessage.getMessageType() != 1) && (!includeWarnings || validationMessage.getMessageType() != 0)) continue;
                    result.add(validationMessage);
                }
            }
            return result.toArray(new ValidationMessage[result.size()]);
        }

        public int getDocumentMessageCount(int messageType) {
            if (ValidationManager.this.document != null) {
                return this.getTreeNodeMessageCount(ValidationManager.this.document.getDocumentElement(), messageType, false);
            }
            return 0;
        }

        public int getTreeNodeMessageCount(Element treeNodeElement, int messageType, boolean excludeCascading) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                if (messageType == 1) {
                    return validationNode.errors + (excludeCascading ? 0 : validationNode.cascadingErrors);
                }
                if (messageType == 0) {
                    return validationNode.warnings + (excludeCascading ? 0 : validationNode.cascadingWarnings);
                }
            }
            return 0;
        }

        public CMElementDeclaration[] getTreeNodeMissingRequiredChildren(Element treeNodeElement) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                return validationNode.missingRequiredChildren.toArray(new CMElementDeclaration[validationNode.missingRequiredChildren.size()]);
            }
            return new CMElementDeclaration[0];
        }

        public void clearMessages() {
            this.messages.clear();
        }

        public boolean treeNodehasErrors(Element treeNodeElement, boolean excludeCascading) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                return validationNode.errors > 0 || !excludeCascading && validationNode.cascadingErrors > 0;
            }
            return false;
        }

        public boolean treeNodehasWarnings(Element treeNodeElement, boolean excludeCascading) {
            TreeNodeValidationNode validationNode = (TreeNodeValidationNode)this.messages.get(treeNodeElement);
            if (validationNode != null) {
                return validationNode.warnings > 0 || !excludeCascading && validationNode.cascadingWarnings > 0;
            }
            return false;
        }

        public Element[] getTreeNodeElements(boolean excludeCascading, boolean withErrors, boolean withWarnings) {
            ArrayList<Element> elements = new ArrayList<Element>();
            Collection values = this.messages.values();
            for (TreeNodeValidationNode validationNode : values) {
                if (!(withErrors && validationNode.errors > 0 || withWarnings && validationNode.warnings > 0) && (excludeCascading || (!withErrors || validationNode.cascadingErrors <= 0) && (!withWarnings || validationNode.cascadingWarnings <= 0))) continue;
                elements.add(validationNode.element);
            }
            return elements.toArray(new Element[elements.size()]);
        }

        private Object getDetailItemKey(SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem, boolean obtainPathOnly) {
            AtomicDetailItem atomicDetailItem;
            Node node;
            if (!obtainPathOnly && detailItem instanceof AtomicDetailItem && (node = (atomicDetailItem = (AtomicDetailItem)detailItem).getNode()) != null) {
                return node;
            }
            return ModelUtil.getDetailItemLocalPath(containingSimpleDetailItem, detailItem);
        }

        public void printMessages() {
            Collection keySet = this.messages.values();
            for (TreeNodeValidationNode validationNode : keySet) {
                HashMap hashMap;
                Element element = validationNode.element;
                System.out.println("");
                System.out.println(element.getNodeName() + " (errors=" + validationNode.errors + " cascading=" + validationNode.cascadingErrors + ")");
                List list = validationNode.treeNodeMessages;
                if (list != null) {
                    for (ValidationMessage message : list) {
                        System.out.print("   " + message.getMessage() + " ");
                        int messageType = message.getMessageType();
                        if (messageType == 1) {
                            System.out.println("(Error)");
                            continue;
                        }
                        if (messageType != 0) continue;
                        System.out.println("(Warning)");
                    }
                }
                if ((hashMap = validationNode.detailItemMessages) == null) continue;
                Set keySet2 = hashMap.keySet();
                for (Object itemPath : keySet2) {
                    DetailItemValidationNode detailItemValidationNode = (DetailItemValidationNode)hashMap.get(itemPath);
                    ValidationMessage message = detailItemValidationNode.message;
                    System.out.print("   " + itemPath + ": " + message.getMessage() + " ");
                    int messageType = message.getMessageType();
                    if (messageType == 1) {
                        System.out.println("(Error)");
                        continue;
                    }
                    if (messageType != 0) continue;
                    System.out.println("(Warning)");
                }
            }
        }

        public void exportMessagesToReporter(IFile file, IValidator validator, IReporter reporter, boolean exportDetailedErrorLocations) {
            MessageExporter messageExporter = new MessageExporter(file, validator, reporter, exportDetailedErrorLocations);
            messageExporter.exportMessagesToReporter();
        }

        private class TreeNodeValidationNode {
            int errors = 0;
            int warnings = 0;
            int cascadingErrors = 0;
            int cascadingWarnings = 0;
            Element element;
            TreeNodeValidationNode parent;
            List children;
            List treeNodeMessages;
            List missingRequiredChildren;
            HashMap detailItemMessages;
            List messageList;

            public TreeNodeValidationNode(Element element) {
                this.element = element;
                this.children = new ArrayList();
                this.treeNodeMessages = new ArrayList();
                this.missingRequiredChildren = new ArrayList();
                this.detailItemMessages = new HashMap();
                this.messageList = new ArrayList();
            }
        }

        private class DetailItemValidationNode {
            Object detailItemElementOrLocalPath;
            SimpleDetailItem containingSimpleDetailItem;
            DetailItem detailItem;
            ValidationMessage message;

            public DetailItemValidationNode(Object detailItemElementOrLocalPath, SimpleDetailItem containingSimpleDetailItem, DetailItem detailItem, ValidationMessage message) {
                this.detailItemElementOrLocalPath = detailItemElementOrLocalPath;
                this.containingSimpleDetailItem = containingSimpleDetailItem;
                this.detailItem = detailItem;
                this.message = message;
            }
        }

        private class MessageExporter {
            private IFile file;
            private IValidator validator;
            private IReporter reporter;
            boolean exportDetailedErrorLocations;

            public MessageExporter(IFile file, IValidator validator, IReporter reporter, boolean exportDetailedErrorLocations) {
                this.file = file;
                this.validator = validator;
                this.reporter = reporter;
                this.exportDetailedErrorLocations = exportDetailedErrorLocations;
            }

            public void exportMessagesToReporter() {
                Collection keySet = MessageManager.this.messages.values();
                for (TreeNodeValidationNode validationNode : keySet) {
                    this.exportTreeNodeMessages(validationNode);
                    this.exportTreeNodeMissingRequiredChildrenMessages(validationNode);
                    this.exportTreeNodeDetailItemMessages(validationNode);
                }
            }

            private void exportTreeNodeMessages(TreeNodeValidationNode treeNodeValidationNode) {
                Element element = treeNodeValidationNode.element;
                String treeNodeLabel = ModelUtil.getTreeNodeLabel(element, ValidationManager.this.customization, ValidationManager.this.resource);
                List treeNodeMessages = treeNodeValidationNode.treeNodeMessages;
                if (treeNodeMessages != null) {
                    for (ValidationMessage message : treeNodeMessages) {
                        int localizedMessageSeverity = 4;
                        int messageType = message.getMessageType();
                        if (messageType == 1) {
                            localizedMessageSeverity = 1;
                        } else if (messageType == 0) {
                            localizedMessageSeverity = 2;
                        }
                        String messageText = MessageFormat.format(Messages.VALIDATION_MESSAGE, treeNodeLabel, message.getMessage());
                        LocalizedMessage localizedMessage = new LocalizedMessage(localizedMessageSeverity, messageText);
                        localizedMessage.setTargetObject((Object)this.file);
                        this.setLocalizedMessageCoordinates(element, localizedMessage);
                        this.reporter.addMessage(this.validator, (IMessage)localizedMessage);
                    }
                }
            }

            private void exportTreeNodeMissingRequiredChildrenMessages(TreeNodeValidationNode treeNodeValidationNode) {
                Element element = treeNodeValidationNode.element;
                String treeNodeLabel = ModelUtil.getTreeNodeLabel(element, ValidationManager.this.customization, ValidationManager.this.resource);
                List missingRequiredChildren = treeNodeValidationNode.missingRequiredChildren;
                if (missingRequiredChildren != null && missingRequiredChildren.size() > 0) {
                    String message = null;
                    for (CMElementDeclaration cmElementDeclaration : missingRequiredChildren) {
                        String label = null;
                        if (ValidationManager.this.customization != null) {
                            DetailItemCustomization itemCustomization = ValidationManager.this.customization.getItemCustomization(ModelUtil.getNamespaceURI((CMNode)cmElementDeclaration), ModelUtil.getNodeFullPath(element, (CMNode)cmElementDeclaration));
                            if (itemCustomization == null) {
                                itemCustomization = ValidationManager.this.customization.getTypeCustomizationConsideringUnions((CMNode)cmElementDeclaration, ModelUtil.getNodeFullPath(element, (CMNode)cmElementDeclaration));
                            }
                            if (itemCustomization != null) {
                                label = itemCustomization.getLabel();
                            }
                        }
                        if (label == null) {
                            label = cmElementDeclaration.getElementName();
                        }
                        if (message == null) {
                            message = label;
                            continue;
                        }
                        message = MessageFormat.format(Messages.ITEM_LIST, message, label);
                    }
                    message = missingRequiredChildren.size() == 1 ? MessageFormat.format(Messages.DETAILED_VALIDATION_MESSAGE, treeNodeLabel, Messages.SINGLE_REQUIRED_ITEM_MISSING, message) : MessageFormat.format(Messages.DETAILED_VALIDATION_MESSAGE, treeNodeLabel, Messages.MULTIPLE_REQUIRED_ITEMS_MISSING, message);
                    LocalizedMessage localizedMessage = new LocalizedMessage(1, message);
                    localizedMessage.setTargetObject((Object)this.file);
                    this.setLocalizedMessageCoordinates(element, localizedMessage);
                    this.reporter.addMessage(this.validator, (IMessage)localizedMessage);
                }
            }

            private void exportTreeNodeDetailItemMessages(TreeNodeValidationNode treeNodeValidationNode) {
                HashMap treeNodeDetailItemMessages = treeNodeValidationNode.detailItemMessages;
                if (treeNodeDetailItemMessages != null) {
                    for (Object detailItemKey : treeNodeDetailItemMessages.keySet()) {
                        DetailItemValidationNode detailItemValidationNode = (DetailItemValidationNode)treeNodeDetailItemMessages.get(detailItemKey);
                        ValidationMessage message = detailItemValidationNode.message;
                        DetailItem detailItem = detailItemValidationNode.detailItem;
                        String label = null;
                        DetailItemCustomization detailItemCustomization = detailItem.getDetailItemCustomization();
                        if (detailItemCustomization != null) {
                            label = detailItemCustomization.getLabel();
                            label = this.stripMnemonicFromLabel(label);
                        }
                        if (label == null) {
                            label = detailItem.getName();
                        }
                        int localizedMessageSeverity = 4;
                        int messageType = message.getMessageType();
                        if (messageType == 1) {
                            localizedMessageSeverity = 1;
                        } else if (messageType == 0) {
                            localizedMessageSeverity = 2;
                        }
                        String messageText = MessageFormat.format(Messages.VALIDATION_MESSAGE, label, message.getMessage());
                        LocalizedMessage localizedMessage = new LocalizedMessage(localizedMessageSeverity, messageText);
                        localizedMessage.setTargetObject((Object)this.file);
                        Node localizationNode = ModelUtil.getDetailItemValueNode(detailItem);
                        if (localizationNode == null) {
                            localizationNode = treeNodeValidationNode.element;
                        }
                        this.setLocalizedMessageCoordinates(localizationNode, localizedMessage);
                        this.reporter.addMessage(this.validator, (IMessage)localizedMessage);
                    }
                }
            }

            private String stripMnemonicFromLabel(String label) {
                String labelBackup = label;
                try {
                    char c;
                    int index = label.indexOf("&");
                    if (index == -1) {
                        return label;
                    }
                    int length = label.length();
                    int indexOfSecondAmp = label.indexOf("&", index + 1);
                    if (indexOfSecondAmp == -1 && length != index + 1 && (c = label.charAt(index + 1)) != ' ') {
                        StringBuffer sb = new StringBuffer(label);
                        sb.delete(index, index + 1);
                        label = sb.toString();
                    }
                }
                catch (Exception e) {
                    return labelBackup;
                }
                return label;
            }

            private void setLocalizedMessageCoordinates(Node node, LocalizedMessage localizedMessage) {
                int offset = ((IDOMNode)node).getStartOffset();
                int line = ((IDOMDocument)ValidationManager.this.document).getStructuredDocument().getLineOfOffset(offset);
                localizedMessage.setLineNo(line + 1);
                if (this.exportDetailedErrorLocations) {
                    if (node.getNodeType() == 3) {
                        localizedMessage.setOffset(offset);
                        localizedMessage.setLength(node.getNodeValue().length());
                    } else if (node.getNodeType() == 1) {
                        localizedMessage.setOffset(offset + 1);
                        localizedMessage.setLength(node.getNodeName().length());
                    } else if (node.getNodeType() == 2) {
                        Attr attr = (Attr)node;
                        Element ownerElement = attr.getOwnerElement();
                        int attributeValueOffset = ((IDOMNode)ownerElement).getStartOffset() + ((IDOMNode)node).getValueRegion().getStart();
                        localizedMessage.setOffset(attributeValueOffset);
                        localizedMessage.setLength(attr.getValue().length() + 2);
                    }
                }
            }
        }
    }
}

