/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.customization;

import com.ibm.xwt.dde.DDEPlugin;
import com.ibm.xwt.dde.customization.ICustomControlObject3;
import com.ibm.xwt.dde.customization.ICustomLabelObject;
import com.ibm.xwt.dde.customization.ICustomMultipleDeletionObject;
import com.ibm.xwt.dde.customization.ICustomPreSelectedTreeObject;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import com.ibm.xwt.dde.internal.controls.AbstractControl;
import com.ibm.xwt.dde.internal.controls.CustomSection;
import com.ibm.xwt.dde.internal.controls.HyperLink;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.customization.TypeCustomization;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class CustomizationManager {
    private static final CustomizationManager customizationManager = new CustomizationManager();
    private static final String EXTENSION_ID = "com.ibm.xwt.dde.customization";
    private static final String ID = "id";
    private static final String CUSTOMIZATION_ELEMENT = "customization";
    private static final String CUSTOMIZATION_ADD_ON_ELEMENT = "customization-add-on";
    private static final String CUSTOMIZATION_FILE = "customizationFile";
    private static final String CUSTOMIZATION_PROPERTIES_FILE = "translations";
    private static final String OVERRIDE_CUSTOMIZATION_NAMESPACE = "overrideCustomizationNamespace";
    private static final String OVERRIDE_CUSTOMIZATION_SCHEMA_LOCATION = "overrideCustomizationSchemaLocation";
    private static final String DEBUG_MODE = "debugMode";
    private static final String POLLING_LOOP_MODE = "com.ibm.xwt.dde.fileMonitor";
    private static final String TRUE = "true";
    private static final String PRIORITY = "priority";
    private HashMap customizationMap;
    private List customizationAddOns;
    private FileMonitor fileMonitor;

    public static CustomizationManager getInstance() {
        return customizationManager;
    }

    private CustomizationManager() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        this.customizationMap = new HashMap();
        this.customizationAddOns = new ArrayList();
        for (int i = 0; i < extensions.length; ++i) {
            boolean debugMode;
            String customizationPropertiesFile;
            String customizationFile;
            String customizationID;
            IConfigurationElement configurationElement = extensions[i];
            if (CUSTOMIZATION_ELEMENT.equals(configurationElement.getName())) {
                customizationID = configurationElement.getAttribute(ID);
                customizationFile = configurationElement.getAttribute(CUSTOMIZATION_FILE);
                customizationPropertiesFile = configurationElement.getAttribute(CUSTOMIZATION_PROPERTIES_FILE);
                String overrideCustomizationNamespace = configurationElement.getAttribute(OVERRIDE_CUSTOMIZATION_NAMESPACE);
                String overrideCustomizationSchemaLocation = configurationElement.getAttribute(OVERRIDE_CUSTOMIZATION_SCHEMA_LOCATION);
                debugMode = false;
                if (TRUE.equals(configurationElement.getAttribute(DEBUG_MODE))) {
                    debugMode = true;
                }
                Customization customization = new Customization(customizationFile, customizationPropertiesFile, configurationElement, customizationID, debugMode);
                if (overrideCustomizationNamespace != null && overrideCustomizationSchemaLocation != null) {
                    customization.setOverrides(overrideCustomizationNamespace, overrideCustomizationSchemaLocation);
                }
                this.customizationMap.put(customizationID, customization);
                continue;
            }
            if (!CUSTOMIZATION_ADD_ON_ELEMENT.equals(configurationElement.getName())) continue;
            customizationID = configurationElement.getAttribute(ID);
            customizationFile = configurationElement.getAttribute(CUSTOMIZATION_FILE);
            customizationPropertiesFile = configurationElement.getAttribute(CUSTOMIZATION_PROPERTIES_FILE);
            String customizationFilePriority = configurationElement.getAttribute(PRIORITY);
            int priority = Integer.parseInt(customizationFilePriority);
            debugMode = false;
            if (TRUE.equals(configurationElement.getAttribute(DEBUG_MODE))) {
                debugMode = true;
            }
            CustomizationAddOn customizationAddOn = new CustomizationAddOn(customizationID, customizationFile, customizationPropertiesFile, debugMode, configurationElement, priority);
            this.customizationAddOns.add(customizationAddOn);
        }
        Collections.sort(this.customizationAddOns, new Comparator(){

            public int compare(Object a, Object b) {
                CustomizationAddOn c1 = (CustomizationAddOn)a;
                CustomizationAddOn c2 = (CustomizationAddOn)b;
                return c1.getPriority() - c2.priority;
            }
        });
        if (System.getProperty(POLLING_LOOP_MODE) != null) {
            this.fileMonitor = new FileMonitor();
            this.fileMonitor.start();
        }
    }

    public synchronized void resetCustomizations() {
        Collection entries = this.customizationMap.values();
        for (Customization customization : entries) {
            if (customization == null || !customization.isParsed()) continue;
            customization.parse();
        }
    }

    public synchronized Customization getCustomization(String customizationID) {
        Customization customization = (Customization)this.customizationMap.get(customizationID);
        if (customization != null) {
            if (!customization.isParsed()) {
                customization.parse();
            }
            return customization;
        }
        return null;
    }

    public class Customization {
        public static final int TREE_SORTING_PREFERENCE_DEFAULT = 0;
        public static final int TREE_SORTING_PREFERENCE_SORTED = 1;
        public static final int TREE_SORTING_PREFERENCE_UNSORTED = 2;
        public static final int TREE_SORTING_PREFERENCE_ALWAYS_SORTED = 3;
        public static final int TREE_SORTING_PREFERENCE_ALWAYS_UNSORTED = 4;
        public static final int DETAILS_SORTING_PREFERENCE_DEFAULT = 0;
        public static final int DETAILS_SORTING_PREFERENCE_SCHEMA = 1;
        private HashMap itemCustomizationMap;
        private HashMap typeCustomizationMap;
        private HashMap itemCustomizationMapForRegularExpresions;
        private String customizationFile;
        private String customizationPropertiesFile;
        private String customizationNamespace;
        private String customizationSchemaLocation;
        private String overrideCustomizationNamespace;
        private String overrideCustomizationSchemaLocation;
        private IConfigurationElement configurationElement;
        private String customizationFilePath;
        private String customizationPropertiesFilePath;
        private String headerLabel;
        private List typeNames = new ArrayList();
        private String overviewSectionTitle;
        private boolean globalDetectSchemaLabel;
        private Class addButtonClass;
        private String globalValidationClass;
        private Class globalIconClass;
        private Class globalDetailSectionTitleClass;
        private Class globalTreeLabelClass;
        private String overviewSectionDescription;
        private String editorTitle;
        private ICustomLabelObject overviewSectionDescriptionObject;
        private Image headerIcon;
        private Action[] headerActions;
        private ICustomLabelObject headerLabelObject;
        private ICustomLabelObject overviewSectionTitleObject;
        private String customizationID;
        private boolean debugMode;
        private boolean isParsed;
        private boolean displayDocumentationAsHoverHelp;
        private String helpContextId;
        private int treeSortingPreference;
        private String treeSortConfirmationMessage;
        private String treeUnsortConfirmationMessage;
        private boolean hideOverviewSection;
        private ICustomMultipleDeletionObject multipleDeletionObject;
        private ICustomPreSelectedTreeObject preSelectedTreeElementObject;
        private int detailsSortingPreference;
        private boolean hideRepeatableItemNumbers;
        private boolean enableSchemaGroups;
        private boolean addChildHelperEnabled;
        private int addChildHelperLimit = 10;
        private Class emptyElementCustomControlClass;
        private ICustomControlObject3 emptyElementCustomControlObject;

        public Customization(String customizationFile, String customizationPropertiesFile, IConfigurationElement configurationElement, String customizationID, boolean debugMode) {
            Status status;
            String errorMessage;
            MessageFormat messageFormat;
            ILog log;
            this.customizationID = customizationID;
            this.customizationFile = customizationFile;
            this.customizationPropertiesFile = customizationPropertiesFile;
            this.configurationElement = configurationElement;
            this.debugMode = debugMode;
            Bundle bundle = Platform.getBundle((String)configurationElement.getContributor().getName());
            try {
                this.customizationFilePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(customizationFile), null)).toExternalForm();
            }
            catch (Exception e) {
                log = DDEPlugin.getDefault().getLog();
                messageFormat = new MessageFormat(Messages.ERROR_LOG_MESSAGE_CUSTOMIZATION_FILE_NOT_FOUND);
                errorMessage = messageFormat.format(new String[]{customizationFile, customizationID, bundle.getSymbolicName()});
                status = new Status(4, DDEPlugin.getDefault().getBundle().getSymbolicName(), errorMessage);
                log.log((IStatus)status);
            }
            if (customizationPropertiesFile != null) {
                try {
                    this.customizationPropertiesFilePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(customizationPropertiesFile), null)).toExternalForm();
                }
                catch (Exception e) {
                    log = DDEPlugin.getDefault().getLog();
                    messageFormat = new MessageFormat(Messages.ERROR_LOG_MESSAGE_CUSTOMIZATION_PROPERTIES_FILE_NOT_FOUND);
                    errorMessage = messageFormat.format(new String[]{customizationPropertiesFile, customizationID, bundle.getSymbolicName()});
                    status = new Status(4, DDEPlugin.getDefault().getBundle().getSymbolicName(), errorMessage);
                    log.log((IStatus)status);
                }
            }
        }

        public List getTypeName() {
            return this.typeNames;
        }

        public String getOverviewSectionDescription() {
            return this.overviewSectionDescription;
        }

        public ICustomLabelObject getOverviewSectionDescriptionObject() {
            return this.overviewSectionDescriptionObject;
        }

        public String getOverviewSectionTitle() {
            return this.overviewSectionTitle;
        }

        public boolean getGlobalDetectSchemaLabel() {
            return this.globalDetectSchemaLabel;
        }

        public Class getAddButtonClass() {
            return this.addButtonClass;
        }

        public Class getIconClass() {
            return this.globalIconClass;
        }

        public Class getTreeLabelClass() {
            return this.globalTreeLabelClass;
        }

        public Class getDetailSectionTitleClass() {
            return this.globalDetailSectionTitleClass;
        }

        public String getGlobalValidationClass() {
            return this.globalValidationClass;
        }

        public boolean getHideRepeatableItemNumbers() {
            return this.hideRepeatableItemNumbers;
        }

        public boolean getEnableSchemaGroups() {
            return this.enableSchemaGroups;
        }

        public ICustomMultipleDeletionObject getCustomMultipleDeletionObject() {
            return this.multipleDeletionObject;
        }

        public ICustomLabelObject getOverviewSectionTitleObject() {
            return this.overviewSectionTitleObject;
        }

        public String getHeaderLabel() {
            return this.headerLabel;
        }

        public Image getHeaderIcon() {
            return this.headerIcon;
        }

        public Action[] getHeaderActions() {
            return this.headerActions;
        }

        public String getCustomizationFilePath() {
            return this.customizationFilePath;
        }

        public String getCustomizationPropertiesFilePath() {
            return this.customizationPropertiesFilePath;
        }

        public ICustomLabelObject getHeaderLabelObject() {
            return this.headerLabelObject;
        }

        public boolean isDisplayDocumentationAsHoverText() {
            return this.displayDocumentationAsHoverHelp;
        }

        public String getHelpContextId() {
            return this.helpContextId;
        }

        public String getCustomizationSchemaLocation() {
            return this.customizationSchemaLocation;
        }

        public ICustomPreSelectedTreeObject getCustomPreSelectedTreeObject() {
            return this.preSelectedTreeElementObject;
        }

        public boolean isAddChildHelperEnabled() {
            return this.addChildHelperEnabled;
        }

        public int getAddChildHelperLimit() {
            return this.addChildHelperLimit;
        }

        public ICustomControlObject3 getEmptyElementCustomControlObject() {
            return this.emptyElementCustomControlObject;
        }

        public DetailItemCustomization getItemCustomization(String namespace, String path) {
            String key;
            DetailItemCustomization itemCustomization;
            if (namespace == null) {
                namespace = "";
            }
            if ((itemCustomization = (DetailItemCustomization)this.itemCustomizationMap.get(key = this.getKey(namespace, path))) != null) {
                return itemCustomization;
            }
            Set keys = this.itemCustomizationMapForRegularExpresions.keySet();
            for (String currentKey : keys) {
                if (currentKey.length() < namespace.length() || !namespace.equals(currentKey.substring(0, namespace.length()))) continue;
                String pathSegment = currentKey.substring(currentKey.indexOf(42) + 1);
                String namespaceSegment = currentKey.substring(0, currentKey.indexOf(42));
                if (pathSegment.length() > path.length() || !pathSegment.equals(path.substring(path.length() - pathSegment.length())) || !namespace.equals(namespaceSegment)) continue;
                return (DetailItemCustomization)this.itemCustomizationMapForRegularExpresions.get(currentKey);
            }
            return null;
        }

        private DetailItemCustomization getTypeCustomizationInUnion(String typeNameStr) {
            TypeCustomization typeCustomization = null;
            if (this.typeNames != null) {
                Iterator i = this.typeNames.iterator();
                while (i.hasNext() && typeCustomization == null) {
                    String typeName = (String)i.next();
                    if (!typeName.equals(typeNameStr) || (typeCustomization = (TypeCustomization)this.typeCustomizationMap.get(typeName)).isUnion()) continue;
                    typeCustomization = null;
                }
            }
            return typeCustomization;
        }

        public DetailItemCustomization getTypeCustomization(String typeNameStr, String path) {
            TypeCustomization typeCustomization = null;
            Object currentNodePath = null;
            Object parentNodePath = null;
            if (this.typeNames != null) {
                Iterator i = this.typeNames.iterator();
                while (i.hasNext() && typeCustomization == null) {
                    String typeName = (String)i.next();
                    if (!typeName.equals(typeNameStr) || !(typeCustomization = (TypeCustomization)this.typeCustomizationMap.get(typeName)).isUnion()) continue;
                    return null;
                }
            }
            if (typeCustomization != null) {
                return typeCustomization;
            }
            return typeCustomization;
        }

        public DetailItemCustomization getTypeCustomizationConsideringUnions(CMNode cmNode, String path) {
            DetailItemCustomization detailItemCustomization = this.getTypeCustomization(ModelUtil.getTypeFromSchema(cmNode), path);
            if (detailItemCustomization == null) {
                List<XSDSimpleTypeDefinition> list = ModelUtil.getMemberTypesFromUnion(cmNode);
                for (XSDSimpleTypeDefinition st : list) {
                    String name = st.getName();
                    String ns = st.getTargetNamespace();
                    if (name != null && ns != null) {
                        detailItemCustomization = this.getTypeCustomizationInUnion(ns + ":" + name);
                    } else if (name != null && ns == null) {
                        detailItemCustomization = this.getTypeCustomizationInUnion(name);
                    }
                    if (detailItemCustomization == null) continue;
                    return detailItemCustomization;
                }
            }
            return detailItemCustomization;
        }

        private String getKey(String namespace, String path) {
            return namespace + path;
        }

        private String getTypeName(String namespace, String name, String path) {
            if (namespace == null || namespace.isEmpty()) {
                if (path == null || path.isEmpty()) {
                    return name;
                }
                return name + "_" + path;
            }
            if (path == null || path.isEmpty()) {
                return namespace + ":" + name;
            }
            return namespace + ":" + name + "_" + path;
        }

        boolean isParsed() {
            return this.isParsed;
        }

        void parse() {
            this.clearCustomizationData();
            this.itemCustomizationMap = new HashMap();
            this.typeCustomizationMap = new HashMap();
            this.itemCustomizationMapForRegularExpresions = new HashMap();
            Bundle bundle = Platform.getBundle((String)this.configurationElement.getContributor().getName());
            URL customizationFileURL = null;
            try {
                customizationFileURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(this.customizationFile), null));
                this.parseFile(this.customizationFile, this.customizationPropertiesFile, customizationFileURL.toExternalForm(), this.getResourceBundle(bundle, this.customizationPropertiesFile), bundle, 0);
                this.isParsed = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Iterator iterator = CustomizationManager.this.customizationAddOns.iterator();
            int i = 1;
            while (iterator.hasNext()) {
                CustomizationAddOn customizationAddOn = (CustomizationAddOn)iterator.next();
                if (!this.customizationID.equals(customizationAddOn.getCustomizationID())) continue;
                bundle = Platform.getBundle((String)customizationAddOn.getConfigurationElement().getContributor().getName());
                try {
                    customizationFileURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(customizationAddOn.getCustomizationFile()), null));
                    this.parseFile(customizationAddOn.getCustomizationFile(), customizationAddOn.getCustomizationPropertiesFile(), customizationFileURL.toExternalForm(), this.getResourceBundle(bundle, customizationAddOn.getCustomizationPropertiesFile()), bundle, i++ * 10000);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private ResourceBundle getResourceBundle(Bundle bundle, String customizationPropertiesFile) {
            if (customizationPropertiesFile == null) {
                return null;
            }
            PropertyResourceBundle resourceBundle = null;
            ArrayList<String> propertiesFilePaths = new ArrayList<String>();
            Path path = new Path(customizationPropertiesFile);
            String propertiesFilePath = path.removeFileExtension().toString();
            String language = Locale.getDefault().getLanguage();
            String country = Locale.getDefault().getCountry();
            String variant = Locale.getDefault().getVariant();
            if (!"".equals(language)) {
                if (!"".equals(country)) {
                    if (!"".equals(variant)) {
                        propertiesFilePaths.add(propertiesFilePath + '_' + language + '_' + country + '_' + variant);
                    }
                    propertiesFilePaths.add(propertiesFilePath + '_' + language + '_' + country);
                }
                propertiesFilePaths.add(propertiesFilePath + '_' + language);
            }
            propertiesFilePaths.add(propertiesFilePath);
            Iterator iterator = propertiesFilePaths.iterator();
            URL customizationFilePropertiesURL = null;
            while (iterator.hasNext() && customizationFilePropertiesURL == null) {
                String currentPathString = (String)iterator.next();
                IPath currentPath = new Path(currentPathString).addFileExtension(path.getFileExtension());
                try {
                    customizationFilePropertiesURL = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)currentPath, null));
                }
                catch (Exception exception) {}
            }
            if (customizationFilePropertiesURL != null) {
                try {
                    InputStream bundleStream = customizationFilePropertiesURL.openStream();
                    resourceBundle = new PropertyResourceBundle(bundleStream);
                    bundleStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return resourceBundle;
        }

        private void clearCustomizationData() {
            this.headerLabel = null;
            this.overviewSectionTitle = null;
            this.globalDetectSchemaLabel = false;
            this.hideRepeatableItemNumbers = false;
            this.enableSchemaGroups = false;
            this.addButtonClass = null;
            this.globalValidationClass = null;
            this.globalIconClass = null;
            this.globalDetailSectionTitleClass = null;
            this.globalTreeLabelClass = null;
            this.overviewSectionDescription = null;
            this.overviewSectionDescriptionObject = null;
            this.headerIcon = null;
            this.headerActions = null;
            this.headerLabelObject = null;
            this.overviewSectionTitleObject = null;
            this.helpContextId = null;
            this.treeSortConfirmationMessage = null;
            this.treeUnsortConfirmationMessage = null;
            this.editorTitle = null;
            this.addChildHelperEnabled = false;
            this.addChildHelperLimit = 10;
        }

        public void setOverrides(String overrideCustomizationNamespace, String overrideCustomizationSchemaLocation) {
            this.overrideCustomizationNamespace = overrideCustomizationNamespace;
            this.overrideCustomizationSchemaLocation = overrideCustomizationSchemaLocation;
        }

        private void parseFile(String customizationFile, String customizationPropertiesFile, String fileName, ResourceBundle resourceBundle, Bundle bundle, int counterInitialization) {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(true);
            try {
                SAXParser saxParser = saxParserFactory.newSAXParser();
                XMLReader xmlReader = saxParser.getXMLReader();
                XMLEventHandler xmlEventHandler = new XMLEventHandler(bundle, resourceBundle, customizationFile, customizationPropertiesFile, counterInitialization);
                xmlReader.setContentHandler(xmlEventHandler);
                xmlReader.parse(fileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                ILog log = DDEPlugin.getDefault().getLog();
                MessageFormat messageFormat = new MessageFormat(Messages.ERROR_LOG_MESSAGE_CUSTOMIZATION_FILE_COULD_NOT_BE_SUCCESSFULLY_PARSED);
                String errorMessage = messageFormat.format(new String[]{customizationFile, fileName, this.customizationID, bundle.getSymbolicName()});
                Status status = new Status(4, DDEPlugin.getDefault().getBundle().getSymbolicName(), errorMessage, (Throwable)e);
                log.log((IStatus)status);
            }
        }

        public String getCustomizationID() {
            return this.customizationID;
        }

        public int getTreeSortingPreference() {
            return this.treeSortingPreference;
        }

        public int getDetailsSortingPreference() {
            return this.detailsSortingPreference;
        }

        public String getTreeSortConfirmationMessage() {
            return this.treeSortConfirmationMessage;
        }

        public String getTreeUnsortConfirmationMessage() {
            return this.treeUnsortConfirmationMessage;
        }

        public String getEditorTitle() {
            return this.editorTitle;
        }

        public boolean isHideOverviewSection() {
            return this.hideOverviewSection;
        }

        static /* synthetic */ Action[] access$3602(Customization x0, Action[] x1) {
            x0.headerActions = x1;
            return x1;
        }

        private class XMLEventHandler
        extends DefaultHandler {
            private static final String NODE = "node";
            private static final String ITEM = "item";
            private static final String nodeType = "nodeType";
            private static final String itemType = "itemType";
            private static final String PATH = "path";
            private static final String LABEL = "label";
            private static final String HIDDEN = "hide";
            private static final String TRUE = "true";
            private static final String FALSE = "false";
            private static final String LINK = "labelLinkClass";
            private static final String BUTTON = "buttonClass";
            private static final String LINES = "textLines";
            private static final String NAME = "name";
            private static final String NAMESPACE = "namespace";
            private static final String ICON = "icon";
            private static final String STYLE = "style";
            private static final String STYLE_DEFAULT = "default";
            private static final String STYLE_TEXT = "text";
            private static final String STYLE_COMBO = "combo";
            private static final String STYLE_LIST = "list";
            private static final String STYLE_CHECKBOX = "checkBox";
            private static final String REQUIRED = "required";
            private static final String POSSIBLE_VALUES = "possibleValues";
            private static final String SUGGESTED_VALUES = "suggestedValues";
            private static final String VALUE = "value";
            private static final String SUGGEST = "suggest";
            private static final String TREE_NODE = "treeNode";
            private static final String BUTTON_LABEL = "buttonLabel";
            private static final String BUTTON_ICON = "buttonIcon";
            private static final String BUTTON_TOOLTIP = "buttonToolTip";
            private static final String LABEL_TOOLTIP = "labelLinkToolTip";
            private static final String TOOLTIP = "toolTip";
            private static final String DELETE_IF_EMPTY = "deleteIfEmpty";
            private static final String CUSTOMIZATION = "customization";
            private static final String CUSTOMIZATION_NAMESPACE = "customizationNamespace";
            private static final String CUSTOMIZATION_SCHEMA_LOCATION = "customizationSchemaLocation";
            private static final String READ_ONLY = "readOnly";
            private static final String TREE_LABEL = "treeLabel";
            private static final String HIDE_LABEL = "hideLabel";
            private static final String DISABLED = "disabled";
            private static final String CREATION_CLASS = "creationClass";
            private static final String SINGLE_OCCURRENCE = "singleOccurrence";
            private static final String TABLE_ICON = "tableIcon";
            private static final String CREATION_LABEL = "creationLabel";
            private static final String HIDE_SECTION_TITLE = "hideSectionTitle";
            private static final String INHERIT_CUSTOMIZATION = "inheritCustomization";
            private static final String TREE_LABEL_DATA = "treeLabelData";
            private static final String HEADER_TEXT = "headerText";
            private static final String FOOTER_TEXT = "footerText";
            private static final String SECTION_HEADER_TEXT = "sectionHeaderText";
            private static final String SECTION_HEADER_TEXT_DATA = "sectionHeaderTextData";
            private static final String SECTION_HEADER_TEXT_CLASS = "sectionHeaderTextClass";
            private static final String DETAIL_SECTION_TITLE = "detailSectionTitle";
            private static final String DETAIL_SECTION_TITLE_DATA = "detailSectionTitleData";
            private static final String CHECK_BOX_TEXT = "checkBoxText";
            private static final String TREE_LABEL_CLASS = "treeLabelClass";
            private static final String DETAIL_SECTION_TITLE_CLASS = "detailSectionTitleClass";
            private static final String DELETION_CLASS = "deletionClass";
            private static final String HEADER_LABEL = "headerLabel";
            private static final String HEADER_ICON = "headerIcon";
            private static final String HEADER_ACTIONS = "headerActions";
            private static final String HEADER_LABEL_DATA = "headerLabelData";
            private static final String HEADER_LABEL_CLASS = "headerLabelClass";
            private static final String OVERVIEW_SECTION_TITLE = "overviewSectionTitle";
            private static final String OVERVIEW_SECTION_TITLE_DATA = "overviewSectionTitleData";
            private static final String OVERVIEW_SECTION_TITLE_CLASS = "overviewSectionTitleClass";
            private static final String OVERVIEW_SECTION_HEADER_TEXT = "overviewSectionHeaderText";
            private static final String OVERVIEW_SECTION_HEADER_TEXT_DATA = "overviewSectionHeaderTextData";
            private static final String OVERVIEW_SECTION_HEADER_TEXT_CLASS = "overviewSectionHeaderTextClass";
            private static final String PRE_SELECTED_TREE_ELEMENT_CLASS = "preSelectedTreeElementClass";
            private static final String CAN_CREATE = "canCreate";
            private static final String CAN_DELETE = "canDelete";
            private static final String CAN_CREATE_CLASS = "canCreateClass";
            private static final String CAN_DELETE_CLASS = "canDeleteClass";
            private static final String POSSIBLE_VALUES_CLASS = "possibleValuesClass";
            private static final String SUGGESTED_VALUES_CLASS = "suggestedValuesClass";
            private static final String DEFAULT_VALUE = "defaultValue";
            private static final String DEFAULT_VALUE_CLASS = "defaultValueClass";
            private static final String VALIDATION_CLASS = "validationClass";
            private static final String CUSTOMCONTROL_CLASS = "customControlClass";
            private static final String DETECTSCHEMALABEL = "detectSchemaLabel";
            private static final String GLOBALDETECTSCHEMALABEL = "globalDetectSchemaLabel";
            private static final String ADDBUTTONCLASS = "addButtonClass";
            private static final String GLOBALVALIDATIONCLASS = "globalValidationClass";
            private static final String HIDE_REPEATABLE_ITEM_NUMBERS = "hideRepeatableItemNumbers";
            private static final String ENABLE_SCHEMA_GROUPS = "enableSchemaGroups";
            private static final String TRIGGER_NODE_VALIDATION_PATH = "triggerNodeValidationPath";
            private static final String TRIGGER_NODE_VALIDATION_RECURSE = "triggerNodeValidationRecurse";
            private static final String CDATA_SECTION_STORAGE = "CDATASectionStorage";
            private static final String HORIZONTAL_SCROLLING = "horizontalScrolling";
            private static final String HELP_CONTEXT_ID = "helpContextId";
            private static final String HOVER_HELP = "hoverHelp";
            private static final String DISPLAY_DOCUMENTATION_AS_HOVER_HELP = "displayDocumentationAsHoverHelp";
            private static final String SKIP_SYNTAX_VALIDATION = "skipSyntaxValidation";
            private static final String SECTION = "section";
            private static final String HYPERLINK = "hyperlink";
            private static final String HYPERLINK_CLASS = "hyperlinkClass";
            private static final String LEFT_INDENTATION = "leftIndentation";
            private static final String TREE_SORTING_PREFERENCE = "treeSortingPreference";
            private static final String DETAILS_SORTING_PREFERENCE = "detailsSortingPreference";
            private static final String SORTED = "sorted";
            private static final String UNSORTED = "unsorted";
            private static final String ALWAYS_SORTED = "alwaysSorted";
            private static final String ALWAYS_UNSORTED = "alwaysUnsorted";
            private static final String DEFAULT = "default";
            private static final String SORT_BY_SCHEMA = "sortBySchemaDefinition";
            private static final String TREE_SORT_CONFIRMATION_MESSAGE = "treeSortConfirmationMessage";
            private static final String TREE_UNSORT_CONFIRMATION_MESSAGE = "treeUnsortConfirmationMessage";
            private static final String CLEAR_OPTIONAL_SECTION_IF_EMPTY = "clearOptionalSectionIfEmpty";
            private static final String SHOW_ITEM_AS_OPTIONAL = "showItemAsOptional";
            private static final String EDITOR_TITLE = "editorTitle";
            private static final String BUTTON_ACCESSIBILITY_NAME = "buttonAccessibilityName";
            private static final String HIDE_OVERVIEW_SECTION = "hideOverviewSection";
            private static final String MULTIPLE_DELETION_CLASS = "multipleDeletionClass";
            private static final String ECHO_CHAR = "echoChar";
            private static final String WRAP_TEXT = "wrapText";
            private static final String DISABLE_CLASS = "disableClass";
            private static final String SHOULD_ITEM_DISABLE_CLASS = "shouldItemDisableClass";
            private static final String IN_UNION = "inUnion";
            private static final String ICON_CLASS = "iconClass";
            private static final String ADD_CHILD_ELEMENT_HELPER = "addChildElementHelper";
            private static final String ADD_CHILD_ELEMENT_HELPER_LIMIT = "addChildElementHelperLimit";
            private static final String EMPTY_ELEMENT_CUSTOM_CONTROL_CLASS = "emptyElementCustomControlClass";
            Bundle bundle;
            ResourceBundle resourceBundle;
            private String customizationFile;
            private String customizationPropertiesFile;
            private Stack currentNodeCustomization;
            private Stack customControlsListStack;
            private Stack customSectionListStack;
            private Stack pathStack = new Stack();
            private Stack typeStack = new Stack();
            private Stack counterStack = new Stack();
            private int counter;
            private int counterInitialization;
            private List missingClassList;
            private List missingTranslationList;
            private List missingImageList;
            private DetailItemCustomization currentDetailItemCustomization;

            public XMLEventHandler(Bundle bundle, ResourceBundle resourceBundle, String customizationFile, String customizationPropertiesFile, int counterInitialization) {
                this.currentNodeCustomization = new Stack();
                this.customControlsListStack = new Stack();
                this.customSectionListStack = new Stack();
                this.counterInitialization = counterInitialization;
                this.counter = counterInitialization;
                this.missingClassList = new ArrayList();
                this.missingTranslationList = new ArrayList();
                this.missingImageList = new ArrayList();
                this.bundle = bundle;
                this.resourceBundle = resourceBundle;
                this.customizationFile = customizationFile;
                this.customizationPropertiesFile = customizationPropertiesFile;
            }

            private String getNodeFullPath() {
                String fullPath = "";
                for (String pathSegment : this.pathStack) {
                    if (pathSegment == null || pathSegment.length() <= 0) continue;
                    if (pathSegment.charAt(0) != '@' && fullPath.length() > 0) {
                        fullPath = fullPath + '/';
                    }
                    fullPath = fullPath + pathSegment;
                }
                return fullPath;
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                List customSectionList;
                super.endElement(uri, localName, qName);
                if (this.pathStack.size() > 0 && (NODE.equals(localName) || ITEM.equals(localName) || nodeType.equals(localName) || itemType.equals(localName))) {
                    this.pathStack.pop();
                    if (NODE.equals(localName)) {
                        this.counter = (Integer)this.counterStack.pop();
                        Object object = this.currentNodeCustomization.pop();
                        List customControlsList = (List)this.customControlsListStack.pop();
                        List customSectionsList = (List)this.customSectionListStack.pop();
                        if (object instanceof DetailItemCustomization) {
                            CustomSection[] customSections;
                            DetailItemCustomization detailItemCustomization = (DetailItemCustomization)object;
                            AbstractControl[] customControls = detailItemCustomization.getCustomControls();
                            if (customControls != null && customControls.length > 0) {
                                List<AbstractControl> list = Arrays.asList(customControls);
                                customControlsList.addAll(0, list);
                            }
                            if ((customSections = detailItemCustomization.getCustomSections()) != null && customSections.length > 0) {
                                List<CustomSection> list = Arrays.asList(customSections);
                                customSectionsList.addAll(0, list);
                            }
                            detailItemCustomization.setControls(customControlsList.toArray(new AbstractControl[customControlsList.size()]));
                            detailItemCustomization.setCustomSections(customSectionsList.toArray(new CustomSection[customSectionsList.size()]));
                        }
                    }
                } else if (SECTION.equals(localName) && (customSectionList = (List)this.customSectionListStack.peek()).size() > 0) {
                    CustomSection customSection = (CustomSection)customSectionList.get(customSectionList.size() - 1);
                    customSection.setEnding(this.counter);
                }
            }

            private String getTranslation(String value) {
                block3: {
                    if (this.resourceBundle != null && value != null && value.length() > 0 && value.charAt(0) == '%') {
                        try {
                            value = this.resourceBundle.getString(value.substring(1));
                        }
                        catch (Exception e) {
                            if (this.missingTranslationList.indexOf(value) != -1) break block3;
                            e.printStackTrace();
                            ILog log = DDEPlugin.getDefault().getLog();
                            MessageFormat messageFormat = new MessageFormat(Messages.ERROR_LOG_MESSAGE_MISSING_TRANSLATION);
                            String errorMessage = messageFormat.format(new String[]{value.substring(1), this.customizationPropertiesFile, Customization.this.customizationFilePath, Customization.this.customizationID, this.bundle.getSymbolicName()});
                            Status status = new Status(4, DDEPlugin.getDefault().getBundle().getSymbolicName(), errorMessage);
                            log.log((IStatus)status);
                            this.missingTranslationList.add(value);
                        }
                    }
                }
                return value;
            }

            private Class getClass(String className) {
                Class clazz;
                block3: {
                    clazz = null;
                    if (className != null) {
                        try {
                            clazz = this.bundle.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                            if (this.missingClassList.indexOf(className) != -1) break block3;
                            e.printStackTrace();
                            ILog log = DDEPlugin.getDefault().getLog();
                            MessageFormat messageFormat = new MessageFormat(Messages.ERROR_LOG_MESSAGE_MISSING_CUSTOMIZATION_CLASS);
                            String errorMessage = messageFormat.format(new String[]{className, this.customizationFile, Customization.this.customizationFilePath, Customization.this.customizationID, this.bundle.getSymbolicName()});
                            Status status = new Status(4, DDEPlugin.getDefault().getBundle().getSymbolicName(), errorMessage, (Throwable)e);
                            log.log((IStatus)status);
                            this.missingClassList.add(className);
                        }
                    }
                }
                return clazz;
            }

            private Image getImage(String imagePath) {
                Image image = null;
                String imageKey = Customization.this.customizationID + '/' + imagePath;
                URL fileURL = FileLocator.find((Bundle)this.bundle, (IPath)new Path(imagePath), null);
                if (fileURL != null) {
                    try {
                        image = DDEPlugin.getDefault().getImageFromRegistry(imageKey);
                        if (image == null) {
                            InputStream inputStream = fileURL.openStream();
                            image = new Image((Device)Display.getDefault(), inputStream);
                            DDEPlugin.getDefault().getImageRegistry().put(imageKey, image);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (this.missingImageList.indexOf(imageKey) == -1) {
                    ILog log = DDEPlugin.getDefault().getLog();
                    MessageFormat messageFormat = new MessageFormat(Messages.ERROR_LOG_MESSAGE_MISSING_IMAGE);
                    String errorMessage = messageFormat.format(new String[]{imagePath, this.customizationFile, Customization.this.customizationFilePath, Customization.this.customizationID, this.bundle.getSymbolicName()});
                    Status status = new Status(4, DDEPlugin.getDefault().getBundle().getSymbolicName(), errorMessage);
                    log.log((IStatus)status);
                    this.missingImageList.add(imagePath);
                }
                return image;
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
                if (NODE.equals(localName) || ITEM.equals(localName) || nodeType.equals(localName) || itemType.equals(localName)) {
                    int i;
                    StringTokenizer stringTokenizer;
                    DetailItemCustomization detailItemCustomization;
                    String name = null;
                    String namespace = null;
                    String path = null;
                    boolean isHidden = false;
                    String label = null;
                    String toolTip = null;
                    String labelToolTip = null;
                    int style = 0;
                    String buttonLabel = null;
                    Image buttonIcon = null;
                    String buttonToolTip = null;
                    Class linkClass = null;
                    Class buttonClass = null;
                    Class creationClass = null;
                    Class treeLabelClass = null;
                    Class detailSectionTitleClass = null;
                    Class deletionClass = null;
                    Class sectionHeaderTextClass = null;
                    Class iconClass = null;
                    Image iconImage = null;
                    int textLines = 1;
                    boolean required = false;
                    boolean readOnly = false;
                    boolean deleteIfEmpty = true;
                    boolean hideLabel = false;
                    boolean disabled = false;
                    boolean singleOccurrence = false;
                    boolean hideSectionTitle = false;
                    String creationLabel = null;
                    Image tableIcon = null;
                    String treeLabel = null;
                    String headerText = null;
                    String footerText = null;
                    String sectionHeaderText = null;
                    String detailSectionTitle = null;
                    String checkBoxText = null;
                    boolean canCreate = true;
                    boolean canDelete = true;
                    Class canCreateClass = null;
                    Class canDeleteClass = null;
                    Class possibleValuesClass = null;
                    Class suggestedValuesClass = null;
                    String defaultValue = null;
                    Class defaultValueClass = null;
                    Class validationClass = null;
                    Class customControlClass = null;
                    boolean detectSchemaLabel = false;
                    String[] triggerValidationPath = new String[]{};
                    boolean[] triggerNodeValidationRecurse = new boolean[]{};
                    boolean cDataSectionStorage = false;
                    boolean horizontalScrolling = false;
                    String helpContextID = null;
                    String hoverHelp = null;
                    boolean skipSyntaxValidation = false;
                    AbstractControl[] customControls = null;
                    CustomSection[] customSections = null;
                    boolean clearOptionalSectionIfEmpty = false;
                    boolean showItemAsOptional = false;
                    String buttonAccessibilityName = null;
                    char echoChar = '\u0000';
                    boolean wrapText = false;
                    Class disableClass = null;
                    Class shouldItemDisableClass = null;
                    int detailsSortingOption = -1;
                    boolean isUnion = false;
                    String temp = null;
                    name = attrs.getValue(NAME);
                    namespace = attrs.getValue(NAMESPACE);
                    if (namespace == null) {
                        namespace = Customization.this.overrideCustomizationNamespace == null ? Customization.this.customizationNamespace : Customization.this.overrideCustomizationNamespace;
                    }
                    if (name != null && namespace != null) {
                        String typeName = Customization.this.getTypeName(namespace, name, path);
                        this.typeStack.add(typeName);
                    }
                    if ((temp = attrs.getValue(PATH)) != null && temp.length() > 0) {
                        this.pathStack.push(temp);
                    }
                    path = this.getNodeFullPath();
                    if ("true".equals(attrs.getValue(INHERIT_CUSTOMIZATION)) && (detailItemCustomization = Customization.this.getItemCustomization(namespace, path)) != null) {
                        isHidden = detailItemCustomization.isHidden();
                        label = detailItemCustomization.getLabel();
                        toolTip = detailItemCustomization.getToolTip();
                        labelToolTip = detailItemCustomization.getLabelLinkToolTip();
                        style = detailItemCustomization.getStyle();
                        buttonLabel = detailItemCustomization.getButtonLabel();
                        buttonIcon = detailItemCustomization.getButtonIcon();
                        buttonToolTip = detailItemCustomization.getButtonToolTip();
                        linkClass = detailItemCustomization.getLinkClass();
                        buttonClass = detailItemCustomization.getButtonClass();
                        creationClass = detailItemCustomization.getCreationClass();
                        iconImage = detailItemCustomization.getIcon();
                        textLines = detailItemCustomization.getLines();
                        required = detailItemCustomization.isRequired();
                        readOnly = detailItemCustomization.isReadOnly();
                        deleteIfEmpty = detailItemCustomization.isDeleteIfEmpty();
                        hideLabel = detailItemCustomization.isHideLabel();
                        disabled = detailItemCustomization.isDisabled();
                        singleOccurrence = detailItemCustomization.isSingleOccurrence();
                        hideSectionTitle = detailItemCustomization.isHideSectionTitle();
                        creationLabel = detailItemCustomization.getCreationLabel();
                        tableIcon = detailItemCustomization.getTableIcon();
                        treeLabel = detailItemCustomization.getTreeLabel();
                        headerText = detailItemCustomization.getHeaderText();
                        footerText = detailItemCustomization.getFooterText();
                        sectionHeaderText = detailItemCustomization.getSectionHeaderText();
                        sectionHeaderTextClass = detailItemCustomization.getSectionHeaderTextClass();
                        detailSectionTitle = detailItemCustomization.getDetailSectionTitle();
                        checkBoxText = detailItemCustomization.getCheckBoxText();
                        treeLabelClass = detailItemCustomization.getTreeLabelClass();
                        detailSectionTitleClass = detailItemCustomization.getDetailSectionTitleClass();
                        iconClass = detailItemCustomization.getIconClass();
                        deletionClass = detailItemCustomization.getDeletionClass();
                        canCreate = detailItemCustomization.isCanCreate();
                        canDelete = detailItemCustomization.isCanDelete();
                        canCreateClass = detailItemCustomization.getCanCreateClass();
                        canDeleteClass = detailItemCustomization.getCanDeleteClass();
                        possibleValuesClass = detailItemCustomization.getPossibleValuesClass();
                        suggestedValuesClass = detailItemCustomization.getSuggestedValuesClass();
                        validationClass = detailItemCustomization.getValidationClass();
                        customControlClass = detailItemCustomization.getCustomControlClass();
                        detectSchemaLabel = detailItemCustomization.getDetectSchemaLabel();
                        triggerValidationPath = detailItemCustomization.getTriggerValidationPath();
                        triggerNodeValidationRecurse = detailItemCustomization.isTrigerNodeValidationRecurse();
                        cDataSectionStorage = detailItemCustomization.isCDATASectionStorage();
                        horizontalScrolling = detailItemCustomization.isHorizontalScrolling();
                        helpContextID = detailItemCustomization.getHelpContextId();
                        hoverHelp = detailItemCustomization.getHoverHelp();
                        skipSyntaxValidation = detailItemCustomization.isSkipSyntaxValidation();
                        customControls = detailItemCustomization.getCustomControls();
                        customSections = detailItemCustomization.getCustomSections();
                        clearOptionalSectionIfEmpty = detailItemCustomization.isClearOptionalSectionIfEmpty();
                        showItemAsOptional = detailItemCustomization.isShowItemAsOptional();
                        buttonAccessibilityName = detailItemCustomization.getButtonAccessibilityName();
                        echoChar = detailItemCustomization.getEchoChar();
                        wrapText = detailItemCustomization.isWrapText();
                        disableClass = detailItemCustomization.getDisableClass();
                        shouldItemDisableClass = detailItemCustomization.getShouldItemDisableClass();
                        detailsSortingOption = detailItemCustomization.getDetailsSortingOption();
                    }
                    if ("true".equals(temp = attrs.getValue(HIDDEN))) {
                        isHidden = true;
                    } else if (FALSE.equals(temp)) {
                        isHidden = false;
                    }
                    temp = attrs.getValue(LABEL);
                    if (temp != null) {
                        label = this.getTranslation(temp);
                    }
                    if (attrs.getValue(STYLE) != null) {
                        temp = attrs.getValue(STYLE);
                        if ("default".equals(temp)) {
                            style = 0;
                        } else if (STYLE_TEXT.equals(temp)) {
                            style = 1;
                        } else if (STYLE_COMBO.equals(temp)) {
                            style = 2;
                        } else if (STYLE_LIST.equals(temp)) {
                            style = 3;
                        } else if (STYLE_CHECKBOX.equals(temp)) {
                            style = 4;
                        } else if (TREE_NODE.equals(temp)) {
                            style = 5;
                        }
                    }
                    if ("true".equals(temp = attrs.getValue(SINGLE_OCCURRENCE))) {
                        singleOccurrence = true;
                    } else if (FALSE.equals(temp)) {
                        singleOccurrence = false;
                    }
                    temp = attrs.getValue(CUSTOMCONTROL_CLASS);
                    if (temp != null) {
                        customControlClass = this.getClass(temp);
                    }
                    detectSchemaLabel = "true".equals(temp = attrs.getValue(DETECTSCHEMALABEL));
                    temp = attrs.getValue(VALIDATION_CLASS);
                    if (temp != null) {
                        validationClass = this.getClass(temp);
                    }
                    if (validationClass == null && Customization.this.globalValidationClass != null) {
                        validationClass = this.getClass(Customization.this.globalValidationClass);
                    }
                    if ((temp = attrs.getValue(TRIGGER_NODE_VALIDATION_PATH)) != null) {
                        stringTokenizer = new StringTokenizer(temp, ",");
                        triggerValidationPath = new String[stringTokenizer.countTokens()];
                        i = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            triggerValidationPath[i++] = stringTokenizer.nextToken().trim();
                        }
                    }
                    if ((temp = attrs.getValue(TRIGGER_NODE_VALIDATION_RECURSE)) != null) {
                        stringTokenizer = new StringTokenizer(temp, ",");
                        triggerNodeValidationRecurse = new boolean[stringTokenizer.countTokens()];
                        i = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            triggerNodeValidationRecurse[i++] = "true".equals(stringTokenizer.nextToken().trim());
                        }
                    }
                    if ((temp = attrs.getValue(HELP_CONTEXT_ID)) != null) {
                        helpContextID = temp;
                    }
                    if (ITEM.equals(localName) || itemType.equals(localName)) {
                        String echoCharString;
                        temp = attrs.getValue(TOOLTIP);
                        if (temp != null) {
                            toolTip = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(HEADER_TEXT)) != null) {
                            headerText = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(FOOTER_TEXT)) != null) {
                            footerText = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(CHECK_BOX_TEXT)) != null) {
                            checkBoxText = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(LABEL_TOOLTIP)) != null) {
                            labelToolTip = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(BUTTON_LABEL)) != null) {
                            buttonLabel = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(BUTTON_ICON)) != null) {
                            buttonIcon = this.getImage(temp);
                        }
                        if ((temp = attrs.getValue(BUTTON_ACCESSIBILITY_NAME)) != null) {
                            buttonAccessibilityName = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(BUTTON_TOOLTIP)) != null) {
                            buttonToolTip = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(DEFAULT_VALUE)) != null) {
                            defaultValue = this.getTranslation(temp);
                        }
                        if ("true".equals(temp = attrs.getValue(CDATA_SECTION_STORAGE))) {
                            cDataSectionStorage = true;
                        }
                        if ("true".equals(temp = attrs.getValue(HORIZONTAL_SCROLLING))) {
                            horizontalScrolling = true;
                        }
                        if ("true".equals(temp = attrs.getValue(WRAP_TEXT))) {
                            wrapText = true;
                        }
                        if ((temp = attrs.getValue(POSSIBLE_VALUES_CLASS)) != null) {
                            possibleValuesClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(SUGGESTED_VALUES_CLASS)) != null) {
                            suggestedValuesClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(DEFAULT_VALUE_CLASS)) != null) {
                            defaultValueClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(LINK)) != null) {
                            linkClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(BUTTON)) != null) {
                            buttonClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(LINES)) != null) {
                            textLines = Integer.valueOf(temp);
                        }
                        if ((temp = attrs.getValue(TABLE_ICON)) != null) {
                            tableIcon = this.getImage(temp);
                        }
                        if ("true".equals(temp = attrs.getValue(REQUIRED))) {
                            required = true;
                        } else if (FALSE.equals(temp)) {
                            required = false;
                        }
                        temp = attrs.getValue(READ_ONLY);
                        if ("true".equals(temp)) {
                            readOnly = true;
                        } else if (FALSE.equals(temp)) {
                            readOnly = false;
                        }
                        temp = attrs.getValue(DELETE_IF_EMPTY);
                        if ("true".equals(temp)) {
                            deleteIfEmpty = true;
                        } else if (FALSE.equals(temp)) {
                            deleteIfEmpty = false;
                        }
                        temp = attrs.getValue(HIDE_LABEL);
                        if ("true".equals(temp)) {
                            hideLabel = true;
                        } else if (FALSE.equals(temp)) {
                            hideLabel = false;
                        }
                        temp = attrs.getValue(DISABLED);
                        if ("true".equals(temp)) {
                            disabled = true;
                        } else if (FALSE.equals(temp)) {
                            disabled = false;
                        }
                        temp = attrs.getValue(HOVER_HELP);
                        if (temp != null) {
                            hoverHelp = this.getTranslation(temp);
                        }
                        if ((temp = attrs.getValue(SKIP_SYNTAX_VALIDATION)) != null && "true".equals(temp)) {
                            skipSyntaxValidation = true;
                        }
                        if ((temp = attrs.getValue(CLEAR_OPTIONAL_SECTION_IF_EMPTY)) != null && "true".equals(temp)) {
                            clearOptionalSectionIfEmpty = true;
                        }
                        if ((temp = attrs.getValue(SHOW_ITEM_AS_OPTIONAL)) != null && "true".equals(temp)) {
                            showItemAsOptional = true;
                        }
                        if ((temp = attrs.getValue(ECHO_CHAR)) != null && (echoCharString = this.getTranslation(temp)) != null && echoCharString.length() == 1) {
                            echoChar = echoCharString.charAt(0);
                        }
                        if ((temp = attrs.getValue(DISABLE_CLASS)) != null) {
                            disableClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(SHOULD_ITEM_DISABLE_CLASS)) != null) {
                            shouldItemDisableClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(IN_UNION)) != null && "true".equals(temp)) {
                            isUnion = true;
                        }
                    } else {
                        MessageFormat messageFormat;
                        int i2;
                        temp = attrs.getValue(CAN_CREATE);
                        if (FALSE.equals(temp)) {
                            canCreate = false;
                        }
                        if (FALSE.equals(temp = attrs.getValue(CAN_DELETE))) {
                            canDelete = false;
                        }
                        if ((temp = attrs.getValue(CAN_CREATE_CLASS)) != null) {
                            canCreateClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(CAN_DELETE_CLASS)) != null) {
                            canDeleteClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(TREE_LABEL)) != null) {
                            treeLabel = this.getTranslation(temp);
                            temp = attrs.getValue(TREE_LABEL_DATA);
                            if (temp != null) {
                                stringTokenizer = new StringTokenizer(temp, ",");
                                String[] paths = new String[stringTokenizer.countTokens()];
                                i2 = 0;
                                while (stringTokenizer.hasMoreTokens()) {
                                    paths[i2++] = "$" + stringTokenizer.nextToken().trim() + "$";
                                }
                                messageFormat = new MessageFormat(treeLabel);
                                treeLabel = messageFormat.format(paths);
                            }
                        }
                        if ((temp = attrs.getValue(DETAIL_SECTION_TITLE)) != null) {
                            detailSectionTitle = this.getTranslation(temp);
                            temp = attrs.getValue(DETAIL_SECTION_TITLE_DATA);
                            if (temp != null) {
                                stringTokenizer = new StringTokenizer(temp, ",");
                                String[] paths = new String[stringTokenizer.countTokens()];
                                i2 = 0;
                                while (stringTokenizer.hasMoreTokens()) {
                                    paths[i2++] = "$" + stringTokenizer.nextToken().trim() + "$";
                                }
                                messageFormat = new MessageFormat(detailSectionTitle);
                                detailSectionTitle = messageFormat.format(paths);
                            }
                        }
                        if ((temp = attrs.getValue(CREATION_LABEL)) != null) {
                            creationLabel = this.getTranslation(temp);
                        }
                        if ("true".equals(temp = attrs.getValue(HIDE_SECTION_TITLE))) {
                            hideSectionTitle = true;
                        } else if (FALSE.equals(temp)) {
                            hideSectionTitle = false;
                        }
                        temp = attrs.getValue(SECTION_HEADER_TEXT_CLASS);
                        if (temp != null) {
                            sectionHeaderTextClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(SECTION_HEADER_TEXT)) != null) {
                            sectionHeaderText = this.getTranslation(temp);
                            temp = attrs.getValue(SECTION_HEADER_TEXT_DATA);
                            if (temp != null) {
                                stringTokenizer = new StringTokenizer(temp, ",");
                                String[] paths = new String[stringTokenizer.countTokens()];
                                i2 = 0;
                                while (stringTokenizer.hasMoreTokens()) {
                                    paths[i2++] = "$" + stringTokenizer.nextToken().trim() + "$";
                                }
                                messageFormat = new MessageFormat(treeLabel);
                                sectionHeaderText = messageFormat.format(paths);
                            }
                        }
                        if ((temp = attrs.getValue(CREATION_CLASS)) != null) {
                            creationClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(DELETION_CLASS)) != null) {
                            deletionClass = this.getClass(temp);
                        }
                        if ((temp = attrs.getValue(TREE_LABEL_CLASS)) != null) {
                            treeLabelClass = this.getClass(temp);
                        }
                        if (treeLabelClass == null && Customization.this.globalTreeLabelClass != null) {
                            treeLabelClass = Customization.this.globalTreeLabelClass;
                        }
                        if ((temp = attrs.getValue(DETAIL_SECTION_TITLE_CLASS)) != null) {
                            detailSectionTitleClass = this.getClass(temp);
                        }
                        if (detailSectionTitleClass == null && Customization.this.globalDetailSectionTitleClass != null) {
                            detailSectionTitleClass = Customization.this.globalDetailSectionTitleClass;
                        }
                        if ((temp = attrs.getValue(ICON_CLASS)) != null) {
                            iconClass = this.getClass(temp);
                        }
                        if (iconClass == null && Customization.this.globalIconClass != null) {
                            iconClass = Customization.this.globalIconClass;
                        }
                        if ((temp = attrs.getValue(ICON)) != null) {
                            iconImage = this.getImage(temp);
                        }
                        if ((temp = attrs.getValue(DETAILS_SORTING_PREFERENCE)) != null) {
                            detailsSortingOption = temp.equals(SORT_BY_SCHEMA) ? 1 : 0;
                        }
                    }
                    DetailItemCustomization itemCustomization = null;
                    TypeCustomization typeCustomization = null;
                    String typeName = null;
                    if (name != null && namespace != null) {
                        typeName = Customization.this.getTypeName(namespace, name, path);
                    }
                    if (!"*".equals(path) && typeName == null) {
                        itemCustomization = new DetailItemCustomization(label, isHidden, buttonLabel, toolTip, labelToolTip, buttonToolTip, buttonClass, linkClass, textLines, iconImage, style, required, readOnly, deleteIfEmpty, treeLabel, hideLabel, disabled, singleOccurrence, creationClass, null, creationLabel, tableIcon, hideSectionTitle, headerText, footerText, sectionHeaderText, sectionHeaderTextClass, detailSectionTitle, checkBoxText, treeLabelClass, detailSectionTitleClass, deletionClass, canCreate, canDelete, canCreateClass, canDeleteClass, possibleValuesClass, suggestedValuesClass, defaultValue, defaultValueClass, validationClass, customControlClass, detectSchemaLabel, triggerValidationPath, triggerNodeValidationRecurse, cDataSectionStorage, horizontalScrolling, helpContextID, hoverHelp, Customization.this, skipSyntaxValidation, customControls, customSections, clearOptionalSectionIfEmpty, showItemAsOptional, buttonAccessibilityName, echoChar, wrapText, disableClass, shouldItemDisableClass, detailsSortingOption, iconClass, buttonIcon);
                        if (path.indexOf(42) != -1) {
                            boolean storeItemOrder = false;
                            int index = path.indexOf(47);
                            if (index != -1) {
                                boolean bl = storeItemOrder = path.substring(index + 1).indexOf(47) != -1 || path.substring(index + 1).indexOf(64) != -1;
                            }
                            if (storeItemOrder) {
                                itemCustomization.setOrder(this.counter++);
                            } else {
                                itemCustomization.setOrder(-1);
                            }
                            if (itemCustomization != null) {
                                Customization.this.itemCustomizationMapForRegularExpresions.put(Customization.this.getKey(namespace, path), itemCustomization);
                            }
                        } else {
                            itemCustomization.setOrder(this.counter++);
                            Customization.this.itemCustomizationMap.put(Customization.this.getKey(namespace, path), itemCustomization);
                        }
                    }
                    if ((nodeType.equals(localName) || itemType.equals(localName)) && typeName != null) {
                        int i3 = typeName.indexOf("_");
                        String tempName = typeName;
                        if (i3 != -1) {
                            tempName = typeName.substring(0, typeName.indexOf("_"));
                        }
                        typeCustomization = new TypeCustomization(tempName, label, isHidden, buttonLabel, toolTip, labelToolTip, buttonToolTip, buttonClass, linkClass, textLines, iconImage, style, required, readOnly, deleteIfEmpty, treeLabel, hideLabel, disabled, singleOccurrence, creationClass, null, creationLabel, tableIcon, hideSectionTitle, headerText, footerText, sectionHeaderText, sectionHeaderTextClass, detailSectionTitle, checkBoxText, treeLabelClass, detailSectionTitleClass, deletionClass, canCreate, canDelete, canCreateClass, canDeleteClass, possibleValuesClass, suggestedValuesClass, defaultValue, defaultValueClass, validationClass, customControlClass, detectSchemaLabel, triggerValidationPath, triggerNodeValidationRecurse, cDataSectionStorage, horizontalScrolling, helpContextID, hoverHelp, Customization.this, skipSyntaxValidation, customControls, customSections, clearOptionalSectionIfEmpty, showItemAsOptional, buttonAccessibilityName, echoChar, wrapText, disableClass, shouldItemDisableClass, detailsSortingOption, isUnion, iconClass, buttonIcon);
                        Customization.this.typeNames.add(typeName);
                        Customization.this.typeCustomizationMap.put(typeName, typeCustomization);
                    }
                    if (NODE.equals(localName)) {
                        this.customControlsListStack.push(new ArrayList());
                        this.customSectionListStack.push(new ArrayList());
                        this.currentNodeCustomization.push(itemCustomization);
                        this.counterStack.push(new Integer(this.counter));
                        this.counter = this.counterInitialization;
                    }
                    this.currentDetailItemCustomization = itemCustomization != null ? itemCustomization : typeCustomization;
                } else if (HYPERLINK.equals(localName)) {
                    String temp = null;
                    String label = null;
                    String tooltip = null;
                    Image icon = null;
                    Class hyperlinkClass = null;
                    boolean leftIndentation = false;
                    temp = attrs.getValue(LABEL);
                    if (temp != null) {
                        label = this.getTranslation(temp);
                    }
                    if ((temp = attrs.getValue(TOOLTIP)) != null) {
                        tooltip = this.getTranslation(temp);
                    }
                    if ((temp = attrs.getValue(HYPERLINK_CLASS)) != null) {
                        hyperlinkClass = this.getClass(temp);
                    }
                    if ((temp = attrs.getValue(ICON)) != null) {
                        icon = this.getImage(temp);
                    }
                    if ("true".equals(attrs.getValue(LEFT_INDENTATION))) {
                        leftIndentation = true;
                    }
                    HyperLink hyperlink = new HyperLink(this.counter++, label, icon, tooltip, hyperlinkClass, leftIndentation);
                    List customControlsList = (List)this.customControlsListStack.peek();
                    customControlsList.add(hyperlink);
                } else if (SECTION.equals(localName)) {
                    String label = this.getTranslation(attrs.getValue(LABEL));
                    String headerText = this.getTranslation(attrs.getValue(HEADER_TEXT));
                    CustomSection customSection = new CustomSection(this.counter, label, headerText);
                    List customSectionList = (List)this.customSectionListStack.peek();
                    customSectionList.add(customSection);
                } else if (POSSIBLE_VALUES.equals(localName)) {
                    if (this.currentDetailItemCustomization != null) {
                        this.currentDetailItemCustomization.setPossibleValues(new LinkedHashMap());
                    }
                } else if (SUGGESTED_VALUES.equals(localName)) {
                    if (this.currentDetailItemCustomization != null) {
                        this.currentDetailItemCustomization.setSuggestedValues(new LinkedList());
                    }
                } else if (VALUE.equals(localName)) {
                    if (this.currentDetailItemCustomization != null) {
                        Map possibleValues = this.currentDetailItemCustomization.getPossibleValues();
                        String value = this.getTranslation(attrs.getValue(VALUE));
                        String label = this.getTranslation(attrs.getValue(LABEL));
                        if (value != null && label != null) {
                            possibleValues.put(label, value);
                        }
                    }
                } else if (SUGGEST.equals(localName)) {
                    if (this.currentDetailItemCustomization != null) {
                        List suggestedValues = this.currentDetailItemCustomization.getSuggestedValues();
                        String suggest = this.getTranslation(attrs.getValue(VALUE));
                        if (suggest != null) {
                            suggestedValues.add(suggest);
                        }
                    }
                } else if ("customization".equals(localName)) {
                    Class emptyElementCustomControlClass;
                    String iconPath;
                    URL fileURL;
                    Class preSelectedTreeElementClass;
                    Class multipleDeletionClass;
                    Object object;
                    Class headerLabelClass;
                    MessageFormat messageFormat;
                    int i;
                    String[] paths;
                    StringTokenizer stringTokenizer;
                    String globalIconClassName;
                    String globalTreeLabelClassName;
                    if (Customization.this.overrideCustomizationNamespace != null && Customization.this.overrideCustomizationSchemaLocation != null) {
                        Customization.this.customizationNamespace = Customization.this.overrideCustomizationNamespace;
                        Customization.this.customizationSchemaLocation = Customization.this.overrideCustomizationSchemaLocation;
                    } else {
                        Customization.this.customizationNamespace = attrs.getValue(CUSTOMIZATION_NAMESPACE);
                        Customization.this.customizationSchemaLocation = attrs.getValue(CUSTOMIZATION_SCHEMA_LOCATION);
                    }
                    Customization.this.helpContextId = attrs.getValue(HELP_CONTEXT_ID);
                    Customization.this.overviewSectionTitle = this.getTranslation(attrs.getValue(OVERVIEW_SECTION_TITLE));
                    String flag = attrs.getValue(GLOBALDETECTSCHEMALABEL);
                    if ("true".equals(flag)) {
                        Customization.this.globalDetectSchemaLabel = true;
                    } else {
                        Customization.this.globalDetectSchemaLabel = false;
                    }
                    Customization.this.globalValidationClass = attrs.getValue(GLOBALVALIDATIONCLASS);
                    if ("true".equals(attrs.getValue(HIDE_REPEATABLE_ITEM_NUMBERS))) {
                        Customization.this.hideRepeatableItemNumbers = true;
                    } else {
                        Customization.this.hideRepeatableItemNumbers = false;
                    }
                    if ("true".equals(attrs.getValue(ENABLE_SCHEMA_GROUPS))) {
                        Customization.this.enableSchemaGroups = true;
                    } else {
                        Customization.this.enableSchemaGroups = false;
                    }
                    String glDetailSecionTitleClassName = attrs.getValue(DETAIL_SECTION_TITLE_CLASS);
                    if (glDetailSecionTitleClassName != null) {
                        Customization.this.globalDetailSectionTitleClass = this.getClass(glDetailSecionTitleClassName);
                    }
                    if ((globalTreeLabelClassName = attrs.getValue(TREE_LABEL_CLASS)) != null) {
                        Customization.this.globalTreeLabelClass = this.getClass(globalTreeLabelClassName);
                    }
                    String addButtonClassName = null;
                    addButtonClassName = attrs.getValue(ADDBUTTONCLASS);
                    if (addButtonClassName != null) {
                        Customization.this.addButtonClass = this.getClass(addButtonClassName);
                    }
                    if ((globalIconClassName = attrs.getValue(ICON_CLASS)) != null) {
                        Customization.this.globalIconClass = this.getClass(globalIconClassName);
                    }
                    Customization.this.hideOverviewSection = "true".equals(attrs.getValue(HIDE_OVERVIEW_SECTION));
                    String temp = attrs.getValue(OVERVIEW_SECTION_TITLE_DATA);
                    if (temp != null) {
                        stringTokenizer = new StringTokenizer(temp, ",");
                        paths = new String[stringTokenizer.countTokens()];
                        i = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            paths[i++] = "$" + stringTokenizer.nextToken().trim() + "$";
                        }
                        messageFormat = new MessageFormat(Customization.this.overviewSectionTitle);
                        Customization.this.overviewSectionTitle = messageFormat.format(paths);
                    }
                    Customization.this.overviewSectionTitleObject = null;
                    temp = attrs.getValue(OVERVIEW_SECTION_TITLE_CLASS);
                    if (temp != null && (headerLabelClass = this.getClass(temp)) != null) {
                        try {
                            object = headerLabelClass.newInstance();
                            if (object instanceof ICustomLabelObject) {
                                Customization.this.overviewSectionTitleObject = (ICustomLabelObject)object;
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                    Customization.this.overviewSectionDescription = this.getTranslation(attrs.getValue(OVERVIEW_SECTION_HEADER_TEXT));
                    Customization.this.editorTitle = this.getTranslation(attrs.getValue(EDITOR_TITLE));
                    if ("true".equals(attrs.getValue(ADD_CHILD_ELEMENT_HELPER))) {
                        Customization.this.addChildHelperEnabled = true;
                        String addChildElementHelperLimit = attrs.getValue(ADD_CHILD_ELEMENT_HELPER_LIMIT);
                        if (addChildElementHelperLimit != null && addChildElementHelperLimit.length() > 0) {
                            try {
                                Customization.this.addChildHelperLimit = Integer.parseInt(addChildElementHelperLimit);
                            }
                            catch (NumberFormatException numberFormatException) {
                                numberFormatException.printStackTrace();
                            }
                        }
                    }
                    if ((temp = attrs.getValue(OVERVIEW_SECTION_HEADER_TEXT_DATA)) != null) {
                        stringTokenizer = new StringTokenizer(temp, ",");
                        paths = new String[stringTokenizer.countTokens()];
                        i = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            paths[i++] = "$" + stringTokenizer.nextToken().trim() + "$";
                        }
                        messageFormat = new MessageFormat(Customization.this.overviewSectionDescription);
                        Customization.this.overviewSectionDescription = messageFormat.format(paths);
                    }
                    Customization.this.multipleDeletionObject = null;
                    temp = attrs.getValue(MULTIPLE_DELETION_CLASS);
                    if (temp != null && (multipleDeletionClass = this.getClass(temp)) != null) {
                        try {
                            object = multipleDeletionClass.newInstance();
                            if (object instanceof ICustomMultipleDeletionObject) {
                                Customization.this.multipleDeletionObject = (ICustomMultipleDeletionObject)object;
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                    Customization.this.overviewSectionDescriptionObject = null;
                    temp = attrs.getValue(OVERVIEW_SECTION_HEADER_TEXT_CLASS);
                    if (temp != null && (headerLabelClass = this.getClass(temp)) != null) {
                        try {
                            object = headerLabelClass.newInstance();
                            if (object instanceof ICustomLabelObject) {
                                Customization.this.overviewSectionDescriptionObject = (ICustomLabelObject)object;
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((temp = attrs.getValue(PRE_SELECTED_TREE_ELEMENT_CLASS)) != null && (preSelectedTreeElementClass = this.getClass(temp)) != null) {
                        try {
                            object = preSelectedTreeElementClass.newInstance();
                            if (object instanceof ICustomPreSelectedTreeObject) {
                                Customization.this.preSelectedTreeElementObject = (ICustomPreSelectedTreeObject)object;
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                    Customization.this.headerLabel = this.getTranslation(attrs.getValue(HEADER_LABEL));
                    temp = attrs.getValue(HEADER_LABEL_DATA);
                    if (temp != null) {
                        stringTokenizer = new StringTokenizer(temp, ",");
                        paths = new String[stringTokenizer.countTokens()];
                        i = 0;
                        while (stringTokenizer.hasMoreTokens()) {
                            paths[i++] = "$" + stringTokenizer.nextToken().trim() + "$";
                        }
                        messageFormat = new MessageFormat(Customization.this.headerLabel);
                        Customization.this.headerLabel = messageFormat.format(paths);
                    }
                    Customization.this.headerLabelObject = null;
                    temp = attrs.getValue(HEADER_LABEL_CLASS);
                    if (temp != null && (headerLabelClass = this.getClass(temp)) != null) {
                        try {
                            object = headerLabelClass.newInstance();
                            if (object instanceof ICustomLabelObject) {
                                Customization.this.headerLabelObject = (ICustomLabelObject)object;
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((temp = attrs.getValue(HEADER_ICON)) != null && (fileURL = FileLocator.find((Bundle)this.bundle, (IPath)new Path(iconPath = temp), null)) != null) {
                        try {
                            Customization.this.headerIcon = DDEPlugin.getDefault().getImageFromRegistry(iconPath);
                            if (Customization.this.headerIcon == null) {
                                InputStream inputStream = fileURL.openStream();
                                Customization.this.headerIcon = new Image((Device)Display.getDefault(), inputStream);
                                DDEPlugin.getDefault().getImageRegistry().put(iconPath, Customization.this.headerIcon);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if ((temp = attrs.getValue(HEADER_ACTIONS)) != null) {
                        ArrayList actions = new ArrayList();
                        StringTokenizer stringTokenizer2 = new StringTokenizer(temp, ",");
                        while (stringTokenizer2.hasMoreTokens()) {
                            String token = stringTokenizer2.nextToken().trim();
                            Class actionClass = this.getClass(token);
                            if (actionClass == null) continue;
                            try {
                                Object object2 = actionClass.newInstance();
                                if (!(object2 instanceof Action)) continue;
                                actions.add(object2);
                            }
                            catch (IllegalAccessException e) {
                                e.printStackTrace();
                            }
                            catch (InstantiationException e) {
                                e.printStackTrace();
                            }
                        }
                        Customization.access$3602(Customization.this, actions.toArray(new Action[actions.size()]));
                    }
                    if (FALSE.equals(temp = attrs.getValue(DISPLAY_DOCUMENTATION_AS_HOVER_HELP))) {
                        Customization.this.displayDocumentationAsHoverHelp = false;
                    } else {
                        Customization.this.displayDocumentationAsHoverHelp = true;
                    }
                    temp = attrs.getValue(TREE_SORTING_PREFERENCE);
                    if (temp != null) {
                        if (SORTED.equals(temp)) {
                            Customization.this.treeSortingPreference = 1;
                        } else if (UNSORTED.equals(temp)) {
                            Customization.this.treeSortingPreference = 2;
                        } else if (ALWAYS_SORTED.equals(temp)) {
                            Customization.this.treeSortingPreference = 3;
                        } else if (ALWAYS_UNSORTED.equals(temp)) {
                            Customization.this.treeSortingPreference = 4;
                        } else if ("default".equals(temp)) {
                            Customization.this.treeSortingPreference = 0;
                        }
                    } else {
                        Customization.this.treeSortingPreference = 0;
                    }
                    temp = attrs.getValue(DETAILS_SORTING_PREFERENCE);
                    if (temp != null) {
                        if (SORT_BY_SCHEMA.equals(temp)) {
                            Customization.this.detailsSortingPreference = 1;
                        } else if ("default".equals(temp)) {
                            Customization.this.detailsSortingPreference = 0;
                        } else {
                            Customization.this.detailsSortingPreference = 0;
                        }
                    } else {
                        Customization.this.detailsSortingPreference = 0;
                    }
                    temp = attrs.getValue(TREE_SORT_CONFIRMATION_MESSAGE);
                    if (temp != null) {
                        Customization.this.treeSortConfirmationMessage = this.getTranslation(temp);
                    }
                    if ((temp = attrs.getValue(TREE_UNSORT_CONFIRMATION_MESSAGE)) != null) {
                        Customization.this.treeUnsortConfirmationMessage = this.getTranslation(temp);
                    }
                    if ((temp = attrs.getValue(EMPTY_ELEMENT_CUSTOM_CONTROL_CLASS)) != null && (emptyElementCustomControlClass = this.getClass(temp)) != null) {
                        try {
                            object = emptyElementCustomControlClass.newInstance();
                            if (object instanceof ICustomControlObject3) {
                                Customization.this.emptyElementCustomControlObject = (ICustomControlObject3)object;
                            }
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InstantiationException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private class CustomizationAddOn {
        private String customizationID;
        private String customizationFile;
        private String customizationFilePath;
        private String customizationPropertiesFile;
        private String customizationPropertiesFilePath;
        private boolean debugMode;
        private IConfigurationElement configurationElement;
        private int priority;

        public CustomizationAddOn(String customizationID, String customizationFile, String customizationPropertiesFile, boolean debugMode, IConfigurationElement configurationElement, int priority) {
            this.customizationID = customizationID;
            this.customizationFile = customizationFile;
            this.customizationPropertiesFile = customizationPropertiesFile;
            this.debugMode = debugMode;
            this.configurationElement = configurationElement;
            this.priority = priority;
            Bundle bundle = Platform.getBundle((String)configurationElement.getContributor().getName());
            try {
                this.customizationFilePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(customizationFile), null)).toExternalForm();
                this.customizationPropertiesFilePath = FileLocator.toFileURL((URL)FileLocator.find((Bundle)bundle, (IPath)new Path(customizationPropertiesFile), null)).toExternalForm();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getCustomizationID() {
            return this.customizationID;
        }

        public String getCustomizationFile() {
            return this.customizationFile;
        }

        public String getCustomizationFilePath() {
            return this.customizationFilePath;
        }

        public String getCustomizationPropertiesFile() {
            return this.customizationPropertiesFile;
        }

        public String getCustomizationPropertiesFilePath() {
            return this.customizationPropertiesFilePath;
        }

        public boolean isDebugMode() {
            return this.debugMode;
        }

        public IConfigurationElement getConfigurationElement() {
            return this.configurationElement;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    public class FileMonitor
    extends Thread {
        File[] files;
        long[] lastModified;
        Customization[] customizationReferences;
        private final String FILE_SCHEME = "file:/";

        public FileMonitor() {
            Customization[] customizations = CustomizationManager.this.customizationMap.values().toArray(new Customization[CustomizationManager.this.customizationMap.size()]);
            ArrayList<File> filesList = new ArrayList<File>();
            ArrayList<Customization> customizationReferencesList = new ArrayList<Customization>();
            for (int i = 0; i < customizations.length; ++i) {
                String path;
                if (!customizations[i].debugMode || (path = customizations[i].getCustomizationFilePath()) == null) continue;
                if ("file:/".equals(path.substring(0, "file:/".length()))) {
                    path = path.substring("file:/".length());
                }
                filesList.add(new File(path));
                customizationReferencesList.add(customizations[i]);
                path = customizations[i].getCustomizationPropertiesFilePath();
                if (path == null) continue;
                if ("file:/".equals(path.substring(0, "file:/".length()))) {
                    path = path.substring("file:/".length());
                }
                filesList.add(new File(path));
                customizationReferencesList.add(customizations[i]);
            }
            for (CustomizationAddOn customizationAddOn : CustomizationManager.this.customizationAddOns) {
                String path;
                if (!customizationAddOn.isDebugMode() || (path = customizationAddOn.getCustomizationFilePath()) == null) continue;
                if ("file:/".equals(path.substring(0, "file:/".length()))) {
                    path = path.substring("file:/".length());
                }
                filesList.add(new File(path));
                customizationReferencesList.add((Customization)CustomizationManager.this.customizationMap.get(customizationAddOn.getCustomizationID()));
                path = customizationAddOn.getCustomizationPropertiesFilePath();
                if (path == null) continue;
                if ("file:/".equals(path.substring(0, "file:/".length()))) {
                    path = path.substring("file:/".length());
                }
                filesList.add(new File(path));
                customizationReferencesList.add((Customization)CustomizationManager.this.customizationMap.get(customizationAddOn.getCustomizationID()));
            }
            this.files = filesList.toArray(new File[filesList.size()]);
            this.customizationReferences = customizationReferencesList.toArray(new Customization[customizationReferencesList.size()]);
            this.lastModified = new long[this.files.length];
            for (int i = 0; i < this.files.length; ++i) {
                this.lastModified[i] = this.files[i].lastModified();
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    FileMonitor.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                boolean modified = false;
                for (int i = 0; i < this.files.length; ++i) {
                    if (this.files[i].lastModified() == this.lastModified[i]) continue;
                    this.customizationReferences[i].parse();
                    this.lastModified[i] = this.files[i].lastModified();
                    modified = true;
                }
                if (!modified) continue;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow[] workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                        for (int i = 0; i < workbenchWindows.length; ++i) {
                            IWorkbenchWindow workbenchWindow = workbenchWindows[i];
                            IWorkbenchPage[] workbenchPages = workbenchWindow.getPages();
                            for (int j = 0; j < workbenchPages.length; ++j) {
                                IWorkbenchPage workbenchPage = workbenchPages[j];
                                IEditorReference[] editorReferences = workbenchPage.getEditorReferences();
                                for (int k = 0; k < editorReferences.length; ++k) {
                                    IEditorReference editorReference = editorReferences[k];
                                    IWorkbenchPart workbenchPart = editorReference.getPart(true);
                                    if (!(workbenchPart instanceof DDEMultiPageEditorPart)) continue;
                                    DDEMultiPageEditorPart ddeMultiPageEditorPart = (DDEMultiPageEditorPart)workbenchPart;
                                    ddeMultiPageEditorPart.getValidationManager().validateDocument();
                                    ddeMultiPageEditorPart.showCustomizedTitle();
                                    ddeMultiPageEditorPart.refresh();
                                }
                            }
                        }
                    }
                });
            }
        }
    }
}

