/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xwt.dde.internal.actions;

import com.ibm.xwt.dde.customization.ICustomCreationObject;
import com.ibm.xwt.dde.editor.DDEMultiPageEditorPart;
import com.ibm.xwt.dde.internal.customization.CustomizationManager;
import com.ibm.xwt.dde.internal.customization.DetailItemCustomization;
import com.ibm.xwt.dde.internal.messages.Messages;
import com.ibm.xwt.dde.internal.util.ModelUtil;
import com.ibm.xwt.dde.internal.viewers.DDEViewer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AddElementAction
extends Action {
    private Element parentElement;
    private CMElementDeclaration cmElementDeclaration;
    private DDEViewer ddeViewer;
    private IEditorPart editorPart;
    private Image image;
    private CustomizationManager.Customization customization;

    public AddElementAction(Element parentElement, CMElementDeclaration cmElementDeclaration, DDEViewer ddeViewer, IEditorPart editorPart, CustomizationManager.Customization customization) {
        super(cmElementDeclaration.getElementName());
        this.parentElement = parentElement;
        this.cmElementDeclaration = cmElementDeclaration;
        this.ddeViewer = ddeViewer;
        this.editorPart = editorPart;
        this.customization = customization;
    }

    public void run() {
        if (((DDEMultiPageEditorPart)this.editorPart).validateEditorInput()) {
            boolean newLineRequired;
            boolean parentNodeFormatRequired;
            IDOMModel model;
            Element element;
            block26: {
                String namespace = ModelUtil.getNamespaceURI((CMNode)this.cmElementDeclaration);
                String path = ModelUtil.getNodeFullPath(this.parentElement, (CMNode)this.cmElementDeclaration);
                DetailItemCustomization itemCustomization = null;
                if (this.customization != null && (itemCustomization = this.customization.getItemCustomization(namespace, path)) == null) {
                    itemCustomization = this.customization.getTypeCustomizationConsideringUnions((CMNode)this.cmElementDeclaration, path);
                }
                String itemLabel = null;
                Class creationClass = null;
                if (itemCustomization != null) {
                    itemLabel = itemCustomization.getCreationLabel();
                    if (itemLabel == null) {
                        itemLabel = itemCustomization.getLabel();
                    }
                    creationClass = itemCustomization.getCreationClass();
                }
                if (itemLabel == null) {
                    itemLabel = this.cmElementDeclaration.getElementName();
                }
                MessageFormat messageFormat = new MessageFormat(Messages.ADD);
                this.ddeViewer.getUndoManager().beginRecording((Object)this, messageFormat.format(new String[]{itemLabel}));
                element = null;
                model = ((IDOMNode)this.parentElement).getModel();
                model.aboutToChangeModel();
                parentNodeFormatRequired = false;
                newLineRequired = false;
                if (creationClass != null) {
                    Element[] elementTreeChildrenBeforeCustomCode = ModelUtil.getElementTreeChildren(this.customization, this.parentElement);
                    try {
                        Object object = creationClass.newInstance();
                        if (!(object instanceof ICustomCreationObject)) break block26;
                        ICustomCreationObject customCreationObject = (ICustomCreationObject)object;
                        element = customCreationObject.create(this.parentElement, this.editorPart);
                        if (element == null) {
                            Element[] elementTreeChildrenAfterCustomCode = ModelUtil.getElementTreeChildren(this.customization, this.parentElement);
                            if (elementTreeChildrenBeforeCustomCode.length < elementTreeChildrenAfterCustomCode.length) {
                                List<Element> elementsBeforeCustomCode = Arrays.asList(elementTreeChildrenBeforeCustomCode);
                                List<Element> elementsAfterCustomCode = Arrays.asList(elementTreeChildrenAfterCustomCode);
                                Iterator<Element> iterator = elementsAfterCustomCode.iterator();
                                while (iterator.hasNext() && element == null) {
                                    Element currentObject = iterator.next();
                                    if (elementsBeforeCustomCode.indexOf(currentObject) != -1) continue;
                                    element = currentObject;
                                    newLineRequired = true;
                                }
                            }
                            break block26;
                        }
                        newLineRequired = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    Object object;
                    this.ddeViewer.getTreeViewer().expandToLevel((Object)this.parentElement, 1);
                    ModelQuery modelQuery = ModelQueryUtil.getModelQuery((Document)this.parentElement.getOwnerDocument());
                    boolean append = false;
                    Node refChild = this.parentElement.getLastChild();
                    if (modelQuery.canInsert(this.parentElement, (CMNode)this.cmElementDeclaration, this.parentElement.getChildNodes().getLength(), 2)) {
                        append = true;
                    } else {
                        Node targetChild = refChild;
                        for (int i = this.parentElement.getChildNodes().getLength(); !modelQuery.canInsert(this.parentElement, (CMNode)this.cmElementDeclaration, i, 2) && i > 0; --i) {
                            if ((refChild = refChild.getPreviousSibling()).getNodeType() != 1) continue;
                            targetChild = refChild;
                        }
                        refChild = targetChild;
                        if (refChild == null) {
                            refChild = this.parentElement.getFirstChild();
                        }
                    }
                    Document document = this.parentElement.getNodeType() == 9 ? (Document)((Object)this.parentElement) : this.parentElement.getOwnerDocument();
                    DOMContentBuilderImpl domContentBuilder = new DOMContentBuilderImpl(document);
                    if (document.getDocumentElement() != this.parentElement) {
                        NodeList childNodes = this.parentElement.getChildNodes();
                        parentNodeFormatRequired = childNodes == null || childNodes.getLength() == 0 || childNodes.getLength() == 1 && childNodes.item(0).getNodeType() == 3 && childNodes.item(0).getNodeValue().trim().length() == 0;
                    }
                    domContentBuilder.setBuildPolicy(0);
                    domContentBuilder.build((Node)this.parentElement, (CMNode)this.cmElementDeclaration);
                    List list = domContentBuilder.getResult();
                    for (Node newNode : list) {
                        if (newNode.getNodeType() == 2) {
                            Element parent = this.parentElement;
                            parent.setAttributeNode((Attr)newNode);
                            continue;
                        }
                        if (append) {
                            this.parentElement.appendChild(newNode);
                            newLineRequired = true;
                            continue;
                        }
                        this.parentElement.insertBefore(newNode, refChild);
                    }
                    if (list.size() > 0 && (object = list.get(0)) instanceof Element) {
                        element = (Element)object;
                        ModelUtil.removeBlankCreatedRepeatableItems(element, this.customization);
                        ModelUtil.assignDefaultValues(element, this.customization, this.editorPart);
                    }
                }
            }
            if (element != null) {
                element = ModelUtil.recursivelyCompressEmptyElementTags(element);
                if (newLineRequired) {
                    Text textNode = this.parentElement.getOwnerDocument().createTextNode(System.getProperty("line.separator"));
                    this.parentElement.appendChild(textNode);
                }
                if (parentNodeFormatRequired) {
                    ModelUtil.formatXMLNode(this.parentElement);
                } else {
                    ModelUtil.formatXMLNode(element);
                }
                model.changedModel();
                this.ddeViewer.getValidationManager().validateTreeNode(element, true, false, false);
                this.ddeViewer.getValidationManager().validateTreeNode(this.parentElement, false, true, false);
                this.ddeViewer.updateValidationInformation();
                this.ddeViewer.getTreeViewer().setExpandedState((Object)this.parentElement, true);
                this.ddeViewer.getTreeViewer().setExpandedState((Object)element, true);
                this.ddeViewer.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)element), true);
            } else {
                model.changedModel();
            }
            this.ddeViewer.getUndoManager().endRecording((Object)this);
        }
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }
}

