/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.docker.core.internal.launch;

import com.ibm.ws.st.common.core.ext.internal.UnsupportedServiceException;
import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractLaunchConfigurationExtension;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.IPlatformHandler;
import com.ibm.ws.st.common.core.ext.internal.setuphandlers.PlatformHandlerFactory;
import com.ibm.ws.st.common.core.ext.internal.util.AbstractDockerMachine;
import com.ibm.ws.st.common.core.ext.internal.util.BaseDockerContainer;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.launch.LaunchUtilities;
import com.ibm.ws.st.docker.core.internal.AbstractModeSwitchHandler;
import com.ibm.ws.st.docker.core.internal.Activator;
import com.ibm.ws.st.docker.core.internal.Messages;
import com.ibm.ws.st.docker.core.internal.Trace;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerRunUtility;
import com.ibm.ws.st.docker.core.internal.launch.LibertyDockerServer;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class LibertyDockerLaunchConfiguration
extends AbstractLaunchConfigurationExtension {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        AbstractModeSwitchHandler handler;
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.logError("Could not find the server for launch configuration: " + configuration.getName(), null);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", Messages.dockerServerLaunchFailed));
        }
        WebSphereServer websphereServer = (WebSphereServer)server.getAdapter(WebSphereServer.class);
        WebSphereServerBehaviour websphereServerBehaviour = (WebSphereServerBehaviour)server.loadAdapter(WebSphereServerBehaviour.class, null);
        IRuntime runtime = server.getRuntime();
        if (runtime == null) {
            Trace.logError("The runtime was null for server:  " + server.getName(), null);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", Messages.dockerServerLaunchFailed));
        }
        WebSphereRuntime wsRuntime = (WebSphereRuntime)runtime.loadAdapter(WebSphereRuntime.class, null);
        if (websphereServer == null || websphereServerBehaviour == null || wsRuntime == null) {
            Trace.logError("Could not get WebSphere server information for server:  " + server.getName(), null);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", Messages.dockerServerLaunchFailed));
        }
        this.setDefaultSourceLocator(launch, configuration);
        websphereServerBehaviour.setLaunch(launch);
        if (monitor.isCanceled()) {
            return;
        }
        if (server.getServerState() == 2) {
            return;
        }
        Map serviceInfo = websphereServer.getServiceInfo();
        LibertyDockerServer serverExt = (LibertyDockerServer)((Object)websphereServer.getAdapter(LibertyDockerServer.class));
        if (serviceInfo == null || serverExt == null) {
            Trace.logError("The service info or server extension was null so failed to launch: " + websphereServer.getServerName(), null);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", Messages.dockerServerLaunchFailed));
        }
        String currentMode = serverExt.getCurrentMode(websphereServer);
        if (!mode.equals(currentMode) && !Boolean.getBoolean("wtp.autotest.noninteractive") && (handler = Activator.getModeSwitchHandler()) != null) {
            handler.handleExecutionModeSwitch(websphereServer);
        }
        try {
            IPlatformHandler handler2;
            AbstractDockerMachine machine;
            List containerNames;
            websphereServerBehaviour.stopMonitorThread();
            websphereServerBehaviour.setServerAndModuleState(1);
            String containerName = serverExt.getContainerName(websphereServer);
            String machineType = (String)serviceInfo.get("dockerMachineType");
            String machineName = (String)serviceInfo.get("dockerMachine");
            String osName = (String)serviceInfo.get("osName");
            boolean isLooseConfig = websphereServer.isLooseConfigEnabled();
            boolean isLooseConfigContainer = serverExt.getCurrentLooseConfigMode(websphereServer);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Container is enabled for loose config: " + isLooseConfigContainer + ".  Server is configured for loose config: " + isLooseConfig);
            }
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Docker information - containerName=" + containerName + " machineName=" + machineName + " osName=" + osName);
            }
            if (!(containerNames = (machine = AbstractDockerMachine.createDockerMachine((String)machineType, (String)machineName, (IPlatformHandler)(handler2 = PlatformHandlerFactory.getPlatformHandler((Map)serviceInfo, (PlatformHandlerFactory.PlatformType)PlatformHandlerFactory.PlatformType.COMMAND)))).getContainerNames(true)).contains(containerName)) {
                Trace.logError("Last container used for server " + websphereServer.getServerName() + " does not exist: " + containerName, null);
                String origContainerName = (String)serviceInfo.get("dockerContainer");
                if (!origContainerName.equals(containerName)) {
                    if (containerNames.contains(origContainerName)) {
                        Trace.logError("Reverting to the original container: " + origContainerName, null);
                        containerName = origContainerName;
                        serverExt.setCurrentRunStatus(origContainerName, "run", true, false, websphereServer);
                    } else {
                        return;
                    }
                }
            }
            serviceInfo.put("dockerContainer", containerName);
            BaseDockerContainer container = (BaseDockerContainer)PlatformHandlerFactory.getPlatformHandler((Map)serviceInfo, (PlatformHandlerFactory.PlatformType)PlatformHandlerFactory.PlatformType.DOCKER);
            this.launchContainer(container, mode, monitor, websphereServer);
            websphereServerBehaviour.startMonitorThread();
        }
        catch (UnsupportedServiceException e) {
            websphereServerBehaviour.setServerAndModuleState(4);
            Trace.logError("Failed to launch server: " + websphereServer.getServerName(), e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", Messages.E_RemoteServerActionsUnavailable));
        }
        catch (CoreException ce) {
            websphereServerBehaviour.setServerAndModuleState(4);
            Trace.logError("Failed to launch server: " + websphereServer.getServerName(), ce);
            throw ce;
        }
        catch (Exception e) {
            websphereServerBehaviour.setServerAndModuleState(4);
            Trace.logError("Failed to launch server: " + websphereServer.getServerName(), e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", e.getLocalizedMessage()));
        }
    }

    public void launchStartedServer(String launchMode, ServerBehaviourDelegate serverBehaviour) throws CoreException {
        WebSphereServer websphereServer;
        block12: {
            IServer server = serverBehaviour.getServer();
            WebSphereServerBehaviour websphereServerBehaviour = (WebSphereServerBehaviour)server.loadAdapter(WebSphereServerBehaviour.class, (IProgressMonitor)new NullProgressMonitor());
            if (websphereServerBehaviour == null) {
                Trace.logError("Could not get WebSphereServerBehaviour for server: " + server.getName(), null);
                return;
            }
            websphereServer = websphereServerBehaviour.getWebSphereServer();
            ILaunch launch = server.getLaunch();
            if (launch == null && server.getServerState() == 2) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)8, "Issuing launch on server " + websphereServer.getServerDisplayName() + " to create a launch artifact and set up source computer.");
                }
                server.start(launchMode, (IProgressMonitor)new NullProgressMonitor());
            }
            boolean isDebugMode = "debug".equals(launchMode);
            try {
                LibertyDockerServer serverExt = (LibertyDockerServer)((Object)websphereServer.getAdapter(LibertyDockerServer.class));
                if (serverExt == null) {
                    Trace.logError("The server extension was null so failed to launch: " + websphereServer.getServerName(), null);
                    throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", Messages.dockerServerLaunchFailed));
                }
                if (!isDebugMode || launch == null) break block12;
                BaseDockerContainer container = serverExt.getContainer(websphereServer);
                String port = LibertyDockerRunUtility.getDebugPort(container);
                int debugPort = Integer.parseInt(port = container.getHostMappedPort(port));
                if (!websphereServerBehaviour.isDebugAttached(debugPort, server)) {
                    IDebugTarget oldDebugTarget = websphereServerBehaviour.getDebugTarget();
                    LaunchUtilities.connectRemoteDebugClient((ILaunch)launch, (int)debugPort, (WebSphereServer)websphereServer);
                    if (oldDebugTarget != null && !websphereServerBehaviour.getDebugTarget().isDisconnected() && !websphereServerBehaviour.getDebugTarget().isTerminated()) {
                        oldDebugTarget.disconnect();
                    }
                    break block12;
                }
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Skipping the debug attach since the debug process is already attached");
                }
                try {
                    DebugPlugin.getDefault().getLaunchManager().removeLaunch(launch);
                }
                catch (Exception e2) {
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Cannot terminate the failed debug launch process.", e2);
                    }
                }
            }
            catch (Exception e) {
                if (!Trace.ENABLED) break block12;
                Trace.trace((byte)0, "Could not attach debugger.", e);
            }
        }
        LaunchUtilities.updateServerConfig((WebSphereServer)websphereServer);
    }

    private void launchContainer(BaseDockerContainer container, String mode, IProgressMonitor monitor, WebSphereServer websphereServer) throws CoreException {
        WebSphereServerBehaviour websphereServerBehaviour = websphereServer.getWebSphereServerBehaviour();
        websphereServerBehaviour.ensureMonitorRunning();
        websphereServerBehaviour.preLaunch(monitor);
        try {
            String newContainerName = this.startContainer(container, mode, websphereServerBehaviour.getWebSphereServer(), monitor);
            if (newContainerName != null) {
                LibertyDockerServer serverExt = (LibertyDockerServer)((Object)websphereServer.getAdapter(LibertyDockerServer.class));
                serverExt.setCurrentRunStatus(newContainerName, mode, false, websphereServer.isLooseConfigEnabled(), websphereServer);
            }
        }
        catch (CoreException e) {
            Trace.logError("Failed to start container " + container.getContainerName() + " in " + mode + " mode.", e);
            throw e;
        }
        catch (Exception e) {
            Trace.logError("Failed to start container: " + container.getContainerName() + " in " + mode + " mode.", e);
            throw new CoreException((IStatus)new Status(4, "com.ibm.ws.st.docker.core", e.getLocalizedMessage()));
        }
        websphereServerBehaviour.postLaunch(true);
        this.launchStartedServer(mode, (ServerBehaviourDelegate)websphereServerBehaviour);
    }

    private String startContainer(BaseDockerContainer container, String mode, WebSphereServer server, IProgressMonitor progressMonitor) throws Exception {
        boolean copyingFilesRequired;
        boolean hasNewVolumes;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        AbstractDockerMachine machine = container.getDockerMachine();
        LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
        Map serviceInfo = server.getServiceInfo();
        String currentMode = serverExt.getCurrentMode(server);
        boolean modeNotChanged = mode.equals(currentMode);
        boolean bl = hasNewVolumes = server.isLooseConfigEnabled() && this.hasNewVolumes(server, serverExt, container);
        if (modeNotChanged && !this.isLooseConfigModeChanged(server) && !hasNewVolumes) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Mode has not changed for container: " + container.getContainerName() + ", so using the same container");
            }
            if (!container.isRunning()) {
                monitor.subTask(NLS.bind((String)Messages.dockerStartingContainerTask, (Object)container.getContainerName()));
                container.start((IProgressMonitor)monitor.newChild(100));
            }
            return null;
        }
        monitor.subTask(Messages.dockerCreatingContainerTask);
        String originalContainerName = (String)serviceInfo.get("dockerContainer");
        boolean isLooseConfigModeChanged = this.isLooseConfigModeChanged(server);
        boolean isUserContainer = serverExt.isUserContainer(server);
        List<String> newNames = LibertyDockerRunUtility.getNewNames(mode, (String)serviceInfo.get("dockerImage"), originalContainerName, machine, server.isLooseConfigEnabled(), isUserContainer, true);
        String newImageName = newNames.get(0);
        String newContainerName = newNames.get(1);
        LibertyDockerRunUtility.flattenImage(newImageName, serviceInfo, container, machine);
        List<String> cmd = null;
        boolean bl2 = copyingFilesRequired = isLooseConfigModeChanged && !server.isLooseConfigEnabled();
        cmd = !isLooseConfigModeChanged ? LibertyDockerRunUtility.getRunCommand(container, false, mode, currentMode, newContainerName, newImageName, server) : (copyingFilesRequired ? LibertyDockerRunUtility.getCreateCommand(container, isLooseConfigModeChanged, mode, currentMode, newContainerName, newImageName, server) : LibertyDockerRunUtility.getRunCommand(container, isLooseConfigModeChanged, mode, currentMode, newContainerName, newImageName, server));
        String originalTempPath = container.getMountSourceForDestination(LibertyDockerRunUtility.getLibertyUsrPath(serviceInfo));
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        monitor.worked(10);
        if (!serverExt.isUserContainer(server)) {
            block15: {
                String containerName = container.getContainerName();
                try {
                    String imageName = container.getImageName();
                    if (Trace.ENABLED) {
                        Trace.trace((byte)0, "Removing container: " + containerName + ", and image: " + imageName);
                    }
                    machine.removeContainer(containerName);
                    machine.removeImage(imageName);
                }
                catch (Exception e) {
                    if (!Trace.ENABLED) break block15;
                    Trace.trace((byte)1, "Failed to clean up old container and/or image for: " + containerName);
                }
            }
            if (monitor.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            monitor.worked(10);
        }
        monitor.setWorkRemaining(80);
        Trace.ENABLED = true;
        String cmdStr = LibertyDockerRunUtility.mergeStrings(cmd);
        if (Trace.ENABLED) {
            Trace.trace((byte)0, "Creating container: " + newContainerName + ", for image: " + newImageName + ", with command: " + cmdStr);
        }
        machine.runCommand(cmdStr, true, AbstractDockerMachine.DEFAULT_TIMEOUT * 5L, (IProgressMonitor)monitor.newChild(50));
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (copyingFilesRequired) {
            this.handleNonLooseConfig(newContainerName, server, currentMode, originalTempPath);
            if (monitor.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            monitor.worked(10);
            List<String> startCmd = LibertyDockerRunUtility.getStartCommand(newContainerName);
            String startCmdStr = LibertyDockerRunUtility.mergeStrings(startCmd);
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Starting container: " + newContainerName + ", with command: " + startCmdStr);
            }
            machine.runCommand(startCmdStr, true, AbstractDockerMachine.DEFAULT_TIMEOUT * 5L, (IProgressMonitor)monitor.newChild(20));
            if (Trace.ENABLED) {
                Trace.trace((byte)0, newContainerName + ", is started. ");
            }
        }
        monitor.setWorkRemaining(0);
        return newContainerName;
    }

    private boolean isLooseConfigModeChanged(WebSphereServer server) {
        LibertyDockerServer serverExt = (LibertyDockerServer)((Object)server.getAdapter(LibertyDockerServer.class));
        if (serverExt != null) {
            return server.isLooseConfigEnabled() != serverExt.getCurrentLooseConfigMode(server);
        }
        return false;
    }

    private void handleNonLooseConfig(String newContainerName, WebSphereServer websphereServer, String mode, String originalTempPath) throws Exception {
        Map serviceInfo = websphereServer.getServiceInfo();
        serviceInfo.put("dockerContainer", newContainerName);
        BaseDockerContainer newContainer = (BaseDockerContainer)PlatformHandlerFactory.getPlatformHandler((Map)serviceInfo, (PlatformHandlerFactory.PlatformType)PlatformHandlerFactory.PlatformType.DOCKER);
        websphereServer.getWebSphereServerBehaviour().stopMonitorThread();
        IPath tempPath = BaseDockerContainer.getContainerToLocalPath((IPath)new Path(originalTempPath));
        String serverConfigPath = (String)serviceInfo.get("libertyServerConfigPath");
        String usrFolder = serverConfigPath.replace("/servers/" + (String)serviceInfo.get("libertyServerName"), "/");
        try {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Copying files from " + tempPath + ", into container " + newContainerName + " " + usrFolder);
            }
            newContainer.copyIn(tempPath.toString() + "/.", usrFolder);
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Could not copy all the files from the usr folder to the new Docker container.  The new container could not be set up properly.", e);
            }
            throw e;
        }
    }

    private boolean hasNewVolumes(WebSphereServer server, LibertyDockerServer serverExt, BaseDockerContainer container) throws Exception {
        List<String> additionalVolumes = serverExt.getAdditionalVolumes(server);
        List<IPath> newVolumes = LibertyDockerRunUtility.getAdditionalVolumes(additionalVolumes, container);
        return !newVolumes.isEmpty();
    }
}

