/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.ui.rtexplorer.internal;

import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImplProvider;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Messages;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.liberty.buildplugin.integration.ui.rtexplorer.internal.LibertyBuildPluginProjectNode;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerCore;

public abstract class AbstractLibertyBuildPluginRuntimeContentProvider
implements ITreeContentProvider,
ILibertyBuildPluginImplProvider {
    public abstract LibertyBuildPluginProjectNode createRuntimeProjectNode(IProject var1, String var2, String var3, String var4);

    public Object[] getChildren(Object arg0) {
        return new Object[0];
    }

    public Object[] getElements(Object arg0) {
        Set<LibertyBuildPluginProjectNode> nodes = this.getAllBuildPluginProjectNodes();
        return nodes.toArray();
    }

    public Set<LibertyBuildPluginProjectNode> getAllBuildPluginProjectNodes() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        HashSet<IProject> allBuildPluginProjects = new HashSet<IProject>(projects.length);
        for (IProject project : projects) {
            if (!project.isOpen() || !this.getBuildPluginImpl().isSupportedProject(project, (IProgressMonitor)new NullProgressMonitor())) continue;
            allBuildPluginProjects.add(project);
        }
        HashSet<LibertyBuildPluginProjectNode> nodes = new HashSet<LibertyBuildPluginProjectNode>(allBuildPluginProjects.size());
        Set<String> trackedProjectNames = this.getBuildPluginImpl().getMappingHandler().getMappedProjectSet();
        for (String p : trackedProjectNames) {
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(p);
            if (proj != null) {
                allBuildPluginProjects.remove(proj);
                continue;
            }
            Trace.logError("Project " + p + " is tracked but was not found in the workspace", null);
        }
        for (IProject proj : allBuildPluginProjects) {
            LibertyBuildPluginConfiguration config = this.getBuildPluginImpl().getLibertyBuildPluginConfiguration(proj, (IProgressMonitor)new NullProgressMonitor());
            String installDir = null;
            String description = "";
            String text = proj.getName();
            if (config != null) {
                installDir = config.getConfigValue(ConfigurationType.installDirectory);
                description = NLS.bind((String)Messages.createServerActionDescription, (Object)proj.getName(), (Object)installDir);
            }
            text = WebSphereUtil.getUniqueRuntimeName((String)NLS.bind((String)Messages.runtimeLabel, (Object)proj.getName()), (IRuntime[])ServerCore.getRuntimes());
            LibertyBuildPluginProjectNode node = this.createRuntimeProjectNode(proj, text, installDir, description);
            nodes.add(node);
        }
        return nodes;
    }

    public Object getParent(Object arg0) {
        return null;
    }

    public boolean hasChildren(Object arg0) {
        return false;
    }
}

