/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.liberty.buildplugin.integration.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereServer;
import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.config.Bootstrap;
import com.ibm.ws.st.core.internal.config.ConfigurationDropinsFolder;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.core.internal.config.ExtendedConfigFile;
import com.ibm.ws.st.core.internal.config.JVMOptions;
import com.ibm.ws.st.core.internal.config.ServerEnv;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ConfigurationType;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.ILibertyBuildPluginImplProvider;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.LibertyBuildPluginConfiguration;
import com.ibm.ws.st.liberty.buildplugin.integration.internal.Trace;
import com.ibm.ws.st.ui.internal.CustomServerConfigTreeNode;
import com.ibm.ws.st.ui.internal.DomXmlDocumentFileCache;
import com.ibm.ws.st.ui.internal.custom.ICustomServerConfig;
import com.ibm.ws.st.ui.internal.utility.PathUtil;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.core.IServer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractCustomServerConfig
implements ICustomServerConfig,
ILibertyBuildPluginImplProvider {
    public List<Object> getCustomServerElements(IServer server) {
        String configValue;
        LibertyBuildPluginConfiguration libertyBuildPluginProjectConfiguration;
        ArrayList<Object> serverConfigElements = new ArrayList<Object>();
        WebSphereServer webSphereServer = (WebSphereServer)server.loadAdapter(WebSphereServer.class, null);
        WebSphereServerInfo webSphereServerInfo = webSphereServer.getServerInfo();
        if (webSphereServerInfo == null) {
            return serverConfigElements;
        }
        IProject mappedProject = this.getBuildPluginImpl().getMappingHandler().getMappedProject(server);
        if (mappedProject != null && (libertyBuildPluginProjectConfiguration = this.getBuildPluginImpl().getLibertyBuildPluginConfiguration(mappedProject, (IProgressMonitor)new NullProgressMonitor())) != null && (configValue = libertyBuildPluginProjectConfiguration.getConfigValue(ConfigurationType.configFile)) != null) {
            try {
                ConfigurationDropinsFolder dropinsFolder;
                ExtendedConfigFile jvmOptions;
                ExtendedConfigFile targetServerEnvFile;
                Bootstrap targetBootstrapPropertiesFile;
                URI jvmOptionsFileURI;
                String jvmOptionsFile;
                URI serverEnvFileURI;
                String serverEnvFile;
                URI bootstrapFileURI;
                String bootstrapPropertiesFile;
                URI fileURI = PathUtil.getURIForFilePath((String)configValue);
                if (fileURI != null) {
                    ConfigurationFile configurationFile = new ConfigurationFile(fileURI, webSphereServer.getUserDirectory(), webSphereServerInfo);
                    Document document = DomXmlDocumentFileCache.getInstance().getDocument(configurationFile);
                    if (document != null) {
                        serverConfigElements.add(document.getDocumentElement());
                    }
                }
                if ((bootstrapPropertiesFile = libertyBuildPluginProjectConfiguration.getConfigValue(ConfigurationType.bootstrapPropertiesFile)) != null && (bootstrapFileURI = PathUtil.getURIForFilePath((String)bootstrapPropertiesFile)) != null) {
                    Bootstrap bootstrap = new Bootstrap(new File(bootstrapPropertiesFile), PathUtil.getBestIFileMatchForURI((URI)bootstrapFileURI));
                    serverConfigElements.add(bootstrap);
                }
                if ((serverEnvFile = libertyBuildPluginProjectConfiguration.getConfigValue(ConfigurationType.serverEnv)) != null && (serverEnvFileURI = PathUtil.getURIForFilePath((String)serverEnvFile)) != null) {
                    ServerEnv serverEnv = new ServerEnv(new File(serverEnvFile), PathUtil.getBestIFileMatchForURI((URI)serverEnvFileURI));
                    serverConfigElements.add(serverEnv);
                }
                if ((jvmOptionsFile = libertyBuildPluginProjectConfiguration.getConfigValue(ConfigurationType.jvmOptionsFile)) != null && (jvmOptionsFileURI = PathUtil.getURIForFilePath((String)jvmOptionsFile)) != null) {
                    JVMOptions jvmOptions2 = new JVMOptions(new File(jvmOptionsFile), PathUtil.getBestIFileMatchForURI((URI)jvmOptionsFileURI));
                    serverConfigElements.add(jvmOptions2);
                }
                ArrayList<Element> children = new ArrayList<Element>();
                CustomServerConfigTreeNode customServerConfigTreeNode = new CustomServerConfigTreeNode(this.getCustomConfigurationNodeLabel(), this.getCustomConfigurationNodeImage(), children);
                serverConfigElements.add(customServerConfigTreeNode);
                ConfigurationFile configFile = webSphereServer.getConfiguration();
                if (configFile != null) {
                    Document targetServerConfig = DomXmlDocumentFileCache.getInstance().getDocument(configFile);
                    children.add(targetServerConfig.getDocumentElement());
                }
                if ((targetBootstrapPropertiesFile = webSphereServerInfo.getBootstrap()) != null) {
                    children.add((Element)targetBootstrapPropertiesFile);
                }
                if ((targetServerEnvFile = webSphereServerInfo.getServerEnv()) != null) {
                    children.add((Element)targetServerEnvFile);
                }
                if ((jvmOptions = webSphereServerInfo.getJVMOptions(webSphereServerInfo.getServerPath())) != null) {
                    children.add((Element)jvmOptions);
                }
                if ((dropinsFolder = webSphereServerInfo.getConfigurationDropinsFolder()) != null) {
                    children.add((Element)dropinsFolder);
                }
            }
            catch (Exception exception) {
                Trace.logError("Error encountered while attempting to create build plugin objects in servers view", exception);
            }
        }
        return serverConfigElements;
    }

    protected abstract Image getCustomConfigurationNodeImage();

    protected abstract String getCustomConfigurationNodeLabel();
}

