/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.common.ui.internal.commands;

import com.ibm.ws.st.common.ui.internal.commands.AbstractServerCommand;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServerWorkingCopy;

public class SetServerBooleanAttributeCommand
extends AbstractServerCommand {
    protected boolean newValue;
    protected boolean oldValue;

    public SetServerBooleanAttributeCommand(String label, IServerWorkingCopy curServer, String key, boolean value) {
        super(label, curServer, key);
        this.newValue = value;
    }

    public IStatus execute(IProgressMonitor mon, IAdaptable adaptable) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        try {
            this.oldValue = this.curServer.getAttribute(this.key, this.oldValue);
            this.curServer.setAttribute(this.key, this.newValue);
        }
        catch (Exception e) {
            status = new Status(4, "com.ibm.ws.st.common.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }

    public IStatus redo(IProgressMonitor mon, IAdaptable adaptable) throws ExecutionException {
        return this.execute(mon, adaptable);
    }

    public IStatus undo(IProgressMonitor mon, IAdaptable adaptable) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        try {
            this.curServer.setAttribute(this.key, this.oldValue);
        }
        catch (Exception e) {
            status = new Status(4, "com.ibm.ws.st.common.ui", e.getLocalizedMessage(), (Throwable)e);
        }
        return status;
    }
}

