/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.util;

import com.ibm.ws.kernel.feature.internal.util.ImageInfo;
import com.ibm.ws.kernel.feature.internal.util.Images;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ImageReader {
    public static final String FEATURES_FILE_NAME = "features.xml";
    public static final String XML_INPUT_FEATURE_OPEN = "<feature>";
    public static final String XML_INPUT_FEATURE_CLOSE = "</feature>";

    public static List<File[]> selectImageDirs(File rootFile) {
        File[] imageFiles = rootFile.listFiles();
        ArrayList<File[]> imageDirs = new ArrayList<File[]>(imageFiles.length);
        for (File imageFile : imageFiles) {
            File featuresFile;
            if (!imageFile.isDirectory() || !(featuresFile = new File(imageFile, FEATURES_FILE_NAME)).exists()) continue;
            imageDirs.add(new File[]{imageFile, featuresFile});
        }
        return imageDirs;
    }

    public static Images readImages(Collection<File[]> imageDirs) throws IOException {
        Images images = new Images(imageDirs.size());
        for (File[] imageFiles : imageDirs) {
            File imageDir = imageFiles[0];
            File imageFile = imageFiles[1];
            String imageName = imageDir.getName();
            List<String> features = ImageReader.readFeatures(imageFile);
            images.put(new ImageInfo(imageName, features));
        }
        return images;
    }

    public static List<String> readFeatures(File imageFile) throws IOException {
        ArrayList<String> features = new ArrayList<String>();
        try (FileInputStream inputStream = new FileInputStream(imageFile);
             InputStreamReader baseReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(baseReader);){
            String nextLine;
            while ((nextLine = reader.readLine()) != null) {
                if ((nextLine = nextLine.trim()).isEmpty() || !nextLine.startsWith(XML_INPUT_FEATURE_OPEN) || !nextLine.endsWith(XML_INPUT_FEATURE_CLOSE)) continue;
                int startPos = XML_INPUT_FEATURE_OPEN.length();
                int endPos = nextLine.length() - XML_INPUT_FEATURE_CLOSE.length();
                String feature = nextLine.substring(startPos, endPos);
                features.add(feature);
            }
        }
        return features;
    }
}

