/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolver;
import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.jee.core.internal.JEEConstants;
import com.ibm.ws.st.jee.core.internal.Trace;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class JSPFeatureResolver
extends FeatureResolver {
    private static final String[] JSP_EXTENSIONS = new String[]{".jsp", ".jspf", ".jsw", ".jsv", ".jspx"};
    private static final int SEARCH_LIMIT = 500;

    private static boolean requiresJSPFeature(IModule module, IProgressMonitor monitor) {
        ModuleDelegate moduleDelegate = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, monitor);
        if (moduleDelegate == null) {
            return false;
        }
        try {
            IModuleResource[] members = moduleDelegate.members();
            ArrayDeque<IModuleResource> queue = new ArrayDeque<IModuleResource>(members.length + 20);
            int size = members.length;
            if (size > 500) {
                size = 500;
            }
            for (int i = 0; i < size; ++i) {
                queue.add(members[i]);
            }
            for (int count = 0; count < 500 && !queue.isEmpty(); ++count) {
                IModuleResource mr = (IModuleResource)queue.poll();
                if (mr instanceof IModuleFolder) {
                    IModuleFolder folder = (IModuleFolder)mr;
                    members = folder.members();
                    if (members == null) continue;
                    size = members.length;
                    if (size > 500 - count) {
                        size = 500 - count;
                    }
                    for (int i = 0; i < size; ++i) {
                        queue.add(members[i]);
                    }
                    continue;
                }
                if (!(mr instanceof IModuleFile)) continue;
                for (String s : JSP_EXTENSIONS) {
                    if (!mr.getName().endsWith(s)) continue;
                    return true;
                }
            }
        }
        catch (CoreException ce) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Problem scanning module members for jsp files", ce);
            }
            return false;
        }
        return false;
    }

    private static boolean requiresJSPFeature(IModule module, IModuleResourceDelta[] delta, IProgressMonitor monitor) {
        if (delta == null) {
            return false;
        }
        ArrayDeque<IModuleResourceDelta> queue = new ArrayDeque<IModuleResourceDelta>(50);
        for (IModuleResourceDelta delta2 : delta) {
            queue.add(delta2);
        }
        for (int count = 0; count < 500 && !queue.isEmpty(); ++count) {
            IModuleResourceDelta mrd = (IModuleResourceDelta)queue.poll();
            IModuleResource mr = mrd.getModuleResource();
            if (mr instanceof IModuleFolder) {
                IModuleResourceDelta[] members = mrd.getAffectedChildren();
                if (members == null) continue;
                int size = members.length;
                if (size > 500 - count) {
                    size = 500 - count;
                }
                for (int i = 0; i < size; ++i) {
                    queue.add(members[i]);
                }
                continue;
            }
            if (!(mr instanceof IModuleFile) || mrd.getKind() == 3) continue;
            for (String s : JSP_EXTENSIONS) {
                if (!mr.getName().endsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    public void getRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatures, boolean includeAll, IProgressMonitor monitor) {
        for (int i = 0; i < moduleList.size(); ++i) {
            IModuleResourceDelta[] delta;
            IModule[] module = moduleList.get(i);
            IModuleResourceDelta[] iModuleResourceDeltaArray = delta = deltaList == null ? null : deltaList.get(i);
            if ((delta == null || !JSPFeatureResolver.requiresJSPFeature(module[module.length - 1], delta, monitor)) && !JSPFeatureResolver.requiresJSPFeature(module[module.length - 1], monitor)) continue;
            FeatureResolver.checkAndAddFeature((RequiredFeatureMap)requiredFeatures, (FeatureSet)existingFeatures, (WebSphereRuntime)wr, (FeatureResolverFeature)JEEConstants.FEATURE_JSP, Collections.singletonList(module), (boolean)includeAll);
        }
    }
}

