/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.jee.core.internal.Trace;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DeploymentDescriptorHelper {
    private static final String XML_FILENAME = "/WEB-INF/ibm-web-ext.xml";
    private static final String XMI_FILENAME = "/WEB-INF/ibm-web-ext.xmi";
    private static final String APP_XML_NAME = "/META-INF/application.xml";
    private static final String MODULE = "module";
    private static final String WEB = "web";
    private static final String WEB_URI = "web-uri";
    private static final String CONTEXT_ROOT = "context-root";

    public static String getContextRootFromExtXmi(IVirtualFolder root) {
        if (root == null) {
            return null;
        }
        Element top = DeploymentDescriptorHelper.getDocumentRoot(root, XMI_FILENAME);
        if (top == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Unable to read context root from xmi of " + root.getName() + " The document element was null.");
            }
            return null;
        }
        String context_root = top.getAttribute("contextRoot");
        if (!(context_root = context_root.trim()).isEmpty()) {
            return context_root;
        }
        return null;
    }

    public static String getContextRootFromExtXml(IVirtualFolder root) {
        if (root == null) {
            return null;
        }
        Element node = DeploymentDescriptorHelper.getDocumentRoot(root, XML_FILENAME);
        if (node == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Unable to read context root from xml of " + root.getName() + " The document element was null.");
            }
            return null;
        }
        Element element = DOMUtils.getFirstChildElement((Node)node, (String)CONTEXT_ROOT);
        if (element != null) {
            String context_root = element.getAttribute("uri");
            if (!(context_root = context_root.trim()).isEmpty()) {
                return context_root;
            }
        }
        return null;
    }

    public static IVirtualFolder getComponentRoot(IProject project) {
        if (project == null) {
            return null;
        }
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        return vc.getRootFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Element getDocumentRoot(IVirtualFolder root, String filePath) {
        if (root == null || filePath == null) {
            return null;
        }
        IVirtualFile vFile = root.getFile(filePath);
        IFile iFile = vFile.getUnderlyingFile();
        if (!iFile.exists()) {
            return null;
        }
        InputStream fileContent = null;
        try {
            fileContent = iFile.getContents();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(fileContent);
            Element element = doc.getDocumentElement();
            return element;
        }
        catch (Exception e) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Unable to get the document element of " + root.getName() + " / " + filePath, e);
            }
        }
        finally {
            if (fileContent != null) {
                try {
                    fileContent.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String getWebContextRootFromEAR(IVirtualFolder appRoot, String deploymentName) {
        if (appRoot == null || deploymentName == null) {
            return null;
        }
        Element node = DeploymentDescriptorHelper.getDocumentRoot(appRoot, APP_XML_NAME);
        if (node == null) {
            if (Trace.ENABLED) {
                Trace.trace((byte)1, "Unable to read application.xml for " + appRoot.getName() + " The document element was null.");
            }
            return null;
        }
        Element moduleElem = DOMUtils.getFirstChildElement((Node)node, (String)MODULE);
        while (moduleElem != null) {
            Element web_uri;
            Element web = DOMUtils.getFirstChildElement((Node)moduleElem, (String)WEB);
            if (web != null && deploymentName.equals(DOMUtils.getTextContent((Node)(web_uri = DOMUtils.getFirstChildElement((Node)web, (String)WEB_URI))))) {
                Element context_root = DOMUtils.getFirstChildElement((Node)web, (String)CONTEXT_ROOT);
                return DOMUtils.getTextContent((Node)context_root);
            }
            moduleElem = DOMUtils.getNextElement((Node)moduleElem, (String)MODULE);
        }
        return null;
    }
}

