/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.core.internal;

import com.ibm.ws.st.core.internal.FeatureResolver;
import com.ibm.ws.st.core.internal.FeatureResolverFeature;
import com.ibm.ws.st.core.internal.FeatureSet;
import com.ibm.ws.st.core.internal.RequiredFeatureMap;
import com.ibm.ws.st.core.internal.WebSphereRuntime;
import com.ibm.ws.st.jee.core.internal.JEEConstants;
import com.ibm.ws.st.jee.core.internal.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class CDIFeatureResolver
extends FeatureResolver {
    private static final String FILE_NAME = "beans.xml";
    private static final QName SCHEMA_QNAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
    private static final String ROOT_ELEM = "beans";
    private static final String VERSION_ATTR = "version";
    private static final String BEANS1_1 = "beans_1_1.xsd";
    private static final String BEANS2_0 = "beans_2_0.xsd";
    private static final Set<String> folderSet = new HashSet<String>();
    private static final Map<String, FeatureResolverFeature> cdiMap = new HashMap<String, FeatureResolverFeature>();

    public void getRequiredFeatures(WebSphereRuntime wr, List<IModule[]> moduleList, List<IModuleResourceDelta[]> deltaList, FeatureSet existingFeatures, RequiredFeatureMap requiredFeatures, boolean includeAll, IProgressMonitor monitor) {
        if (existingFeatures != null && existingFeatures.supports(JEEConstants.FEATURE_CDI.getName())) {
            return;
        }
        for (int i = 0; i < moduleList.size(); ++i) {
            IModule[] module = moduleList.get(i);
            IModule m = module[module.length - 1];
            IModuleResourceDelta[] delta = deltaList == null ? null : deltaList.get(i);
            IModuleResource resource = null;
            resource = delta != null ? CDIFeatureResolver.getBeansFile(m, delta, monitor) : CDIFeatureResolver.getBeansFile(m, monitor);
            if (resource == null) continue;
            File file = CDIFeatureResolver.getFile(resource);
            FeatureResolverFeature feature = null;
            feature = file != null ? CDIFeatureResolver.getFeature(file) : JEEConstants.FEATURE_CDI;
            FeatureResolver.checkAndAddFeature((RequiredFeatureMap)requiredFeatures, (FeatureSet)existingFeatures, (WebSphereRuntime)wr, (FeatureResolverFeature)feature, moduleList, (boolean)includeAll);
        }
    }

    private static IModuleResource getBeansFile(IModule module, IProgressMonitor monitor) {
        ModuleDelegate moduleDelegate = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, monitor);
        if (moduleDelegate == null) {
            return null;
        }
        try {
            IModuleResource[] members;
            for (IModuleResource member : members = moduleDelegate.members()) {
                IModuleResource[] folderMembers;
                if (!(member instanceof IModuleFolder) || !folderSet.contains(member.getName())) continue;
                for (IModuleResource folderMember : folderMembers = ((IModuleFolder)member).members()) {
                    if (!(folderMember instanceof IModuleFile) || !FILE_NAME.equals(folderMember.getName())) continue;
                    return folderMember;
                }
            }
        }
        catch (CoreException ce) {
            if (Trace.ENABLED) {
                Trace.trace((byte)0, "Problem scanning module members for beans.xml file", ce);
            }
            return null;
        }
        return null;
    }

    private static IModuleResource getBeansFile(IModule module, IModuleResourceDelta[] delta, IProgressMonitor monitor) {
        if (delta == null) {
            return null;
        }
        for (IModuleResourceDelta mrd : delta) {
            IModuleResourceDelta[] childDeltas;
            IModuleResource mr = mrd.getModuleResource();
            if (!(mr instanceof IModuleFolder) || !folderSet.contains(mr.getName())) continue;
            for (IModuleResourceDelta childDelta : childDeltas = mrd.getAffectedChildren()) {
                IModuleResource child = childDelta.getModuleResource();
                if (!(child instanceof IModuleFile) || !FILE_NAME.equals(child.getName()) || childDelta.getKind() == 3) continue;
                return child;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FeatureResolverFeature getFeature(File file) {
        String version;
        block17: {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = null;
            version = "1.0";
            try {
                reader = factory.createXMLStreamReader(new FileInputStream(file));
                if (!reader.hasNext()) break block17;
                reader.nextTag();
                if (!reader.isStartElement() || !ROOT_ELEM.equals(reader.getLocalName())) break block17;
                int count = reader.getAttributeCount();
                for (int i = 0; i < count; ++i) {
                    String value;
                    if (VERSION_ATTR.equals(reader.getAttributeLocalName(i))) {
                        version = reader.getAttributeValue(i);
                        break;
                    }
                    if (!SCHEMA_QNAME.equals(reader.getAttributeName(i)) || (value = reader.getAttributeValue(i)) == null) continue;
                    if (value.endsWith(BEANS1_1)) {
                        version = "1.1";
                        continue;
                    }
                    if (!value.endsWith(BEANS2_0)) continue;
                    version = "2.0";
                }
            }
            catch (Exception e) {
                if (Trace.ENABLED) {
                    Trace.trace((byte)0, "Problem parsing beans.xml file: " + file.getAbsolutePath(), e);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (XMLStreamException xMLStreamException) {}
                }
            }
        }
        if (cdiMap.containsKey(version)) {
            return cdiMap.get(version);
        }
        return JEEConstants.FEATURE_CDI;
    }

    private static File getFile(IModuleResource moduleResource) {
        IPath location;
        IFile iFile;
        File file = (File)moduleResource.getAdapter(File.class);
        if (file == null && (iFile = (IFile)moduleResource.getAdapter(IFile.class)) != null && (location = iFile.getLocation()) != null) {
            return new File(location.toString());
        }
        return file;
    }

    static {
        folderSet.add("WEB-INF");
        folderSet.add("META-INF");
        cdiMap.put("1.0", JEEConstants.FEATURE_CDI10);
        cdiMap.put("1.1", JEEConstants.FEATURE_CDI12);
        cdiMap.put("2.0", JEEConstants.FEATURE_CDI20);
    }
}

