/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.ui.internal;

import com.ibm.ws.st.core.internal.APIVisibility;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.jee.core.internal.SharedLibRefInfo;
import com.ibm.ws.st.jee.core.internal.SharedLibertyUtils;
import com.ibm.ws.st.jee.ui.internal.Messages;
import com.ibm.ws.st.jee.ui.internal.SWTUtil;
import com.ibm.ws.st.jee.ui.internal.Trace;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;

public class UtilityProjectSharedLibPropertiesPage
extends PropertyPage {
    protected Text libIdText;
    protected Text libDirectoryText;
    protected IProject project;
    protected Properties settings = new Properties();
    protected String libId = "";
    protected String libDirectory = "";
    protected Button apiVisibilityCheckboxAPI;
    protected Button apiVisibilityCheckboxIBMAPI;
    protected Button apiVisibilityCheckboxSpec;
    protected Button apiVisibilityCheckboxStable;
    protected Button apiVisibilityCheckboxThirdParty;
    protected EnumSet<APIVisibility> apiVisibility;

    protected Control createContents(Composite parent) {
        this.loadSettings();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(784);
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 64);
        label.setText(Messages.sharedLibDescription);
        data = new GridData(1, 4, false, false);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setText(Messages.sharedLibId);
        data = new GridData(1, 0x1000000, false, false);
        data.verticalIndent = 8;
        label.setLayoutData((Object)data);
        this.libIdText = new Text(composite, 2048);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        data.verticalIndent = 8;
        this.libIdText.setLayoutData((Object)data);
        this.libIdText.setText(this.libId);
        label = new Label(composite, 0);
        label.setText(Messages.sharedLibDirectory);
        data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.libDirectoryText = new Text(composite, 2048);
        data = new GridData(4, 0x1000000, true, false);
        this.libDirectoryText.setLayoutData((Object)data);
        this.libDirectoryText.setText(this.libDirectory);
        Button browse = SWTUtil.createButton(composite, Messages.browse);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(UtilityProjectSharedLibPropertiesPage.this.getShell());
                dialog.setMessage(Messages.sharedLibBrowseMessage);
                dialog.setFilterPath(UtilityProjectSharedLibPropertiesPage.this.libDirectoryText.getText());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    UtilityProjectSharedLibPropertiesPage.this.libDirectoryText.setText(selectedDirectory);
                }
            }
        });
        Group group = new Group(composite, 16);
        group.setText(Messages.sharedLibAPIVisibilityLabel);
        data = new GridData(1, 4, true, false);
        data.horizontalSpan = 3;
        data.minimumWidth = 130;
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout());
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                UtilityProjectSharedLibPropertiesPage.this.setValid(UtilityProjectSharedLibPropertiesPage.this.isValid());
            }
        };
        this.apiVisibilityCheckboxAPI = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxAPI.setText(Messages.sharedLibAPIVisibilityAPI);
        this.apiVisibilityCheckboxAPI.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxIBMAPI = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxIBMAPI.setText(Messages.sharedLibAPIVisibilityIBMAPI);
        this.apiVisibilityCheckboxIBMAPI.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxSpec = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxSpec.setText(Messages.sharedLibAPIVisibilitySpec);
        this.apiVisibilityCheckboxSpec.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxStable = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxStable.setText(Messages.sharedLibAPIVisibilityStable);
        this.apiVisibilityCheckboxStable.addSelectionListener((SelectionListener)selectionListener);
        this.apiVisibilityCheckboxThirdParty = new Button((Composite)group, 32);
        this.apiVisibilityCheckboxThirdParty.setText(Messages.sharedLibAPIVisibilityThirdParty);
        this.apiVisibilityCheckboxThirdParty.addSelectionListener((SelectionListener)selectionListener);
        this.updateAPIVisibilityCheckboxValues(this.apiVisibility);
        return composite;
    }

    protected void updateAPIVisibilityCheckboxValues(EnumSet<APIVisibility> apiVisibility) {
        this.apiVisibilityCheckboxAPI.setSelection(apiVisibility.contains(APIVisibility.API));
        this.apiVisibilityCheckboxIBMAPI.setSelection(apiVisibility.contains(APIVisibility.IBM_API));
        this.apiVisibilityCheckboxSpec.setSelection(apiVisibility.contains(APIVisibility.SPEC));
        this.apiVisibilityCheckboxStable.setSelection(apiVisibility.contains(APIVisibility.STABLE));
        this.apiVisibilityCheckboxThirdParty.setSelection(apiVisibility.contains(APIVisibility.THIRD_PARTY));
    }

    protected void loadSettings() {
        IAdaptable element = this.getElement();
        this.project = (IProject)element.getAdapter(IProject.class);
        if (this.project == null) {
            return;
        }
        this.settings = SharedLibertyUtils.getUtilPrjSharedLibInfo((IProject)this.project);
        this.libId = this.settings.getProperty("com.ibm.ws.st.jee.shared.library.id", "");
        this.libDirectory = this.settings.getProperty("com.ibm.ws.st.jee.shared.library.dir", "");
        this.apiVisibility = APIVisibility.getAPIVisibilityFromProperties((Properties)this.settings);
    }

    protected void saveSettings() {
        if (this.project == null) {
            return;
        }
        IPath path = this.project.getLocation().append(".settings/com.ibm.ws.st.shared.library");
        SharedLibertyUtils.saveSettings((Properties)this.settings, (IPath)path);
    }

    public boolean isValid() {
        return this.apiVisibilityCheckboxAPI.getSelection() || this.apiVisibilityCheckboxIBMAPI.getSelection() || this.apiVisibilityCheckboxSpec.getSelection() || this.apiVisibilityCheckboxStable.getSelection() || this.apiVisibilityCheckboxThirdParty.getSelection();
    }

    public boolean performOk() {
        boolean isIdDifferent;
        String id = this.libIdText.getText().trim();
        String dir = this.libDirectoryText.getText().trim();
        boolean apiVisibilityChanged = this.apiVisibilityChanged();
        boolean bl = isIdDifferent = !this.libId.equals(id);
        if (apiVisibilityChanged || isIdDifferent || !this.libDirectory.equals(dir)) {
            IProject sharedLibProject;
            boolean isNewIdEmpty = id.isEmpty();
            boolean isPublished = SharedLibertyUtils.isPublished((IProject)this.project);
            if (isNewIdEmpty && isPublished && !MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.sharedLibConfirmRemoveTitle, (String)NLS.bind((String)Messages.sharedLibConfirmRemoveMessage, (Object)this.project.getName()))) {
                return false;
            }
            MultiStatus status = new MultiStatus("com.ibm.ws.st.jee.ui", 0, null, null);
            ArrayList<IServer> publishServers = new ArrayList<IServer>();
            if (isPublished) {
                UtilityProjectSharedLibPropertiesPage.remove(this.project, publishServers, status);
            }
            this.settings.setProperty("com.ibm.ws.st.jee.shared.library.id", id);
            this.settings.setProperty("com.ibm.ws.st.jee.shared.library.dir", dir);
            if (apiVisibilityChanged) {
                this.settings.setProperty("com.ibm.ws.st.core.api.visibility.api", Boolean.toString(this.apiVisibilityCheckboxAPI.getSelection()));
                this.settings.setProperty("com.ibm.ws.st.core.api.visibility.ibmapi", Boolean.toString(this.apiVisibilityCheckboxIBMAPI.getSelection()));
                this.settings.setProperty("com.ibm.ws.st.core.api.visibility.spec", Boolean.toString(this.apiVisibilityCheckboxSpec.getSelection()));
                this.settings.setProperty("com.ibm.ws.st.core.api.visibility.stable", Boolean.toString(this.apiVisibilityCheckboxStable.getSelection()));
                this.settings.setProperty("com.ibm.ws.st.core.api.visibility.thirdparty", Boolean.toString(this.apiVisibilityCheckboxThirdParty.getSelection()));
            }
            this.saveSettings();
            IProject[] refProjects = isIdDifferent ? UtilityProjectSharedLibPropertiesPage.updateSharedLibRef(this.libId, id) : new IProject[]{};
            ArrayList<IServer> allServers = new ArrayList<IServer>(publishServers);
            IProject iProject = sharedLibProject = isPublished && !isNewIdEmpty ? this.project : null;
            if (refProjects.length > 0 || sharedLibProject != null) {
                UtilityProjectSharedLibPropertiesPage.update(sharedLibProject, refProjects, publishServers, allServers, status);
            }
            if (!allServers.isEmpty()) {
                UtilityProjectSharedLibPropertiesPage.publish(allServers);
            }
            if (!status.isOK()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.sharedLibServerUpdateFailedTitle, (String)Messages.sharedLibServerUpdateFailedMessage);
                Trace.logError(status.toString(), null);
            }
        }
        return true;
    }

    protected boolean apiVisibilityChanged() {
        return this.apiVisibilityCheckboxAPI.getSelection() != this.apiVisibility.contains(APIVisibility.API) || this.apiVisibilityCheckboxIBMAPI.getSelection() != this.apiVisibility.contains(APIVisibility.IBM_API) || this.apiVisibilityCheckboxSpec.getSelection() != this.apiVisibility.contains(APIVisibility.SPEC) || this.apiVisibilityCheckboxStable.getSelection() != this.apiVisibility.contains(APIVisibility.STABLE) || this.apiVisibilityCheckboxThirdParty.getSelection() != this.apiVisibility.contains(APIVisibility.THIRD_PARTY);
    }

    public void performDefaults() {
        this.libIdText.setText(this.libId);
        this.libDirectoryText.setText(this.libDirectory);
        this.updateAPIVisibilityCheckboxValues(APIVisibility.getDefaults());
    }

    private static void remove(IProject project, List<IServer> publishServers, MultiStatus status) {
        IServer[] servers;
        for (IServer server : servers = ServerCore.getServers()) {
            IModule[] modules = server.getModules();
            IModule publishedModule = null;
            for (IModule module : modules) {
                if (module.getProject() == null || !project.equals(module.getProject())) continue;
                publishedModule = module;
                break;
            }
            if (publishedModule == null) continue;
            IServerWorkingCopy wc = server.createWorkingCopy();
            try {
                wc.modifyModules(null, new IModule[]{publishedModule}, null);
                wc.save(true, null);
                publishServers.add(server);
            }
            catch (CoreException ce) {
                status.add((IStatus)new Status(4, "com.ibm.ws.st.jee.ui", "Failed to modify modules for server " + server.getName(), (Throwable)ce));
            }
        }
    }

    private static void update(IProject project, IProject[] refProjects, List<IServer> publishServers, List<IServer> allServers, MultiStatus status) {
        IServer[] servers;
        IModule sharedLibModule = project == null ? null : ServerUtil.getModule((IProject)project);
        for (IServer server : servers = ServerCore.getServers()) {
            IModule[] modules;
            ArrayList<IModule> addList = new ArrayList<IModule>(refProjects.length + 1);
            if (sharedLibModule != null && publishServers != null && publishServers.contains(server)) {
                addList.add(sharedLibModule);
            }
            block3: for (IModule module : modules = server.getModules()) {
                for (IProject refProject : refProjects) {
                    if (module.getProject() == null || !refProject.equals(module.getProject())) continue;
                    addList.add(module);
                    continue block3;
                }
            }
            if (addList.isEmpty()) continue;
            IModule[] add = addList.toArray(new IModule[addList.size()]);
            IServerWorkingCopy wc = server.createWorkingCopy();
            try {
                wc.modifyModules(add, null, null);
                wc.save(true, null);
                if (allServers.contains(server)) continue;
                allServers.add(server);
            }
            catch (CoreException ce) {
                status.add((IStatus)new Status(4, "com.ibm.ws.st.jee.ui", "Failed to modify modules on server " + server.getName(), (Throwable)ce));
            }
        }
    }

    private static IProject[] updateSharedLibRef(String oldId, String newId) {
        IProject[] projects;
        if (oldId == null || oldId.isEmpty()) {
            return new IProject[0];
        }
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            SharedLibRefInfo refInfo;
            List sharedLibRefs;
            int index;
            if (!SharedLibertyUtils.hasSharedLibSettingsFile((IProject)project, (String)".settings/com.ibm.ws.st.shared.library.ref") || (index = ConfigurationFile.LibRef.getListIndex((List)(sharedLibRefs = (refInfo = SharedLibertyUtils.getSharedLibRefInfo((IProject)project)).getLibRefs()), (String)oldId)) < 0) continue;
            if (newId == null || newId.isEmpty()) {
                sharedLibRefs.remove(index);
            } else {
                ConfigurationFile.LibRef oldRef = (ConfigurationFile.LibRef)sharedLibRefs.get(index);
                sharedLibRefs.set(index, new ConfigurationFile.LibRef(newId, oldRef.type));
            }
            projectList.add(project);
            refInfo.setLibRefs(sharedLibRefs);
            SharedLibertyUtils.saveSettings((Properties)refInfo, (IPath)project.getLocation().append(".settings/com.ibm.ws.st.shared.library.ref"));
        }
        projects = new IProject[projectList.size()];
        return projectList.toArray(projects);
    }

    static void publish(List<IServer> servers) {
        for (IServer server : servers) {
            if (!(server instanceof Server)) {
                if (!Trace.ENABLED) continue;
                Trace.trace((byte)1, "Expecting server " + server.getName() + " to be an instance of org.eclipse.wst.server.core.internal.Server");
                continue;
            }
            Server s = (Server)server;
            s.setServerPublishState(2);
        }
    }
}

