/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.jee.ui.internal;

import com.ibm.ws.st.core.internal.WebSphereServerInfo;
import com.ibm.ws.st.core.internal.WebSphereUtil;
import com.ibm.ws.st.core.internal.config.ConfigUtils;
import com.ibm.ws.st.core.internal.config.ConfigurationFile;
import com.ibm.ws.st.jee.core.internal.SharedLibertyUtils;
import com.ibm.ws.st.jee.core.internal.UtilitySharedLibInfo;
import com.ibm.ws.st.jee.ui.internal.Activator;
import com.ibm.ws.st.jee.ui.internal.Messages;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class SharedLibSelectionDialog
extends Dialog {
    protected String id = null;
    protected boolean isPrivate = false;
    protected List<ConfigurationFile.LibRef> currentRefs;

    public SharedLibSelectionDialog(Shell parent, List<ConfigurationFile.LibRef> currentRefs) {
        super(parent);
        this.currentRefs = currentRefs;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.sharedLibTitle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        WebSphereServerInfo[] servers;
        IProject[] projects;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 11;
        layout.marginWidth = 9;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.minimumWidth = 300;
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(Messages.sharedLibId);
        data = new GridData(1, 2, false, false);
        label.setLayoutData((Object)data);
        final Text idText = new Text(composite, 2048);
        data = new GridData(4, 2, true, false);
        idText.setLayoutData((Object)data);
        idText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                SharedLibSelectionDialog.this.id = idText.getText();
                SharedLibSelectionDialog.this.validate();
            }
        });
        label = new Label(composite, 0);
        label.setText(Messages.sharedLibExisting);
        data = new GridData(1, 1, false, false);
        label.setLayoutData((Object)data);
        final Tree libTree = new Tree(composite, 68356);
        data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        data.heightHint = 150;
        libTree.setLayoutData((Object)data);
        boolean found = false;
        Color bg = libTree.getBackground();
        Color fg = libTree.getForeground();
        final Color gray = new Color(bg.getDevice(), (bg.getRed() + fg.getRed()) / 2, (bg.getGreen() + fg.getGreen()) / 2, (bg.getBlue() + fg.getBlue()) / 2);
        libTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                gray.dispose();
            }
        });
        TreeItem workspaceItem = new TreeItem(libTree, 0);
        workspaceItem.setText(Messages.sharedLibWorkspace);
        Image img = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        workspaceItem.setImage(img);
        workspaceItem.setForeground(gray);
        for (IProject project : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            UtilitySharedLibInfo settings = SharedLibertyUtils.getUtilPrjSharedLibInfo((IProject)project);
            String libId = settings.getProperty("com.ibm.ws.st.jee.shared.library.id", null);
            if (libId == null) continue;
            TreeItem item = new TreeItem(workspaceItem, 0);
            item.setText(NLS.bind((String)Messages.sharedLibProject, (Object)libId, (Object)project.getName()));
            item.setImage(Activator.getImage("library"));
            item.setData((Object)libId);
            if (ConfigurationFile.LibRef.listContains(this.currentRefs, (String)libId)) {
                item.setForeground(gray);
            }
            found = true;
        }
        if (!found) {
            TreeItem item = new TreeItem(workspaceItem, 0);
            item.setText(Messages.sharedLibNone);
            item.setForeground(gray);
        }
        workspaceItem.setExpanded(true);
        for (WebSphereServerInfo ws : servers = WebSphereUtil.getWebSphereServerInfos()) {
            TreeItem serverItem = new TreeItem(libTree, 0);
            serverItem.setText(NLS.bind((String)Messages.sharedLibServer, (Object)ws.getServerName()));
            serverItem.setImage(Activator.getImage("server"));
            serverItem.setForeground(gray);
            ConfigurationFile configFile = ws.getConfigRoot();
            String[] ids = ConfigUtils.getSharedLibraryIds((ConfigurationFile)configFile);
            if (ids != null && ids.length > 0) {
                for (String s : ids) {
                    TreeItem item = new TreeItem(serverItem, 0);
                    item.setText(s);
                    item.setImage(Activator.getImage("library"));
                    item.setData((Object)s);
                    if (ConfigurationFile.LibRef.listContains(this.currentRefs, (String)s)) {
                        item.setForeground(gray);
                    }
                    found = true;
                }
            } else {
                TreeItem item = new TreeItem(serverItem, 0);
                item.setText(Messages.sharedLibNone);
                item.setForeground(gray);
            }
            serverItem.setExpanded(true);
        }
        libTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem[] items = libTree.getSelection();
                if (items == null || items.length != 1) {
                    return;
                }
                Object obj = items[0].getData();
                if (obj == null || !(obj instanceof String)) {
                    idText.setText("");
                    return;
                }
                idText.setText((String)obj);
            }
        });
        libTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                if (SharedLibSelectionDialog.this.isOKEnabled()) {
                    SharedLibSelectionDialog.this.okPressed();
                    SharedLibSelectionDialog.this.close();
                }
            }
        });
        label = new Label(composite, 0);
        final Button isPrivateButton = new Button(composite, 32);
        isPrivateButton.setText(Messages.sharedLibPrivateLabel);
        isPrivateButton.setToolTipText(Messages.sharedLibPrivateTooltip);
        isPrivateButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        isPrivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SharedLibSelectionDialog.this.isPrivate = isPrivateButton.getSelection();
            }
        });
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        this.validate();
        return control;
    }

    protected void validate() {
        boolean ok = false;
        if (this.id != null && !this.id.trim().isEmpty()) {
            ok = !ConfigurationFile.LibRef.listContains(this.currentRefs, (String)this.id);
        }
        this.getButton(0).setEnabled(ok);
    }

    public String getId() {
        return this.id;
    }

    public boolean getIsPrivate() {
        return this.isPrivate;
    }

    protected void okPressed() {
        super.okPressed();
    }

    protected boolean isOKEnabled() {
        return this.getButton(0).isEnabled();
    }
}

