/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.looseconfig;

import com.ibm.ws.st.common.core.ext.internal.servertype.AbstractServerBehaviourExtension;
import com.ibm.ws.st.core.internal.Trace;
import com.ibm.ws.st.core.internal.WebSphereServerBehaviour;
import com.ibm.ws.st.core.internal.looseconfig.DeploymentEntry;
import com.ibm.ws.st.core.internal.looseconfig.ProjectInfoHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;

public class LooseArchive {
    protected List<DeploymentEntry> deploymentEntries = new ArrayList<DeploymentEntry>();
    private final WebSphereServerBehaviour serverBehaviour;
    private final AbstractServerBehaviourExtension serverBehaviourExt;
    protected IPath defaultOutputPath = null;

    public List<DeploymentEntry> getDeploymentEntries() {
        return this.deploymentEntries;
    }

    public LooseArchive(IModule module) {
        this(module, null);
    }

    public LooseArchive(IModule module, WebSphereServerBehaviour serverBehaviour) {
        this.serverBehaviour = serverBehaviour;
        this.serverBehaviourExt = (AbstractServerBehaviourExtension)serverBehaviour.getAdapter(AbstractServerBehaviourExtension.class);
        this.process(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(IModule module) {
        IVirtualReference[] refs;
        IPath runtimePath;
        StructureEdit sEdit = null;
        Hashtable<IPath, IClasspathEntry> javaSourcePathEntries = new Hashtable<IPath, IClasspathEntry>();
        IProject project = module.getProject();
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IClasspathEntry[] javaClasspathEntries;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                this.defaultOutputPath = javaProject.getOutputLocation();
                for (IClasspathEntry entry : javaClasspathEntries = javaProject.getRawClasspath()) {
                    if (3 != entry.getEntryKind()) continue;
                    IPath path = entry.getPath().removeFirstSegments(1).makeAbsolute();
                    javaSourcePathEntries.put(path, entry);
                }
            }
        }
        catch (CoreException e) {
            Trace.logError("Problem to calculate the build path entires of " + project.getName(), e);
        }
        List<IResource> linkedResources = ProjectInfoHandler.parseProject(project);
        try {
            Object[] mappings;
            sEdit = StructureEdit.getStructureEditForRead((IProject)project);
            WorkbenchComponent wbc = sEdit.getComponent();
            for (Object o : mappings = wbc.getResources().toArray()) {
                IPath os;
                if (!(o instanceof ComponentResource)) continue;
                ComponentResource res = (ComponentResource)o;
                runtimePath = res.getRuntimePath();
                IPath source = res.getSourcePath().makeAbsolute();
                IPath outputPath = this.mappingDeploymentPathToOutputPath(project, source, javaSourcePathEntries);
                if (outputPath.segmentCount() == 1) {
                    IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(outputPath.lastSegment());
                    os = p.getLocation();
                } else {
                    IFile out = ResourcesPlugin.getWorkspace().getRoot().getFile(outputPath);
                    os = out.getLocation();
                }
                if (os != null) {
                    IPath mappedPath = null;
                    if (this.serverBehaviourExt != null && (mappedPath = this.serverBehaviourExt.getMappedPath(os, (ServerBehaviourDelegate)this.serverBehaviour)) != null) {
                        os = mappedPath;
                    }
                    String pathEntryUpdate = mappedPath != null ? os.toString() : os.toOSString();
                    DeploymentEntry de = new DeploymentEntry(runtimePath.toString(), pathEntryUpdate, 0, null);
                    if (!this.deploymentEntries.contains(de)) {
                        this.deploymentEntries.add(de);
                    }
                } else if (Trace.ENABLED) {
                    Trace.logError("Failed to get source location for: " + outputPath, null);
                }
                for (IResource resource : linkedResources) {
                    IPath resourcePath = resource.getFullPath();
                    if (!outputPath.isPrefixOf(resourcePath) || outputPath.equals((Object)resourcePath)) continue;
                    IPath resourceLocation = resource.getLocation();
                    if (resourceLocation != null) {
                        int type;
                        IPath relPath = resourcePath.makeRelativeTo(outputPath);
                        IPath targetPath = runtimePath.append(relPath);
                        int n = type = resource.getType() == 2 ? 0 : 1;
                        DeploymentEntry de = new DeploymentEntry(targetPath.toString(), resourceLocation.toOSString(), type, null);
                        if (this.deploymentEntries.contains(de)) continue;
                        this.deploymentEntries.add(de);
                        continue;
                    }
                    if (!Trace.ENABLED) continue;
                    Trace.logError("Failed to get source location for linked resource: " + resourcePath, null);
                }
            }
        }
        catch (Exception e) {
            Trace.logError("Exception in LooseArchive.", e);
        }
        finally {
            if (sEdit != null) {
                sEdit.dispose();
            }
        }
        if ("jst.utility".equals(module.getModuleType().getId())) {
            return;
        }
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        for (IVirtualReference ref : refs = vc.getReferences()) {
            IVirtualComponent component = ref.getReferencedComponent();
            if (component.isBinary()) {
                runtimePath = ref.getRuntimePath();
                String targetInArchive = runtimePath.append(ref.getArchiveName()).makeAbsolute().toString();
                if (!(component instanceof VirtualArchiveComponent)) continue;
                File file = (File)((VirtualArchiveComponent)component).getAdapter(File.class);
                if (file == null) {
                    Trace.logError("LooseConfig - the virtual component does not adapt to a File: " + ((VirtualArchiveComponent)component).getArchivePath(), null);
                    continue;
                }
                DeploymentEntry de = new DeploymentEntry(targetInArchive, file.getAbsolutePath(), 1, null);
                if (this.deploymentEntries.contains(de)) continue;
                this.deploymentEntries.add(de);
                continue;
            }
            if (!LooseArchive.canAddReferencedComponentClasspathDependencies(module, component.getProject())) continue;
            this.addReferencedComponentClasspathDependencies(ref);
        }
    }

    private IPath mappingDeploymentPathToOutputPath(IProject project, IPath dplymntPath, Hashtable<IPath, IClasspathEntry> javaSourcePathEntries) {
        String dPathS = dplymntPath.toPortableString();
        IPath tempPath = null;
        int tempLength = 0;
        Enumeration<IPath> enu = javaSourcePathEntries.keys();
        while (enu.hasMoreElements()) {
            IPath path = enu.nextElement();
            String s = path.toPortableString();
            if (!dPathS.startsWith(s) || s.length() <= tempLength) continue;
            tempPath = path;
            tempLength = s.length();
        }
        IPath resultPath = null;
        if (tempPath == null) {
            resultPath = project.getFullPath().append(dplymntPath);
        } else {
            IClasspathEntry entry = javaSourcePathEntries.get(tempPath);
            IPath output = entry.getOutputLocation();
            if (output == null) {
                output = this.defaultOutputPath;
            }
            if (!dplymntPath.equals((Object)tempPath)) {
                int d = dplymntPath.segmentCount();
                int b = tempPath.segmentCount();
                int c = d - b;
                IPath suffixPath = dplymntPath.removeFirstSegments(c);
                resultPath = output.append(suffixPath);
            } else {
                resultPath = output;
            }
        }
        if (resultPath == null) {
            Trace.logError("LooseConfig - Can't find the output of " + dplymntPath.toString() + " in " + project.getName(), null);
        }
        return resultPath;
    }

    public List<DeploymentEntry> getFilteredDeploymentEntries() {
        ArrayList<String> rootEntries = new ArrayList<String>();
        ArrayList<DeploymentEntry> nonRootEntries = new ArrayList<DeploymentEntry>();
        ArrayList<DeploymentEntry> filteredEntries = new ArrayList<DeploymentEntry>();
        for (DeploymentEntry de : this.deploymentEntries) {
            if ("/".equals(de.targetInArchive)) {
                rootEntries.add(de.sourceOnDisk);
                filteredEntries.add(de);
                continue;
            }
            nonRootEntries.add(de);
        }
        for (DeploymentEntry de : nonRootEntries) {
            if (this.isEntryImplicit(de, rootEntries)) continue;
            filteredEntries.add(de);
        }
        return filteredEntries;
    }

    private boolean isEntryImplicit(DeploymentEntry de, List<String> rootEntries) {
        for (String root : rootEntries) {
            Path targetInArchivePath;
            Path sourcePath;
            if (de.sourceOnDisk == null || !de.sourceOnDisk.startsWith(root) || !(sourcePath = new Path(de.sourceOnDisk.substring(root.length()))).equals((Object)(targetInArchivePath = new Path(de.targetInArchive)))) continue;
            return true;
        }
        return false;
    }

    private void addReferencedComponentClasspathDependencies(IVirtualReference reference) {
        IVirtualReference[] refs;
        IVirtualComponent referencedComponent = reference.getReferencedComponent();
        IPath runtimePath = reference.getRuntimePath();
        for (IVirtualReference ref : refs = referencedComponent.getReferences()) {
            DeploymentEntry de;
            IVirtualComponent component = ref.getReferencedComponent();
            if (!component.isBinary() || !(component instanceof VirtualArchiveComponent)) continue;
            File file = (File)((VirtualArchiveComponent)component).getAdapter(File.class);
            if (file == null) {
                Trace.logError("LooseConfig - the virtual component does not adapt to a File: " + ((VirtualArchiveComponent)component).getArchivePath(), null);
                continue;
            }
            IPath refRuntimePath = ref.getRuntimePath();
            if (!refRuntimePath.toString().startsWith("../") || this.deploymentEntries.contains(de = new DeploymentEntry((refRuntimePath = runtimePath.append(refRuntimePath.removeFirstSegments(1)).append(ref.getArchiveName())).toString(), file.getAbsolutePath(), 1, null))) continue;
            this.deploymentEntries.add(de);
        }
    }

    private static boolean canAddReferencedComponentClasspathDependencies(IModule module, IProject refProject) {
        String type = module.getModuleType().getId();
        if ("jst.web".equals(type) || "jst.ear".equals(type) || "jst.ejb".equals(type)) {
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)refProject);
                for (IProjectFacetVersion facet : facetedProject.getProjectFacets()) {
                    if (!"jst.utility".equals(facet.getProjectFacet().getId())) continue;
                    return true;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }
}

