/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.st.core.internal.config.validation;

import com.ibm.ws.st.core.internal.config.DOMUtils;
import com.ibm.ws.st.core.internal.config.DocumentLocation;
import com.ibm.ws.st.core.internal.config.validation.AbstractConfigurationValidator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidatorMessage;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceConfigurationValidator
extends AbstractConfigurationValidator {
    private final ValidationResult result = new ValidationResult();

    @Override
    protected void createMessage(String text, IResource resource, AbstractConfigurationValidator.Level level, Node node, AbstractConfigurationValidator.QuickFixData fixData) {
        ValidatorMessage message = ValidatorMessage.create((String)text, (IResource)resource);
        message.setType("com.ibm.ws.st.core.configmarker");
        message.setAttribute("severity", this.getSeverity(level));
        if (node != null) {
            AbstractConfigurationValidator.QuickFixType fixType;
            DocumentLocation docLocation = DocumentLocation.createDocumentLocation(node);
            if (docLocation.getLine() != -1) {
                message.setAttribute("lineNumber", docLocation.getLine());
                if (docLocation.getStartOffset() != -1 && docLocation.getEndOffset() != -1) {
                    message.setAttribute("charStart", docLocation.getStartOffset());
                    message.setAttribute("charEnd", docLocation.getEndOffset());
                }
            }
            if ((fixType = fixData.getFixType()) != AbstractConfigurationValidator.QuickFixType.NONE) {
                String xpath = DOMUtils.createXPath(node);
                message.setAttribute("quickFixTypeAttr", fixType.ordinal());
                message.setAttribute("xpathAttr", (Object)xpath);
                if (fixData.getBestMatch() != null) {
                    message.setAttribute("bestMatch", (Object)fixData.getBestMatch());
                }
                if (fixData.getUndefinedReferenceName() != null) {
                    message.setAttribute("referenceName", (Object)fixData.getUndefinedReferenceName());
                }
                if (fixData.getUndefinedReferenceOffset() >= 0) {
                    message.setAttribute("referenceOffset", fixData.getUndefinedReferenceOffset());
                }
                if (node.getNodeType() == 1) {
                    message.setAttribute("elementNodeName", (Object)node.getNodeName());
                } else if (node.getNodeType() == 2) {
                    Element elemNode = ((Attr)node).getOwnerElement();
                    if (elemNode != null) {
                        message.setAttribute("elementNodeName", (Object)elemNode.getNodeName());
                    }
                    message.setAttribute("attributeNodeName", (Object)node.getNodeName());
                }
                HashMap<String, Object> attributes = fixData.getAttributes();
                for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                    message.setAttribute(entry.getKey(), entry.getValue());
                }
            }
        }
        this.result.add(message);
    }

    public ValidationResult getValidationResult() {
        return this.result;
    }

    private int getSeverity(AbstractConfigurationValidator.Level level) {
        switch (level) {
            case INFO: {
                return 0;
            }
            case WARNING: {
                return 1;
            }
        }
        return 2;
    }
}

